require_relative '../../globalized'
include Globalized

describe "Story# HASS-24 [Assessment_Submit_Assessment_HASS_24_spec.rb]"  do

  before(:all) do
    initializeConfigurations(BASE_URL)
    deleteAssessmentResultsTable("D123401")
    initializeAllObjects
  end

  after(:all) do
    quitDriver()
  end

  it "AC#HASS-110|HASS-111|HASS-257|TC#:HASS-272: Verify that user will be prompt to submit the assessment, he'll be asked to confirm the submission and after submission, all required fields in the assessment are saved to backend DB.", :broken => true do
    #Accept Eula
    !45.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()
    
    #Passing by the landing page before the Eula
    @loginpage.passingByTheLandingPage()

    #Checking the DS Logon screen loaded
    !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran("zztest.patient01")

    !45.times{ break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    #Click the Left Side Toggle button
    @main.clickNavMenu()
    !45.times{ break if (getTextForElement(:id, "Assessments") == "Assessments"); sleep 1 }
    #Click Assessment button
    @navMenu.clickAssessmentBtn()

    #Click the assessment to display the Information screen
    hassID = @hassList.findIndexWithGivenName("Caregiver Status Summary")
    @hassList.clickThisAssessment(hassID)
    #Verify the name is displayed
    !45.times{ break if (@hassInfo.getAssessmentNameFromInfoPageHeader == "Caregiver Status Summary"); sleep 1 }
    expect(@hassInfo.getAssessmentNameFromInfoPageHeader()).to eq("Caregiver Status Summary")

    #Click Start Assessment button
    @hassInfo.clickStartAssessmentButton()
    !45.times{ break if (expect(@hassQuest.getQuestionNumText()).to eq("Question 1 of 4")); sleep 1 }
    #Verify that “Question 1 of X” is displayed
    expect(@hassQuest.getQuestionNumText()).to eq("Question 1 of 4")
    
    @hassQuest.selectOneRadioButton("Q1-option", "Rarely") #Question 1
    !45.times{ break if (@hassQuest.isTheNextButtonDisabled() == false); sleep 1 }
    
    #Click Next button
    @hassQuest.clickTheNextButton()
    !45.times{ break if (@hassQuest.getQuestionNumText() == "Question 2 of 4"); sleep 1 }
    
    #Proceed to fill out one more questions
    @hassQuest.selectOneRadioButton("Q2-option", "Rarely") #Question 2
    #$answerToThisQuestion = @hassQuest.isAnyRadioButtonChecked(2)
    
    !45.times{ break if (@hassQuest.isTheNextButtonDisabled() == false); sleep 1 }
    #Click Next button
    @hassQuest.clickTheNextButton()
    !45.times{ break if (@hassQuest.getQuestionNumText() == "Question 3 of 4"); sleep 1 }
    #Choose answer to Qeuestion
    @hassQuest.selectOneRadioButton("Q3-option", "Sometimes") #Question 3
    #Click Next button
    @hassQuest.clickTheNextButton()
    !45.times{ break if (@hassQuest.getQuestionNumText() == "Question 4 of 4"); sleep 1 }
    #Choose answer to Qeuestion
    @hassQuest.selectOneRadioButton("Q4-option", "Nearly Always") #Question 4
      
    #Verify that the Submit button is activated now
    expect(@hassQuest.verifyTheSubmitButtonIsDisabled()).to be false
    #Click the Submit button to submit the questionnaire
    @hassQuest.clickTheSubmitButton()
    
    #Wait for the Submit pop up to show up, then click the "Continue" button.
    !45.times{ break if (@modal.getConfirmationHeading() == "Submission Confirmation"); sleep 1 }
    #Verify that the pop up header is displayed
    expect(@modal.getConfirmationHeading()).to eq("Submission Confirmation")
    #Verify that the body of the message are displayed correctly
    expect(@modal.getNthConfirmationMessage(1)).to eq("You are submitting the Caregiver Status Summary for zztest patient01.")
    expect(@modal.getNthConfirmationMessage(2)).to eq("Once you submit an assessment you will no longer be able to edit your answers.")
    expect(@modal.getNthConfirmationMessage(3)).to eq("Select CONTINUE to proceed with the submission, or RETURN to return to the assessment in progress.")
    
    #Click Continue to finally submit the assessment to DB
    @modal.clickContinueButton()
    
    #Verify Submit saved the assessment to DB with all required fields
    #Get the current datetime
    time = Time.new
    #Refornat the datetime to "yyyy-mm-dd" format without the time stamp
    dateTaken = time.strftime("%Y-%m-%d")
    expect(verifyAllAssessmentInfoAreSaved("Caregiver Status Summary", "1.0", "D123401", dateTaken)).to be true
  end

  
end
