require_relative '../../globalized'
include Globalized

describe "Story# HASS-13 [Assessment_Sequential_Question_HASS_13_spec.rb]" do
  include DriverUtility

  before(:all) do
    initializeConfigurations(BASE_URL)
    deleteAssessmentResultsTable("D123401")
    initializeAllObjects
  end

  after(:all) do
    quitDriver()
  end

  it "AC#HASS-92|TC#:HASS-172: Verify that users can see an indication of which question they are on and the total number of questions (Question 1 of X)", :broken => true do
    #Accept Eula
    !45.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()
    
    #Passing by the landing page before the Eula
    @loginpage.passingByTheLandingPage()

    #Checking the DS Logon screen loaded
    !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran("zztest.patient01")

    !45.times{ break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    #Click the Left Side Toggle button
    @main.clickNavMenu()
    !45.times{ break if (getTextForElement(:id, "Assessments") == "Assessments"); sleep 1 }
    #Click Assessment button
    @navMenu.clickAssessmentBtn()

    #Click the assessment to display the Information screen
    hassID = @hassList.findIndexWithGivenName("Clinic in Hand Pilot Demographics")
    @hassList.clickThisAssessment(hassID)
    #Verify the name is displayed
    !45.times{ break if (@hassInfo.getAssessmentNameFromInfoPageHeader == "Clinic in Hand Pilot Demographics"); sleep 1 }
    expect(@hassInfo.getAssessmentNameFromInfoPageHeader()).to eq("Clinic in Hand Pilot Demographics")

    #Click Start Assessment button
    @hassInfo.clickStartAssessmentButton()
    !45.times{ break if (expect(@hassQuest.getQuestionNumText()).to eq("Question 1 of 14")); sleep 1 }
    #Verify that “Question 1 of X” is displayed
    expect(@hassQuest.getQuestionNumText()).to eq("Question 1 of 14")

  end

  it "AC#HASS-93|TC#:HASS-172: Verify the user can see the short name of the questionnaire", :broken => true do
    expect(@hassInfo.getAssessmentNameFromQuestionPageHeader()).to eq("Clinic in Hand Pilot Demographics")

  end

  it "AC#HASS-95|TC#:HASS-172: Verify the user can go back to the Information page by clicking Back; and user can go back to previous question by clicking Back", :broken => true do
    #Verify that clicking Back from the 1st question goes back to Information page
    @hassQuest.clickBackButton()
    !45.times{ break if (@hassInfo.getAssessmentNameFromInfoPageHeader == "Clinic in Hand Pilot Demographics"); sleep 1 }
    expect(@hassInfo.getAssessmentNameFromInfoPageHeader()).to eq("Clinic in Hand Pilot Demographics")
    #Verify that the Start Assessment button is visible
    expect(@hassInfo.isStartAssessmentButtonAvailable()).to be true
    #Click Start Assessment button to go back to the Questionnaire page
    @hassInfo.clickStartAssessmentButton()
    !45.times{ break if (@hassQuest.getQuestionNumText() == "Question 1 of 14"); sleep 1 }

    #Answer one question, click "Next"
    @hassQuest.selectOneRadioButton("Q1-option", "18 to 34") #Question 1, button 1

    if @hassQuest.isAnyRadioButtonChecked(1) != "" then # 1 means quesiton #1
      $answerToQuestion1 = @hassQuest.isAnyRadioButtonChecked(1)
      puts "The selected radio button is: " + $answerToQuestion1
    end
    
    !45.times{ break if (@hassQuest.isTheNextButtonDisabled() == false); sleep 1 }
    @hassQuest.clickTheNextButton()
    #Verify the page moves to Question 2
    !45.times{ break if (@hassQuest.getQuestionNumText()== "Question 2 of 14"); sleep 1 }
    expect(@hassQuest.getQuestionNumText()).to eq("Question 2 of 14")
    
    #Click the Back button
    sleep 2
    @hassQuest.clickBackButton()
    #Verify that the page moves to Question 1
    !45.times{ break if (@hassQuest.getQuestionNumText() == "Question 1 of 14"); sleep 1 }
    expect(@hassQuest.getQuestionNumText()).to eq("Question 1 of 14")
    
  end

  it "AC#HASS-99|TC#:HASS-172: Question responses persist during the session in which they are entered but are not saved to the server unless an explicit Save Draft or Submit action is taken", :broken => true do
    #Verify that the answer to Question 1 persist even when user moves to the next question and Back.
    if @hassQuest.isAnyRadioButtonChecked(1) == $answerToQuestion1 then
      puts "Successfully verified that answer to Question 1 persist during session even when user moves away from it"
    end
    
    #Since the Save button wasn't clicked in above steps, the answer was not saved when it quits and returns to the assessment again.
    #Click 'Caregiver Status Summary' from Assessment List again
    hassID = @hassList.findIndexWithGivenName("Clinic in Hand Pilot Demographics")
    @hassList.clickThisAssessment(hassID)
    
    #Verify that the Modal Dialog box is popped up
    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Confirmation")
    expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
    @modal.clickContinueButton()
    
    #Verify the name is displayed
    !45.times{ break if (@hassInfo.getAssessmentNameFromInfoPageHeader == "Clinic in Hand Pilot Demographics"); sleep 1 }
    expect(@hassInfo.getAssessmentNameFromInfoPageHeader()).to eq("Clinic in Hand Pilot Demographics")
    
    #Click Start Assessment 
    @hassInfo.clickStartAssessmentButton()
    !45.times{ break if (@hassQuest.getQuestionNumText() == "Question 1 of 14"); sleep 1 }
    
    sleep 2
    #Verify that the previously checked radio button on Quesiton #1 is not checked
    expect(@hassQuest.isAnyRadioButtonChecked(1)).to eq("")
    
  end

  it "AC#HASS-96|TC#:HASS-172: Verify user can not go to the Next question unless the current question is answered", :broken => true do
    #Scenario 1: Verify when none of the radio buttons is checked, the Next button is disabled
    expect(@hassQuest.verifyRadioButtonNotCheckedNextButtonDisabled(1)).to be true

    #Scenario 2: verify when one of the radio buttons is checked, the Next button is activated
    #Check one radio button
    @hassQuest.selectOneRadioButton("Q1-option", "18 to 34") #Question 1, button 1
    !45.times{ break if (@hassQuest.isTheNextButtonDisabled() == false); sleep 1 }
    expect(@hassQuest.verifyRadioButtonCheckedNextButtonActivated(1)).to be true

  end
  
  it "AC#HASS-98|TC#:HASS-172: Verify clicking Save Draft keeps the answer. Verify that user can't submit the questionnaire unless all questions are answered", :broken => true do
    #Click Save button
    @hassQuest.clickTheSaveButton()
    #Click "OK" button from Save Draft pop up
    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    @modal.clickOKFromSaveDraftConfirmation()
    
    #Click 'Clinic in Hand Pilot Demographics' from Assessment List again
    hassID = @hassList.findIndexWithGivenName("Clinic in Hand Pilot Demographics")
    @hassList.clickThisAssessment(hassID)
    #Verify the name is displayed
    !45.times{ break if (@hassInfo.getAssessmentNameFromInfoPageHeader == "Clinic in Hand Pilot Demographics"); sleep 1 }
    expect(@hassInfo.getAssessmentNameFromInfoPageHeader()).to eq("Clinic in Hand Pilot Demographics")
    
    #Click Start Assessment 
    @hassInfo.clickStartAssessmentButton()
    !45.times{ break if (@hassQuest.getQuestionNumText() == "Question 1 of 14"); sleep 1 }
      
    #Verify that the previously checked radio button is checked because the answer was explicitly saved
    @hassQuest.isAnyRadioButtonChecked(1) == $answerToQuestion1
    
    #Provide an answer for each question until the last page
    @hassQuest.clickTheNextButton()
    !45.times{ break if (@hassQuest.getQuestionNumText() == "Question 2 of 14"); sleep 1 }
    
    @hassQuest.selectOneRadioButton("Q2-option", "College grad") #Question 2, button value "College grad"
    
    !45.times{ break if (@hassQuest.isTheNextButtonDisabled() == false); sleep 1 }
    @hassQuest.clickTheNextButton()
    !45.times{ break if (@hassQuest.getQuestionNumText() == "Question 3 of 14"); sleep 1 }
    
    @hassQuest.checkOneOrMultiCheckBox(3, [1,3])
    !45.times{ break if (@hassQuest.isTheNextButtonDisabled() == false); sleep 1 }
    @hassQuest.clickTheNextButton()
    !45.times{ break if (@hassQuest.getQuestionNumText() == "Question 4 of 14"); sleep 1 }
      
    @hassQuest.selectOneRadioButton("Q4-option", "Female") #Question 4, button value "Female"
     
    !45.times{ break if (@hassQuest.isTheNextButtonDisabled() == false); sleep 1 }
    @hassQuest.clickTheNextButton()
    !45.times{ break if (@hassQuest.getQuestionNumText() == "Question 5 of 14"); sleep 1 }
       
    @hassQuest.selectOneRadioButton("Q5-option", "Yes") #Question 5, button value "Yes"
       
    !45.times{ break if (@hassQuest.isTheNextButtonDisabled() == false); sleep 1 }
    @hassQuest.clickTheNextButton()
    !45.times{ break if (@hassQuest.getQuestionNumText() == "Question 6 of 14"); sleep 1 }
      
    @hassQuest.checkOneOrMultiCheckBox(6, [7])
    !45.times{ break if (@hassQuest.isTheNextButtonDisabled() == false); sleep 1 }
    @hassQuest.clickTheNextButton()
    !45.times{ break if (@hassQuest.getQuestionNumText() == "Question 7 of 14"); sleep 1 }
      
    @hassQuest.checkOneOrMultiCheckBox(7, [7])
    !45.times{ break if (@hassQuest.isTheNextButtonDisabled() == false); sleep 1 }
    @hassQuest.clickTheNextButton()
    !45.times{ break if (@hassQuest.getQuestionNumText() == "Question 8 of 14"); sleep 1 }  
      
    @hassQuest.selectOneRadioButton("Q8-option", "21 to 40 hours") #Question 4, button value "21 to 40 hours"
     
    !45.times{ break if (@hassQuest.isTheNextButtonDisabled() == false); sleep 1 }
    @hassQuest.clickTheNextButton()
    !45.times{ break if (@hassQuest.getQuestionNumText() == "Question 9 of 14"); sleep 1 }
      
 
    @hassQuest.selectOneRadioButton("Q9-option", "Excellent") #Question 4, button value "Excellent"
     
    !45.times{ break if (@hassQuest.isTheNextButtonDisabled() == false); sleep 1 }
    @hassQuest.clickTheNextButton()
    !45.times{ break if (@hassQuest.getQuestionNumText() == "Question 10 of 14"); sleep 1 }
      
    @hassQuest.enterTheScaleAtRangeQuestion("Q10", "4")
    !45.times{ break if (@hassQuest.isTheNextButtonDisabled() == false); sleep 1 }
    if @hassQuest.isTheNextButtonDisabled() == false then 
      @hassQuest.clickTheNextButton()
      puts "succeed"
    end
    !45.times{ break if (@hassQuest.getQuestionNumText() == "Question 11 of 14"); sleep 1 }
      
    @hassQuest.enterTheScaleAtRangeQuestion("Q11", "4")
    !45.times{ break if (@hassQuest.isTheNextButtonDisabled() == false); sleep 1 }
    @hassQuest.clickTheNextButton()
    !45.times{ break if (@hassQuest.getQuestionNumText() == "Question 12 of 14"); sleep 1 }
      
    @hassQuest.selectOneRadioButton("Q12-option", "You tend to wait until a technology is widely used before you try it.") #Question 4, button value "You tend to wait until a technology is widely used before you try it."  
    !45.times{ break if (@hassQuest.isTheNextButtonDisabled() == false); sleep 1 }
    @hassQuest.clickTheNextButton()
    !45.times{ break if (@hassQuest.getQuestionNumText() == "Question 13 of 14"); sleep 1 }
      
    @hassQuest.enterTheScaleAtRangeQuestion("Q13", "3")
    !45.times{ break if (@hassQuest.isTheNextButtonDisabled() == false); sleep 1 }
    @hassQuest.clickTheNextButton()
    !45.times{ break if (@hassQuest.getQuestionNumText() == "Question 14 of 14"); sleep 1 }
         
    #Verify that without checking the answer to the last question, the Submit button is disabled
    expect(@hassQuest.verifyTheSubmitButtonIsDisabled()).to be true
    expect(@hassQuest.getTheDisplayedButtonName()).to eq("Submit")
    
    @hassQuest.selectOneRadioButton("Q14-option", "1 to 3 years") #Question 4, button value "1 to 3 years"   
    !45.times{ break if (@hassQuest.isTheNextButtonDisabled() == false); sleep 1 }
    #Verify that the Submit button is activated now
    expect(@hassQuest.verifyTheSubmitButtonIsDisabled()).to be false
    #Click the Submit button to submit the questionnaire
    @hassQuest.clickTheSubmitButton()

  end
  
end
