require_relative '../../globalized'
include Globalized

describe "Story# HASS-15 [Assessment_ReturnTo_Save_Draft_HASS_15_spec.rb]" do

  before(:all) do
    initializeConfigurations(BASE_URL)
    deleteAssessmentResultsTable("D123401")
    initializeAllObjects
  end

  after(:all) do
    quitDriver()
  end

  it "AC#HASS-108|TC#:HASS-198: Verify that user can re-save a single assessment draft that overwrites each previous draft saved", :broken => true do
    #Accept Eula
    !45.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()
    
    #Passing by the landing page before the Eula
    @loginpage.passingByTheLandingPage()

    #Checking the DS Logon screen loaded
    !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran("zztest.patient01")

    !45.times{ break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    #Click the Left Side Toggle button
    @main.clickNavMenu()
    !45.times{ break if (getTextForElement(:id, "Assessments") == "Assessments"); sleep 1 }
    #Click Assessment button
    @navMenu.clickAssessmentBtn()

    #Click the assessment to display the Information screen
    hassID = @hassList.findIndexWithGivenName("Caregiver Status Summary")
    @hassList.clickThisAssessment(hassID)
    #Verify the name is displayed
    !45.times{ break if (@hassInfo.getAssessmentNameFromInfoPageHeader == "Caregiver Status Summary"); sleep 1 }
    expect(@hassInfo.getAssessmentNameFromInfoPageHeader()).to eq("Caregiver Status Summary")

    #Click Start Assessment button
    @hassInfo.clickStartAssessmentButton()
    !45.times{ break if (expect(@hassQuest.getQuestionNumText()).to eq("Question 1 of 4")); sleep 1 }
    #Verify that “Question 1 of X” is displayed
    expect(@hassQuest.getQuestionNumText()).to eq("Question 1 of 4")

  end

  it "AC#HASS-109|TC#:HASS-199: Verify after a draft is saved, user can continue the assessment or exit", :broken => true do
    @hassQuest.selectOneRadioButton("Q1-option", "Rarely") #Question 1, button 1
    !45.times{ break if (@hassQuest.isTheNextButtonDisabled() == false); sleep 1 }
    expect(@hassQuest.verifyRadioButtonCheckedNextButtonActivated(1)).to be true
    
    #Click Next button
    @hassQuest.clickTheNextButton()
    !45.times{ break if (@hassQuest.getQuestionNumText() == "Question 2 of 4"); sleep 1 }
    #Verify that no Modal Dialog popped
    expect(@modal.isConfirmationPopUpPresent()).to be false
    
    #Proceed to fill out one more questions
    @hassQuest.selectOneRadioButton("Q2-option", "Rarely") #Question 1, button 1
    $answerToThisQuestion = @hassQuest.isAnyRadioButtonChecked(2)
    
    !45.times{ break if (@hassQuest.isTheNextButtonDisabled() == false); sleep 1 }
    #Click Next button
    @hassQuest.clickTheNextButton()
    !45.times{ break if (@hassQuest.getQuestionNumText() == "Question 3 of 4"); sleep 1 }
      
    #Click Save button
    @hassQuest.clickTheSaveButton()
    #Click "OK" button from Save Draft pop up
    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    @modal.clickOKFromSaveDraftConfirmation()
        
    #Click another assessment, verify that no Modal Dialog popped
    hassID = @hassList.findIndexWithGivenName("Clinic in Hand Pilot Demographics")
    @hassList.clickThisAssessment(hassID)
    sleep 2
    #Verify that no Modal Dialog popped
    expect(@modal.isConfirmationPopUpPresent()).to be false

  end

  it "AC#HASS-109|TC#:HASS-199: Verify user can return to the assessment at the question where the draft was last saved", :broken => true do
    #Click the 'Caregiver Status Summary' assessment again to go back to the first assessment
    hassID = @hassList.findIndexWithGivenName("Caregiver Status Summary")
    @hassList.clickThisAssessment(hassID)
    !45.times{ break if (@hassInfo.getAssessmentNameFromInfoPageHeader == "Caregiver Status Summary"); sleep 1 }
    expect(@hassInfo.getAssessmentNameFromInfoPageHeader()).to eq("Caregiver Status Summary")
    
    #Verify that the Start Assessment button is visible
    expect(@hassInfo.isStartAssessmentButtonAvailable()).to be true
    #Click Start Assessment button to go back to the Questionnaire page
    @hassInfo.clickStartAssessmentButton()
    !45.times{ break if (@hassQuest.getQuestionNumText() == "Question 2 of 4"); sleep 1 }
      
    #Verify that after Start Assessment, user was taken back directly where it was left off
    @hassQuest.getQuestionNumText() == "Question 2 of 4"
    #Verify that the previously selected answer was still there
    if @hassQuest.isAnyRadioButtonChecked(2) == $answerToThisQuestion then
      puts "Successfully verify that the previously selected answer was kept"
    end
    
  end

  
end
