require_relative '../../globalized'
include Globalized
describe "Story# HASS-225 [Assessment_Print_Assessment_HASS_225_spec.rb]"  do
  include DriverUtility

  before(:all) do
    initializeConfigurations(BASE_URL)
    deleteAssessmentResultsTable("D123401")
    initializeAllObjects
  end

  after(:all) do
    quitDriver()
  end

  it "AC#HASS-269|TC#:HASS-276: Verify that After the user successfully submits the assessment, they are shown a copy of the assessment that includes text indicating the submission was successful and instructions to print the assessment using their device's browser print controls", :broken => true do
    #Accept Eula
    !45.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()

    #Passing by the landing page before the Eula
    @loginpage.passingByTheLandingPage()

    #Checking the DS Logon screen loaded
    !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran("zztest.patient01")

    !45.times{ break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    #Click the Left Side Toggle button
    @main.clickNavMenu()
    !45.times{ break if (getTextForElement(:id, "Assessments") == "Assessments"); sleep 1 }
    #Click Assessment button
    @navMenu.clickAssessmentBtn()

    #Click the assessment to display the Information screen
    hassID = @hassList.findIndexWithGivenName("Caregiver Status Summary")
    @hassList.clickThisAssessment(hassID)
    #Verify the name is displayed
    !45.times{ break if (@hassInfo.getAssessmentNameFromInfoPageHeader == "Caregiver Status Summary"); sleep 1 }
    expect(@hassInfo.getAssessmentNameFromInfoPageHeader()).to eq("Caregiver Status Summary")

    #Click Start Assessment button
    @hassInfo.clickStartAssessmentButton()
    !45.times{ break if (@hassQuest.getQuestionNumText() == "Question 1 of 4"); sleep 1 }
    #Verify that “Question 1 of X” is displayed
    expect(@hassQuest.getQuestionNumText()).to eq("Question 1 of 4")

    @hassQuest.selectOneRadioButton("Q1-option", "Rarely") #Question 1
    !45.times{ break if (@hassQuest.isTheNextButtonDisabled() == false); sleep 1 }

    #Click Next button
    @hassQuest.clickTheNextButton()
    !45.times{ break if (@hassQuest.getQuestionNumText() == "Question 2 of 4"); sleep 1 }

    #Proceed to fill out one more questions
    @hassQuest.selectOneRadioButton("Q2-option", "Rarely") #Question 2

    !45.times{ break if (@hassQuest.isTheNextButtonDisabled() == false); sleep 1 }
    #Click Next button
    @hassQuest.clickTheNextButton()
    !45.times{ break if (@hassQuest.getQuestionNumText() == "Question 3 of 4"); sleep 1 }
    #Choose answer to Qeuestion
    @hassQuest.selectOneRadioButton("Q3-option", "Sometimes") #Question 3
    #Click Next button
    @hassQuest.clickTheNextButton()
    !45.times{ break if (@hassQuest.getQuestionNumText() == "Question 4 of 4"); sleep 1 }
    #Choose answer to Qeuestion
    @hassQuest.selectOneRadioButton("Q4-option", "Nearly Always") #Question 4

    #Verify that the Submit button is activated now
    #@hassQuest.verifyTheSubmitButtonIsDisabled().should be false
    expect(@hassQuest.verifyTheSubmitButtonIsDisabled()).to eq(false)
    #Click the Submit button to submit the questionnaire
    @hassQuest.clickTheSubmitButton()

    #Wait for the Submit pop up to show up, then click the "Continue" button.
    !45.times{ break if (@modal.getConfirmationHeading() == "Submission Confirmation"); sleep 1 }

    #Click Continue to finally submit the assessment to DB
    @modal.clickContinueButton()

    #Get the Date and Time from backend DB and store it into a variable for later use
    $submittedDateTimeStr = getAssessmentSubmissionDateTime("D123401")
    puts $submittedDateTimeStr

    #Verify that Print Preview screen is displayed
    !45.times{ break if (@print.getPrintAssessmentTitle() == "Caregiver Status Summary, Version 1.0"); sleep 1 }
    expect(@print.getPrintAssessmentTitle).to eq("Caregiver Status Summary, Version 1.0")

    #Verify that the submission confirmation message is displayed.
    expectedString = "You have successfully submitted the Caregiver Status Summary for zztest patient01.\nA copy of the questions and your responses is provided below. This page may be printed using your browser print function."
    expect(@print.getAssessmentSubmitConfirmationMessage()).to eq(expectedString)

  end

  it "AC#HASS-270|TC#:HASS-276: Verify that after submit the assessment, Print display the all the required fields in the acceptance criteria.", :broken => true do
    #Verify that the assessment name is displayed
    tempArry = @print.getPrintAssessmentTitle.split(",")
    assessmentName = tempArry[0]
    puts assessmentName
    version = tempArry[1].strip
    puts version

    expect(assessmentName).to eq("Caregiver Status Summary")
    expect(version).to eq("Version 1.0")

    #Verify the patient who submitted the assessment is displayed
    expect(@print.getSubmitterName()).to eq("patient01, zztest")

    #Verify that the Date and Time that the assessment was submitted displayed correctly
    expect(@print.getSubmittedDateTimeFromGUI()).to eq($submittedDateTimeStr)

    #Verify all the questions and answers are displayed correctly
    #Question 1
    expectedString = "Do you feel that because of the time you spend as a Caregiver that you don\u2019t have enough time for yourself?"
    expect(@print.getDisplayedQuestion(1)).to eq(expectedString)
    #Answer 1
    expect(@print.getDisplayedAnswer(1)).to eq("Rarely")

    #Question 2
    expect(@print.getDisplayedQuestion(2)).to eq("Do you feel stressed between caregiving and trying to meet other responsibilities (work/family)?")
    #Answer 2
    expect(@print.getDisplayedAnswer(2)).to eq("Rarely")

    #Question 3
    expect(@print.getDisplayedQuestion(3)).to eq("Do you feel strained when you are caregiving?")
    #Answer 3
    expect(@print.getDisplayedAnswer(3)).to eq("Sometimes")

    #Question 4
    expect(@print.getDisplayedQuestion(4)).to eq("Do you feel uncertain about what to do about your loved one or patient?")
    #Answer 4
    expect(@print.getDisplayedAnswer(4)).to eq("Nearly Always")
  end

end
