require_relative '../../globalized'
include Globalized

describe "Story#HASS-24 [Assessment_Notification_HASS_8_spec.rb]", :broken => true  do
  include DriverUtility
  include MongoUtility

  before(:all) do
    initializeConfigurations(BASE_URL)
    deleteAssessmentResultsTable("PATID76")
    removeCollection("notifications", "notificationsdb")
    initializeAllObjects

    #Accept Eula
    !45.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()

    #Passing by the landing page before the Eula
    @loginpage.passingByTheLandingPage()

    #Checking the DS Logon screen loaded
    !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran("zztest.patient66")

    !45.times{ break if (@main.getFooterText() == "Logged in as patient66, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient66, zztest")

  end

  after(:all) do
    quitDriver()
  end

  it "AC#HASS-283|TC#:HASS-295: Verify the Assessment Summary view now includes the Set Up reminder feature; Required field testing" do

    #Click the Left Side Toggle button
    @main.clickNavMenu()
    !45.times{ break if (getTextForElement(:id, "Assessments") == "Assessments"); sleep 1 }
    #Click Assessment button
    @navMenu.clickAssessmentBtn()

    #Click the assessment to display the Information screen
    hassID = @hassList.findIndexWithGivenName("Caregiver Status Summary")
    @hassList.clickThisAssessment(hassID)
    #Verify the name is displayed
    !45.times{ break if (@hassInfo.getAssessmentNameFromInfoPageHeader == "Caregiver Status Summary"); sleep 1 }

    #Click Start Assessment button
    @hassInfo.clickStartAssessmentButton()
    !45.times{ break if (expect(@hassQuest.getQuestionNumText()).to eq("Question 1 of 4")); sleep 1 }

    @hassQuest.selectOneRadioButton("Q1-option", "Rarely") #Question 1
    !45.times{ break if (@hassQuest.isTheNextButtonDisabled() == false); sleep 1 }
    
    #Click Next button
    @hassQuest.clickTheNextButton()
    !45.times{ break if (@hassQuest.getQuestionNumText() == "Question 2 of 4"); sleep 1 }
    
    #Proceed to fill out one more questions
    @hassQuest.selectOneRadioButton("Q2-option", "Rarely") #Question 2
    #$answerToThisQuestion = @hassQuest.isAnyRadioButtonChecked(2)
    !45.times{ break if (@hassQuest.isTheNextButtonDisabled() == false); sleep 1 }
    #Click Next button
    @hassQuest.clickTheNextButton()
    !45.times{ break if (@hassQuest.getQuestionNumText() == "Question 3 of 4"); sleep 1 }
    #Choose answer to Qeuestion
    @hassQuest.selectOneRadioButton("Q3-option", "Sometimes") #Question 3
    #Click Next button
    @hassQuest.clickTheNextButton()
    !45.times{ break if (@hassQuest.getQuestionNumText() == "Question 4 of 4"); sleep 1 }
    #Choose answer to Qeuestion
    @hassQuest.selectOneRadioButton("Q4-option", "Nearly Always") #Question 4
    #Click the Submit button to submit the questionnaire
    @hassQuest.clickTheSubmitButton()
    
    #Wait for the Submit pop up to show up, then click the "Continue" button.
    !45.times{ break if (@modal.getConfirmationHeading() == "Submission Confirmation"); sleep 1 }
    #Verify that the pop up header is displayed
    expect(@modal.getConfirmationHeading()).to eq("Submission Confirmation")
    #Click Continue to finally submit the assessment to DB
    @modal.clickContinueButton()

    !45.times{ break if (@print.getPrintAssessmentTitle() == "Caregiver Status Summary, Version 1.0"); sleep 1 }
    #Verify that the submission confirmation message is displayed.
    expectedString = 'Click the "Set Up Notification" button below if you would like to be notified to retake the assessment at a future date.'
    expect(@print.getSetUpNotificationInstructionMsg()).to eq(expectedString)

    #Verify that the Set up the Notification button is visible
    expect(@print.isSetUpNotificationButtonVisible()).to eq(true)

    @print.clickSetUpNotificationButton()
    !45.times{ break if (@modal.getConfirmationHeading() == "Set Up Notification"); sleep 1 }
    expect(@modal.getConfirmationHeading()).to eq("Set Up Notification")
    expect(@modal.getConfirmationMessage()).to eq("You may elect to receive a notification to retake this assessment at a future date. To receive this notification, select an option below.\n* Retake assessment in:\nSelect\nOne Week\nTwo Weeks\nOne Month\nThree Months")

    #Click the Cancel button
    @print.clickCancelButtonFromSetUpNotification()
    !45.times{ break if (@print.isSetUpNotificationButtonVisible() == true); sleep 1 }
    @print.clickSetUpNotificationButton()
    !45.times{ break if (@modal.getConfirmationHeading() == "Set Up Notification"); sleep 1 }

    #Required field negative testing
    @print.clickSaveButtonFromSetUpNotification()
    !45.times{ break if (@error.getValidationSummaryHeader("assessmentNotificationForm") == "The following errors were found:"); sleep 1 }
    expect(@error.getValidationSummaryHeader("assessmentNotificationForm")).to eq("The following errors were found:")
    #Validate that the error messages are displayed
    expect(@error.isErrorMessageDisplayed("assessmentNotificationForm", "Retake assessment in field is required.")).to be true

  end


  it "AC#HASS-284,285|TC-295: Verify that user can set up a notification at any frequency; Verify the notification is being entered into the MongoDB" do
    #Validate the entry
    today = getDateNthDaysAgo(0, "%Y-%m-%d")
    OneWeek = getDateNthDaysFromNow(7, "%Y-%m-%d")
    TwoWeeks = getDateNthDaysFromNow(14, "%Y-%m-%d")
    OneMonth = getDateNthDaysFromNow(30, "%Y-%m-%d")
    ThreeMonths = getDateNthDaysFromNow(90, "%Y-%m-%d")

    #Select One Week
    @reminders.selectFrequency("One Week")
    @print.clickSaveButtonFromSetUpNotification()
    #Verify that it returns to the assessment Print page
    !45.times{ break if (@print.isSetUpNotificationButtonVisible() == true); sleep 1 }
    #Wait for the record being entered into MongoDB
    sleep 1
    validateEachNotificationInMongoDB(today, OneWeek)
    removeCollection("notifications", "notificationsdb")

    #Select Two Weeks
    @print.clickSetUpNotificationButton()
    !45.times{ break if (@modal.getConfirmationHeading() == "Set Up Notification"); sleep 1 }
    @reminders.selectFrequency("Two Weeks")
    @print.clickSaveButtonFromSetUpNotification()
    #Verify that it returns to the assessment Print page
    !45.times{ break if (@print.isSetUpNotificationButtonVisible() == true); sleep 1 }
    #Wait for the record being entered into MongoDB
    sleep 1
    validateEachNotificationInMongoDB(today, TwoWeeks)
    removeCollection("notifications", "notificationsdb")

    #Select One Month
    @print.clickSetUpNotificationButton()
    !45.times{ break if (@modal.getConfirmationHeading() == "Set Up Notification"); sleep 1 }
    @reminders.selectFrequency("One Month")
    @print.clickSaveButtonFromSetUpNotification()
    #Verify that it returns to the assessment Print page
    !45.times{ break if (@print.isSetUpNotificationButtonVisible() == true); sleep 1 }
    #Wait for the record being entered into MongoDB
    sleep 1
    validateEachNotificationInMongoDB(today, OneMonth)
    removeCollection("notifications", "notificationsdb")

    #Select Three Months
    @print.clickSetUpNotificationButton()
    !45.times{ break if (@modal.getConfirmationHeading() == "Set Up Notification"); sleep 1 }
    @reminders.selectFrequency("Three Months")
    @print.clickSaveButtonFromSetUpNotification()
    #Verify that it returns to the assessment Print page
    !45.times{ break if (@print.isSetUpNotificationButtonVisible() == true); sleep 1 }
    #Wait for the record being entered into MongoDB
    sleep 1
    validateEachNotificationInMongoDB(today, ThreeMonths)


  end

  def validateEachNotificationInMongoDB(createDate, effectiveDisplayDate)
    expect(retrieveThisFieldInDocument("notifications", "notificationsdb", "EDIPI", "PATID76", "body")).to eq("Caregiver Status Summary is due now.")

    tempDateTime = retrieveThisFieldInDocument("notifications", "notificationsdb", "EDIPI", "PATID76", "createDate")
    finalcreateDate = tempDateTime.localtime.strftime("%Y-%m-%d")
    expect(finalcreateDate).to eq(createDate)

    tempDateTime = retrieveThisFieldInDocument("notifications", "notificationsdb", "EDIPI", "PATID76", "effectiveDisplayDate")
    finalEffectiveDate = tempDateTime.localtime.strftime("%Y-%m-%d")
    #puts "finalEffectiveDateFromDB=" + finalEffectiveDate
    finalEffectiveTime = tempDateTime.localtime.strftime("%I:%M %p")
    expect(finalEffectiveDate).to eq(effectiveDisplayDate)
    expect(finalEffectiveTime).to eq("09:00 AM")

    expect(retrieveThisFieldInDocument("notifications", "notificationsdb", "EDIPI", "PATID76", "source")).to eq("My VA Health - Assessments")


  end

end
