require_relative '../../globalized'
include Globalized

describe "Story# HASS-54 [Assessment_Navigation_HASS_54_spec.rb]" do
  include DriverUtility

  before(:all) do
    initializeConfigurations(BASE_URL)
    deleteAssessmentResultsTable("D123401")
    initializeAllObjects
  end

  after(:all) do
    quitDriver()
  end

  it "AC#HASS-106|TC#:HASS-177: Verify that user may navigate away from the assessment and no confirmation message is shown if user has no unsaved data", :broken => true do
    #Accept Eula
    !45.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()
    
    #Passing by the landing page before the Eula
    @loginpage.passingByTheLandingPage()

    #Checking the DS Logon screen loaded
    !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran("zztest.patient01")

    !45.times{ break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    #Click the Left Side Toggle button
    @main.clickNavMenu()
    !45.times{ break if (getTextForElement(:id, "Assessments") == "Assessments"); sleep 1 }
    #Click Assessment button
    @navMenu.clickAssessmentBtn()

    #Click the assessment to display the Information screen
    expect(@hassList.isThisAssessmentOnTheList("Caregiver Status Summary")).to be true
    
    hassID = @hassList.findIndexWithGivenName("Caregiver Status Summary")
    @hassList.clickThisAssessment(hassID)
    #Verify the name is displayed
    !45.times{ break if (@hassInfo.getAssessmentNameFromInfoPageHeader == "Caregiver Status Summary"); sleep 1 }
    expect(@hassInfo.getAssessmentNameFromInfoPageHeader()).to eq("Caregiver Status Summary")

    #Click Start Assessment button
    @hassInfo.clickStartAssessmentButton()
    !45.times{ break if (expect(@hassQuest.getQuestionNumText()).to eq("Question 1 of 4")); sleep 1 }
    #Without answering the question, click Back button 
    @hassQuest.clickBackButton()
    expect(@modal.isConfirmationPopUpPresent()).to be false
    sleep 2
  end

  it "AC#HASS-105|TC#:HASS-177: Verify that if user has unsaved data, when the user exits an assessment (from any platform), a message will appear prompting the user to confirm their intent to exit.", :broken => true do
    #Click Start Assessment button
    @hassInfo.clickStartAssessmentButton()
    !45.times{ break if (expect(@hassQuest.getQuestionNumText()).to eq("Question 1 of 4")); sleep 1 }
    
    #Answer Quesiton #1
    @hassQuest.selectOneRadioButton("Q1-option", "Sometimes") #Question 1, button value "Sometimes"
    
    #Click Back button, verify the confirmation pop up show up
    @hassQuest.clickBackButton()
    expect(@modal.isConfirmationPopUpPresent()).to be true
    expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
    #Verify clicking Continue button
    @modal.clickContinueButton
    
    #Verify that user lands on the Information page
    !45.times{ break if (@hassInfo.getAssessmentNameFromInfoPageHeader == "Caregiver Status Summary"); sleep 1 }
    expect(@hassInfo.getAssessmentNameFromInfoPageHeader()).to eq("Caregiver Status Summary")
    
    #Click the Start Assessment button to return to the first question
    @hassInfo.clickStartAssessmentButton()
    !45.times{ break if (expect(@hassQuest.getQuestionNumText()).to eq("Question 1 of 4")); sleep 1 }
    #Verify that the answer was not there 
    $answerToThisQuestion = @hassQuest.isAnyRadioButtonChecked(1)
    expect(@hassQuest.isAnyRadioButtonChecked(1)).to eq("")
    
    #Answer Quesiton #1 again since last time it didn't get saved
    @hassQuest.selectOneRadioButton("Q1-option", "Sometimes") #Question 1, button value "Sometimes"
    $answerToThisQuestion = @hassQuest.isAnyRadioButtonChecked(1)
    
    #Click Back button again and select "Return" button from the pop up modal
    @hassQuest.clickBackButton()
    expect(@modal.isConfirmationPopUpPresent()).to be true
    expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
    #Verify clicking Continue button
    @modal.clickReturnButton
    
    #Verify that user return to the Quesiton #1 page
    !45.times{ break if (expect(@hassQuest.getQuestionNumText()).to eq("Question 1 of 4")); sleep 1 }

    #Verify that “Question 1 of X” is displayed
    expect(@hassQuest.getQuestionNumText()).to eq("Question 1 of 4")
    #Verify that the previously typed in answer was displayed
    if expect(@hassQuest.isAnyRadioButtonChecked(1)).to eq($answerToThisQuestion) then
      puts "Successfully verified that answer to Question 1 persist after clicking RETURN from the modal dialog"
    end
        
  end

  it "AC#HASS-104|TC#:HASS-164: Verify user can  can exit an assessment by clicking on a different assessment in the assessment list, or by navigating away from the assessment using the left and right panel app navigation.", :broken => true do
    
    #SCENARIO #1: Leave the assessment by clicking a different assessment
    #Without saving the data, click another assessment from the list attempting to leave the questionnaire
    hassID = @hassList.findIndexWithGivenName("Clinic in Hand Pilot Demographics")
    @hassList.clickThisAssessment(hassID)
    sleep 2
    #Verify that the modal dialog popped up
    expect(@modal.isConfirmationPopUpPresent()).to be true
    expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
    #Verify clicking Continue button
    @modal.clickContinueButton
    
    #Verify the name is displayed
    !45.times{ break if (@hassInfo.getAssessmentNameFromInfoPageHeader == "Clinic in Hand Pilot Demographics"); sleep 1 }
    expect(@hassInfo.getAssessmentNameFromInfoPageHeader()).to eq("Clinic in Hand Pilot Demographics")
    
    #Return to previous assessment (Feedback Assessment) to verify that the previously typed-in answer wasn't saved
    hassID = @hassList.findIndexWithGivenName("Caregiver Status Summary")
    @hassList.clickThisAssessment(hassID)
    #Verify the name is displayed
    !45.times{ break if (@hassInfo.getAssessmentNameFromInfoPageHeader == "Caregiver Status Summary"); sleep 1 }
          
    #Click Start Assessment button
    @hassInfo.clickStartAssessmentButton()
    !45.times{ break if (expect(@hassQuest.getQuestionNumText()).to eq("Question 1 of 4")); sleep 1 }
      
    #Verify that Question #1 is not answered
    expect(@hassQuest.isAnyRadioButtonChecked(1)).to eq("")
    
    #END OF SCENARIO #1
    
    #SCENARIO #2:  Leave the assessment by navigating to Daily Event
    #Answer Quesiton #1 again since last time it didn't get saved
    @hassQuest.selectOneRadioButton("Q1-option", "Sometimes") #Question 1, button value "Sometimes"
    $answerToThisQuestion = @hassQuest.isAnyRadioButtonChecked(1)
    
    #Wait for the Next button to be activated
    !45.times{ break if (@hassQuest.isTheNextButtonDisabled() == false); sleep 1 }
      
    @main.clickNavMenu()
    !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }
    @nav_menu.clickMyStory()
    
    sleep 2
    #Verify that the modal dialog pops up
    expect(@modal.isConfirmationPopUpPresent()).to be true
    expect(@modal.getConfirmationMessage()).to eq("You have not saved your changes. You may continue without saving or return to the entry screen.")
    #Verify clicking Return button
    puts "Clickng return button now"
    @modal.clickReturnButton
    
    #Verify user went back to Question #1 and the answer to Question #1 persist (stored in the front end)
    !45.times{ break if (expect(@hassQuest.getQuestionNumText()).to eq("Question 1 of 4")); sleep 1 }
    expect(@hassQuest.getQuestionNumText()).to eq("Question 1 of 4")
    expect(@hassQuest.isAnyRadioButtonChecked(1)).to eq($answerToThisQuestion)
    
  end

end
