require_relative '../../globalized'
include Globalized

describe "Story# HASS-11 [Assessment_List_HASS_11_spec.rb]"  do
  include DriverUtility

  before(:all) do
    initializeConfigurations(BASE_URL)
    deleteAssessmentResultsTable("D123401")
    initializeAllObjects
  end

  after(:all) do
    quitDriver()
  end

  it "AC# HASS-89: Verify that the name, created date and lock icon are present for an assessment", :broken => true do
    #Accept Eula first
    !45.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()
    
    #Passing by the landing page before the Eula
    @loginpage.passingByTheLandingPage()

    #Checking the DS Logon screen loaded
    !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran("zztest.patient01")

    !45.times{ break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    #Click the Left Side Toggle button
    @main.clickNavMenu()
    !45.times{ break if (getTextForElement(:id, "Assessments") == "Assessments"); sleep 1 }
    #Click Assessment button
    @navMenu.clickAssessmentBtn()
    
    #Verify the name is displayed
    hassID = @hassList.findIndexWithGivenName("Clinic in Hand Pilot Demographics")
    expect(@hassList.getAssessmentName(hassID)).to eq("Clinic in Hand Pilot Demographics")

  end

  it "AC# HASS-89: Verify the assessments are sorted by name alphabetically" do

    expect(@hassList.verifyAssessmentSortedByNameAlphbetically()).to be true

  end

  it "AC# HASS-91: Verify that a few assessments are displayed", :broken => true do
    hassID = @hassList.findIndexWithGivenName("Clinic in Hand Pilot Demographics")
    expect(@hassList.getAssessmentName(hassID)).to eq("Clinic in Hand Pilot Demographics")
    
    hassID = @hassList.findIndexWithGivenName("Caregiver Preparedness Assessment")
    expect(@hassList.getAssessmentName(hassID)).to eq("Caregiver Preparedness Assessment")
    
    hassID = @hassList.findIndexWithGivenName("Caregiver Status Summary")
    expect(@hassList.getAssessmentName(hassID)).to eq("Caregiver Status Summary")
    
  end

  it "AC# HASS-90: Verify that an assessment can be open from the list view", :broken => true do
    hassID = @hassList.findIndexWithGivenName("Clinic in Hand Pilot Demographics")
    @hassList.clickThisAssessment(hassID)
    !45.times{ break if (@hassInfo.getAssessmentNameFromInfoPageHeader() == "Clinic in Hand Pilot Demographics"); sleep 1 }
    expect(@hassInfo.getAssessmentNameFromInfoPageHeader()).to eq("Clinic in Hand Pilot Demographics")
             
     
   end
end
