require_relative '../../globalized'
include Globalized

describe "Story# HASS-52 [Assessment_Info_HASS_52_spec.rb]"  do
  include DriverUtility

  before(:all) do
    initializeConfigurations(BASE_URL)
    deleteAssessmentResultsTable("D123401")
    initializeAllObjects
  end

  after(:all) do
    quitDriver()
  end

  it "AC# HASS-87|TC#:HASS-153: Verify that the Assessment name, bullet contents and optional contents are displayed", :broken => true do
    #Accept Eula
    !45.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()
    
    #Passing by the landing page before the Eula
    @loginpage.passingByTheLandingPage()

    #Checking the DS Logon screen loaded
    !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran("zztest.patient01")

    !45.times{ break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    #Click the Left Side Toggle button
    @main.clickNavMenu()
    !45.times{ break if (getTextForElement(:id, "Assessments") == "Assessments"); sleep 1 }
    #Click Assessment button
    @navMenu.clickAssessmentBtn()
    
    #Click the assessment to display the Information screen
    hassID = @hassList.findIndexWithGivenName("Caregiver Status Summary")
    @hassList.clickThisAssessment(hassID)
    #Verify the name is displayed
    !45.times{ break if (@hassInfo.getAssessmentNameFromInfoPageHeader == "Caregiver Status Summary"); sleep 1 }
    expect(@hassInfo.getAssessmentNameFromInfoPageHeader()).to eq("Caregiver Status Summary")
    
    #Verify that the bullet contents are displayed
    expect(@hassInfo.isAssessmentBulletContentAvailable()).to eq(true)
    
    #Verify that the optional contents are displayed too
    #The top portion is displayed
    expect(@hassInfo.isTopPortionOfOptionalContentDisplayed()).to eq(true)
    #The bottom portion is displayed
    expect(@hassInfo.isBottomPortionOfOptionalContentDisplayed).to eq(true)
    
  end

  it "AC# HASS-88|TC#:HASS-153: Verify the Start Assessment button is available for user to enter the Questionnaire", :broken => true do
    @hassInfo.clickStartAssessmentButton()
    !45.times{ break if (@hassInfo.getAssessmentNameFromQuestionPageHeader() == "Caregiver Status Summary"); sleep 1 }
    expect(@hassInfo.getAssessmentNameFromQuestionPageHeader()).to eq("Caregiver Status Summary")

  end

 
end
