require_relative '../../globalized'
include Globalized

describe "Story# HASS-10 [Assessment_Health_Advocate_HASS_10_spec.rb]"  do
  include DriverUtility

  before(:all) do
    initializeConfigurations(BASE_URL)
    deleteAssessmentResultsTable("D123401")
    initializeAllObjects
  end

  after(:all) do
    quitDriver()
  end

  it "AC#HASS-68|HASS-69|TC#:HASS-271: Verify that user can open the app and enter assessment data on behalf of the Veteran and  can see for whom they are submitting the assessment." do
    #Accept Eula
    !45.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()
    
    #Passing by the landing page before the Eula
    @loginpage.passingByTheLandingPage()

    #Checking the DS Logon screen loaded
    !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran("zztest.advocate01")

    !45.times{ break if (@main.getFooterText() == "Logged in as advocate01, zztest - Health Advocate for patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as advocate01, zztest - Health Advocate for patient01, zztest")

    #Click the Left Side Toggle button
    @main.clickNavMenu()
    !45.times{ break if (getTextForElement(:id, "Assessments") == "Assessments"); sleep 1 }
    #Click Assessment button
    @navMenu.clickAssessmentBtn()

  end

  it "AC#HASS-71|TC#:HASS-271: Verify a health advocate user can save a draft assessment using the same processes used by veterans", :broken => true do
    #Click the assessment to display the Information screen
    hassID = @hassList.findIndexWithGivenName("Caregiver Status Summary")
    @hassList.clickThisAssessment(hassID)
    #Verify the name is displayed
    !45.times{ break if (@hassInfo.getAssessmentNameFromInfoPageHeader == "Caregiver Status Summary"); sleep 1 }
    expect(@hassInfo.getAssessmentNameFromInfoPageHeader()).to eq("Caregiver Status Summary")

    #Click Start Assessment button
    @hassInfo.clickStartAssessmentButton()
    !45.times{ break if (expect(@hassQuest.getQuestionNumText()).to eq("Question 1 of 4")); sleep 1 }
    #Verify that “Question 1 of X” is displayed
    expect(@hassQuest.getQuestionNumText()).to eq("Question 1 of 4")
    
    @hassQuest.selectOneRadioButton("Q1-option", "Rarely") #Question 1
    !45.times{ break if (@hassQuest.isTheNextButtonDisabled() == false); sleep 1 }
    
    #Click Next button
    @hassQuest.clickTheNextButton()
    !45.times{ break if (@hassQuest.getQuestionNumText() == "Question 2 of 4"); sleep 1 }
    #Verify that no Modal Dialog popped
    expect(@modal.isConfirmationPopUpPresent()).to eq(false)
    
    #Proceed to fill out one more questions
    @hassQuest.selectOneRadioButton("Q2-option", "Rarely") #Question 1, button 1
    $answerToThisQuestion = @hassQuest.isAnyRadioButtonChecked(2)
    
    !45.times{ break if (@hassQuest.isTheNextButtonDisabled() == false); sleep 1 }
    #Click Next button
    @hassQuest.clickTheNextButton()
    !45.times{ break if (@hassQuest.getQuestionNumText() == "Question 3 of 4"); sleep 1 }
      
    #Click Save button
    @hassQuest.clickTheSaveButton()
    #Click "OK" button from Save Draft pop up
    !45.times{ break if (@modal.getConfirmationHeading() == "Confirmation"); sleep 1 }
    @modal.clickOKFromSaveDraftConfirmation()
    #Verify Save Draft saved the assessment to DB
    expect(verifyAssessmentIsSavedAsDraft("D123401")).to eq(true)
    
    #Click another assessment, verify that no Modal Dialog popped
    hassID = @hassList.findIndexWithGivenName("Clinic in Hand Pilot Demographics")
    @hassList.clickThisAssessment(hassID)
    #Verify that no Modal Dialog popped
    expect(@modal.isConfirmationPopUpPresent()).to eq(false)
    
    #Come back to the original assessment and verify that the data was saved
    #Click the 'Caregiver Status Summary' assessment again to go back to the first assessment
    hassID = @hassList.findIndexWithGivenName("Caregiver Status Summary")
    @hassList.clickThisAssessment(hassID)
    !45.times{ break if (@hassInfo.getAssessmentNameFromInfoPageHeader == "Caregiver Status Summary"); sleep 1 }
    expect(@hassInfo.getAssessmentNameFromInfoPageHeader()).to eq("Caregiver Status Summary")
    
    #Click Start Assessment button to go back to the Questionnaire page
    @hassInfo.clickStartAssessmentButton()
    !45.times{ break if (@hassQuest.getQuestionNumText() == "Question 2 of 4"); sleep 1 }
      
    #Verify that after Start Assessment, user was taken back directly where it was left off
    @hassQuest.getQuestionNumText() == "Question 2 of 4"
    #Verify that the previously selected answer was still there
    if @hassQuest.isAnyRadioButtonChecked(2) == $answerToThisQuestion then
      puts "Successfully verify that the previously selected answer was kept"
    end

  end

  it "AC#HASS-70|TC#:HASS-271: Verify a health advocate user can submit a completed assessment using the same processed used by veterans", :broken => true do
    #Click Next button
    @hassQuest.clickTheNextButton()
    !45.times{ break if (@hassQuest.getQuestionNumText() == "Question 3 of 4"); sleep 1 }
    #Choose answer to Qeuestion
    @hassQuest.selectOneRadioButton("Q3-option", "Sometimes") #Question 3
    #Click Next button
    @hassQuest.clickTheNextButton()
    !45.times{ break if (@hassQuest.getQuestionNumText() == "Question 4 of 4"); sleep 1 }
    #Choose answer to Qeuestion
    @hassQuest.selectOneRadioButton("Q4-option", "Nearly Always") #Question 4
      
    #Verify that the Submit button is activated now
    expect(@hassQuest.verifyTheSubmitButtonIsDisabled()).to eq(false)
    #Click the Submit button to submit the questionnaire
    @hassQuest.clickTheSubmitButton()
    
    #Wait for the Submit pop up to show up, then click the "Continue" button.
    !45.times{ break if (@modal.getConfirmationHeading() == "Submission Confirmation"); sleep 1 }
    #Verify that the Advocate01 is submitting the assessment for patient01
    expect(@modal.getNthConfirmationMessage(1)).to eq("You are submitting the Caregiver Status Summary for zztest patient01.")
    #Click Continue to finally submit the assessment to DB
    @modal.clickContinueButton()
    
    #Verify Save Draft saved the assessment to DB
    expect(verifyAssessmentIsSubmitted("D123401")).to eq(true)
  end

  
end
