require_relative '../../globalized'
include Globalized

describe "Story# HASS-147 [Assessment_Feedback_Assessment_HASS_147_spec.rb]" do
  include DriverUtility

  before(:all) do
    initializeConfigurations(BASE_URL)
    initializeAllObjects
  end

  after(:all) do
    quitDriver()
  end

  it "AC#HASS-148|TC#:HASS-164: Verify that Feedback Assessment is on the Assessment List", :broken => true do
    #Accept Eula
    !45.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()
    
    #Passing by the landing page before the Eula
    @loginpage.passingByTheLandingPage()

    #Checking the DS Logon screen loaded
    !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran("zztest.patient01")

    !45.times{ break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    #Click the Left Side Toggle button
    @main.clickNavMenu()
    !45.times{ break if (getTextForElement(:id, "Assessments") == "Assessments"); sleep 1 }
    #Click Assessment button
    @navMenu.clickAssessmentBtn()

    #Click the assessment to display the Information screen
    expect(@hassList.isThisAssessmentOnTheList("Feedback Assessment")).to be_truthy
    
    hassID = @hassList.findIndexWithGivenName("Feedback Assessment")
    @hassList.clickThisAssessment(hassID)
    #Verify the name is displayed
    !45.times{ break if (@hassInfo.getAssessmentNameFromInfoPageHeader == "Mobile Application Feedback"); sleep 1 }
    expect(@hassInfo.getAssessmentNameFromInfoPageHeader()).to eq("Mobile Application Feedback")

   

  end

  it "AC#HASS-87|TC#:HASS-164: Verify that the bullet points contents are available on the Information screen", :broken => true do
    expect(@hassInfo.isBulletContentAvailableForFeedbackAssessment()).to be_truthy

  end

  it "AC#HASS-149|TC#:HASS-164: Verify user can provide feedback and answers to all questions on the form.", :broken => true do
    #Click Start Assessment button
    @hassInfo.clickStartAssessmentButton()
    !45.times{ break if (expect(@hassQuest.getQuestionNumText()).to eq("Question 1 of 4")); sleep 1 }
    #Verify that “Question 1 of X” is displayed
    expect(@hassQuest.getQuestionNumText()).to eq("Question 1 of 4")
    
    #Question #1: 
    #Scenario 1: verify that the max allowed character for the text field is 250 characters
    sectionalText = "validateIfYouCanHandleMoreThan250Charactoers"
    textWith264Chars = sectionalText + sectionalText + sectionalText + sectionalText + sectionalText + sectionalText
    @hassQuest.typeInFeaturesAtWhichQuestion(1, textWith264Chars)
    
    #Verify that the final text that's left have total of 250 characters
    #puts "first 2 characters = " + getTextForElement(:css, "form[name='assessmentForm'] fieldset:nth-of-type(2) div span").strip[0,2]
    !45.times{ break if (getTextForElement(:css, "form[name='assessmentForm'] fieldset:nth-of-type(2) div span").strip[0,2] != "of"); sleep 1 }
    expect(@hassQuest.verifyTheTotalNumOfCharactersAreDisplayed(250)).to be_truthy
      
    #Scenario 1: verify the total number of typed in characters are sum up and displayed on the screen
    #Remove the existing text from the edit box first
    @hassQuest.deleteAnswerAtWhichQuestion(1)
    whatStr = "Style Sheet"
    whatNum = whatStr.length()
    @hassQuest.typeInFeaturesAtWhichQuestion(1, whatStr)
    
    #The following line is to check whether the total number has shown up before running the validation
    !45.times{ break if (getTextForElement(:css, "form[name='assessmentForm'] fieldset:nth-of-type(2) div span").strip[0,2] != "of"); sleep 1 }
    expect(@hassQuest.verifyTheTotalNumOfCharactersAreDisplayed(whatNum)).to be_truthy
    #Click the Next button
    if @hassQuest.isTheNextButtonDisabled() == false then
      @hassQuest.clickTheNextButton()
    end
    
    #Question #2
    #Enter the scale
    @hassQuest.enterTheScaleAtQ2()
    #Click the Next button
    if @hassQuest.isTheNextButtonDisabled() == false then
      @hassQuest.clickTheNextButton()
    end
    
    #Question #3
    whatStr = "Perfect. Nothing"
    @hassQuest.typeInFeaturesAtWhichQuestion(3, whatStr)
    #Click the Next button
    if @hassQuest.isTheNextButtonDisabled() == false then
      @hassQuest.clickTheNextButton()
    end
    
    #Question #4
    whichBoxArry = [1,3]
    @hassQuest.checkOneOrMultiCheckBox(whichBoxArry)
    #Click the Submit button
    if @hassQuest.isTheNextButtonDisabled() == false then
      @hassQuest.clickTheNextButton()
    end
    
  end

end
