#!/bin/env ruby
# encoding: utf-8
require_relative '../../globalized'
include Globalized

describe "Story# HASS-24 [Assessment_Feature_Guide_HASS_44_spec.rb]  --  Story #JRNL-2456[ Client feedback update on 1.0] Story JRNL-1334: Update User Guide for 2.1" do

  include DriverUtility

  before(:all) do
    initializeConfigurations(BASE_URL)
    initializeAllObjects
  end

  after(:all) do
    quitDriver()
  end

  it "AC#HASS-274|TC#:HASS-275|TC#JRNL-1910: Verify that Health Assessment are included in Journal User Guide.", :broken => true do
    @common.loginEndsOnLandingPage("zztest.patient01", "patient01, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    @main.clickUserMenu()
    !45.times{ break if (@menu.getMenuHeading() == "User Menu"); sleep 1 }
    expect(@menu.getMenuHeading()).to eq("User Menu")

    @menu.clickHelpBtn()
    #Verify the Help screen was displayed
    !45.times{ break if (@help.verifyHelpScreenHeading()== "Help"); sleep 1 }
    expect(@help.verifyHelpScreenHeading()).to eq("Help")

    @help.clickUserGuideLink()
    #Switch to the new window that pops up so Selenium can locate the elements correctly
    switchWindowToWindowHandleLast()
    !45.times{ break if (@help.getUserGuideScreenHeader() == "My VA Health User Guide"); sleep 1 }
    expect(@help.getUserGuideScreenHeader()).to eq("My VA Health User Guide")

    @help.clickAssessmentsLinkFromTableContents()
    #Verify Health Assessment section title is displayed
  end

  it "Story JRNL-1334 | AC JRNL-1161 | TC JRNL-1146: Update User Guide for 2.1", :broken => true do
    expect(@help.getAssessmentsContentTitle()).to eq("2.9 Assessments")

    #Verify Health Assessment section body text is displayed
    expect(@help.getHealthAssessmentSummaryText()).to eq("The Assessment feature provides the ability for users, including caregivers, to take one or more of the provided health assessments, and to store the assessment data in the self-entered database.")

  end

  it "AC#HASS-274|TC#:HASS-275|TC#JRNL-1910: Verify that Health Assessment are included in Journal User Guide.", :broken => true do
    #Verify that To Use This Feature content
    expectedString = "Assessments are provided as a feature within the My VA Health application, and can be accessed by selecting \"Assessments\" from the My VA Health App navigation menu located in the upper left hand corner of the screen."
    expect(@help.getHealthAssessmentToUseThisFeatureText()).to eq(expectedString)

    #Verify Assessment Navigation Prelude text
    expect(@help.getHealthAssessmentNavigationPrelude()).to eq("Once you start an assessment, the questions are presented one at a time. You may navigate among the questions using the following buttons:")
    #Verify Assessment Navigation Bullet Content
    expect(@help.getNthAssessmentNavigateionContent(1)).to eq("Back: Allows you to move to the previous screen in the series.")
    expect(@help.getNthAssessmentNavigateionContent(2)).to eq("Next: Allows you to move to the next screen in the series, only after the current question has been answered.")
    expect(@help.getNthAssessmentNavigateionContent(3)).to eq("Save Draft: Allows you to save a copy of the assessment questions answered. When you return to the assessment you will be brought to the point in which you last saved a draft.")
    expect(@help.getNthAssessmentNavigateionContent(4)).to eq("Exit: The Exit option is shown to phone users only. This control allows you to close the assessment question flow and return to the Assessment list.")

    #Verify Assessment Submission Content
    expect(@help.getAssessmentSubmissionContent()).to eq("After the assessment questions are completed, you will be provided an option to submit your assessment. Submitted data is stored in the self-entered database. Submitted assessments cannot be modified or viewed from within the Assessment feature of the My VA Health app.")

    #Verify Print Assessment Content
    expectedString = "After submitting your assessment you will be presented with an HTML page showing the completed assessment's questions along with your responses. You may elect to print the assessment using the print options available in your browser."
    expect(@help.getPrintAssessmentContent()).to eq(expectedString)
  end

end
