require_relative '../../globalized'
include Globalized

describe "Story# HASS-185 [Assessment_DetailPage_DefaultDisplay_HASS_185_spec.rb]"  do

  before(:all) do
    initializeConfigurations(BASE_URL)
    deleteAssessmentResultsTable("D123401")
    initializeAllObjects
  end

  after(:all) do
    quitDriver()
  end

  it "AC# HASS-264|TC# HASS-265: Verify that the user will see a default message on the detail page that reads 'Select an item from the list to start an assessment.'" do
    #Accept Eula first
    !45.times{ break if (@eula.acceptEulaVisible?() == true); sleep 1 }
    @eula.clickAccept()
    
    #Passing by the landing page before the Eula
    @loginpage.passingByTheLandingPage()

    #Checking the DS Logon screen loaded
    !45.times{ break if (getPageTitle() == "Department of Veterans Affairs - Veteran Login Page"); sleep 1 }
    @loginpage.loginAsVeteran("zztest.patient01")

    !45.times{ break if (@main.getFooterText() == "Logged in as patient01, zztest"); sleep 1 }
    expect(@main.getFooterText()).to eq("Logged in as patient01, zztest")

    #Click the Left Side Toggle button
    @main.clickNavMenu()
    !45.times{ break if (getTextForElement(:id, "Assessments") == "Assessments"); sleep 1 }
    #Click Assessment button
    @navMenu.clickAssessmentBtn()
    
    #Verify that the title on Primary screen is Assessment
    !45.times{ break if (@hassInfo.getAssessmentTitleFromPrimaryScreen() == "Assessment"); sleep 1 }
    expect(@hassInfo.getAssessmentTitleFromPrimaryScreen()).to eq("Assessment")

    #Verify that the default text is displayed
    !45.times{ break if (@hassInfo.getDefaultDisplayFromDetailPage() == "Select an item from the list to start an assessment."); sleep 1 }
    expect(@hassInfo.getDefaultDisplayFromDetailPage()).to eq("Select an item from the list to start an assessment.")
    
  end

end