require_relative '../../globalized'
include Globalized

describe "[Story #MVAH-92:  Add_Previous_Screen_Icon_Button_MVAH_92_spec.rb]" do

  before(:all) do
    initializeConfigurations(BASE_URL)
    initializeAllObjects

    @common.loginEndsOnLandingPage("zztest.patient14", "patien14, zztest")
    expect(@main.getFooterText()).to eq("Logged in as patient14, zztest")
  end

  after(:all) do
    quitDriver()
  end

  context 'AC#JRNL-1903|TC #JRNL-1668: List/Filter View (Phone)' do

    it "My Story" do
      resizeWindowTo(320, 480)

      @main.clickNavMenu()
      !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }

      @nav_menu.clickMyStory()
      !45.times{ break if (getSecondaryHeader() == "My Story"); sleep 1 }

      @nav_menu.clickSummary()
      verifyBackButtonAndAltTextOnPhoneView("Summary", "My Story")

      @nav_menu.clickPersonalValues()
      verifyBackButtonAndAltTextOnPhoneView("Personal Values", "My Story")

      @nav_menu.clickAssessment()
      verifyBackButtonAndAltTextOnPhoneView("Assessment", "My Story")

      @nav_menu.clickReflections()
      verifyBackButtonAndAltTextOnPhoneView("Reflections", "My Story")

      @nav_menu.clickGoals()
      verifyBackButtonAndAltTextOnPhoneView("Goals", "My Story")

      @nav_menu.clickLearn()
      verifyBackButtonAndAltTextOnPhoneView("Learn", "My Story")
    end

    it "My Medical" do
      @main.clickNavMenu()
      !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }

      @nav_menu.clickMyMedical()
      !45.times{ break if (getSecondaryHeader() == "My Medical"); sleep 1 }

      @nav_menu.clickDiagnoses()
      verifyBackButtonAndAltTextOnPhoneView("Diagnoses", "My Medical")

      @nav_menu.clickSurgeries()
      verifyBackButtonAndAltTextOnPhoneView("Surgeries", "My Medical")

      @nav_menu.clickHospitalizations()
      verifyBackButtonAndAltTextOnPhoneView("Hospitalizations", "My Medical")

      @nav_menu.clickPregnancyHistory()
      verifyBackButtonAndAltTextOnPhoneView("Pregnancy History", "My Medical")

      @nav_menu.clickFamilyHistory()
      verifyBackButtonAndAltTextOnPhoneView("Family History", "My Medical")
    end

    it "Personal Trackers", :broken => true do
      @main.clickNavMenu()
      !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }

      @nav_menu.clickPersonalTrackers()
      !45.times{ break if (getSecondaryHeader() == "Personal Trackers"); sleep 1 }

      @nav_menu.clickBPAndPulse()
      verifyBackButtonAndAltTextOnPhoneView("Blood Pressure and Pulse", "Personal Trackers")

      @nav_menu.clickDailyEvents()
      verifyBackButtonAndAltTextOnPhoneView("Daily Events", "Personal Trackers")

      @nav_menu.clickDiet()
      verifyBackButtonAndAltTextOnPhoneView("Diet", "Personal Trackers")

      @nav_menu.clickExercise()
      verifyBackButtonAndAltTextOnPhoneView("Exercise", "Personal Trackers")

      @nav_menu.clickGlucose()
      verifyBackButtonAndAltTextOnPhoneView("Glucose (Self Tested)", "Personal Trackers")

      @nav_menu.clickHeight()
      verifyBackButtonAndAltTextOnPhoneView("Height", "Personal Trackers")

      @nav_menu.clickMood()
      verifyBackButtonAndAltTextOnPhoneView("Mood", "Personal Trackers")

      @nav_menu.clickPain()
      verifyBackButtonAndAltTextOnPhoneView("Pain", "Personal Trackers")

      @nav_menu.clickRespiration()
      verifyBackButtonAndAltTextOnPhoneView("Respiration", "Personal Trackers")

      @nav_menu.clickTemperature()
      verifyBackButtonAndAltTextOnPhoneView("Temperature", "Personal Trackers")

      @nav_menu.clickWeight()
      verifyBackButtonAndAltTextOnPhoneView("Weight", "Personal Trackers")
    end

    it "My Reminders", :broken => true do
      @main.clickNavMenu()
      !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }

      @nav_menu.clickReminders()
      !45.times{ break if (getSecondaryHeader() == "My Reminders"); sleep 1 }

      @nav_menu.clickAppointments()
      verifyBackButtonAndAltTextOnPhoneView("Appointment Reminders", "My Reminders")

      @nav_menu.clickMedications()
      verifyBackButtonAndAltTextOnPhoneView("Medication Reminders", "My Reminders")

      @nav_menu.clickPreventiveServices()
      verifyBackButtonAndAltTextOnPhoneView("Preventive Service Reminders", "My Reminders")

      @nav_menu.clickOther
      verifyBackButtonAndAltTextOnPhoneView("Other Reminders", "My Reminders")
    end

    it "Contacts", :broken => true do
      @main.clickNavMenu()
      !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }

      @nav_menu.clickContacts()
      !45.times{ break if (getSecondaryHeader() == "Contacts"); sleep 1 }

      @nav_menu.clickHealthCareContacts()
      verifyBackButtonAndAltTextOnPhoneView("Healthcare Contacts", "Contacts")

      @nav_menu.clickInsuranceContacts()
      verifyBackButtonAndAltTextOnPhoneView("Insurance Contacts", "Contacts")

      @nav_menu.clickCommunicationsLog()
      verifyBackButtonAndAltTextOnPhoneView("Communications Log", "Contacts")
    end

  end

  context "Add/Edit View",  :broken => true do

    it "My Story",  :broken => true do
      resizeWindowToDefault()

      @main.clickNavMenu()
      !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }

      @nav_menu.clickMyStory()
      !45.times{ break if (getSecondaryHeader() == "My Story"); sleep 1 }

      @nav_menu.clickGoals()
      verifyBackButtonAndAltTextOnRegularAddEntryView("Goals")
    end

    it "My Medical",  :broken => true do
      @nav_menu.clickMyMedical()
      !45.times{ break if (getSecondaryHeader() == "My Medical"); sleep 1 }

      @nav_menu.clickDiagnoses()
      verifyBackButtonAndAltTextOnRegularAddEntryView("Diagnoses")

      @nav_menu.clickSurgeries()
      verifyBackButtonAndAltTextOnRegularAddEntryView("Surgeries")

      @nav_menu.clickHospitalizations()
      verifyBackButtonAndAltTextOnRegularAddEntryView("Hospitalizations")

      @nav_menu.clickPregnancyHistory()
      verifyBackButtonAndAltTextOnRegularAddEntryView("Pregnancy History")

      @nav_menu.clickFamilyHistory()
      verifyBackButtonAndAltTextOnRegularAddEntryView("Family History")
    end

    it "Personal Trackers", :broken => true do
      @main.clickNavMenu()
      !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }

      @nav_menu.clickPersonalTrackers()
      !45.times{ break if (getSecondaryHeader() == "Personal Trackers"); sleep 1 }

      @nav_menu.clickBPAndPulse()
      verifyBackButtonAndAltTextOnRegularAddEntryView("Blood Pressure and Pulse")

      @nav_menu.clickDailyEvents()
      verifyBackButtonAndAltTextOnRegularAddEntryView("Daily Events")

      @nav_menu.clickDiet()
      verifyBackButtonAndAltTextOnRegularAddEntryView("Diet")

      @nav_menu.clickExercise()
      verifyBackButtonAndAltTextOnRegularAddEntryView("Exercise")

      @nav_menu.clickHeight()
      verifyBackButtonAndAltTextOnRegularAddEntryView("Height")

      @nav_menu.clickMood()
      verifyBackButtonAndAltTextOnRegularAddEntryView("Mood")

      @nav_menu.clickPain()
      verifyBackButtonAndAltTextOnRegularAddEntryView("Pain")

      @nav_menu.clickRespiration()
      verifyBackButtonAndAltTextOnRegularAddEntryView("Respiration")

      @nav_menu.clickTemperature()
      verifyBackButtonAndAltTextOnRegularAddEntryView("Temperature")

      @nav_menu.clickWeight()
      verifyBackButtonAndAltTextOnRegularAddEntryView("Weight")
    end

    it "My Reminders", :broken => true do
      @main.clickNavMenu()
      !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }

      @nav_menu.clickReminders()
      !45.times{ break if (getSecondaryHeader() == "My Reminders"); sleep 1 }

      @nav_menu.clickAppointments()
      verifyBackButtonAndAltTextOnRegularAddEntryView("Appointment Reminders")

      @nav_menu.clickMedications()
      verifyBackButtonAndAltTextOnRegularAddEntryView("Medication Reminders")

      @nav_menu.clickPreventiveServices()
      verifyBackButtonAndAltTextOnRegularAddEntryView("Preventive Service Reminders")

      @nav_menu.clickOther
      verifyBackButtonAndAltTextOnRegularAddEntryView("Other Reminders")
    end

    it "Contacts", :broken => true do
      @main.clickNavMenu()
      !45.times{ break if (@nav_menu.getNavMenuHeading() == "App Options"); sleep 1 }

      @nav_menu.clickContacts()
      !45.times{ break if (getSecondaryHeader() == "Contacts"); sleep 1 }

      @nav_menu.clickHealthCareContacts()
      verifyBackButtonAndAltTextOnRegularAddEntryView("Healthcare Contacts")

      @nav_menu.clickInsuranceContacts()
      verifyBackButtonAndAltTextOnRegularAddEntryView("Insurance Contacts")

      @nav_menu.clickCommunicationsLog
      verifyBackButtonAndAltTextOnRegularAddEntryView("Communications Log")
    end

  end

  ############### Local Function ##################

  def getAltTextByFeatureArea(featureName)
    return "Return to " + featureName + " options"
  end

  def getAltTextBySubGroup(subgroupName)
    return "Return to " + subgroupName + " table view"
  end

  def verifyBackButtonAndAltTextOnPhoneView(subGroupName, featureName)

    !15.times{ break if (getPrimaryHeader() == subGroupName); sleep 1 }

    expect(@entryForm.isBackButtonVisible()).to eq(true)

    expect(@entryForm.getBackButtonAltText()).to eq(getAltTextByFeatureArea(featureName))

    @entryForm.clickBackButton()

    !15.times{ break if (getSecondaryHeader() == featureName); sleep 1 }

  end

  def verifyBackButtonAndAltTextOnRegularAddEntryView(subGroupName)

    !15.times{ break if (getPrimaryHeader() == subGroupName); sleep 1 }
    @entryForm.clickAddEntryButton()
    expect(@entryForm.isBackButtonVisible()).to eq(true)
    expect(@entryForm.getBackButtonAltText()).to eq(getAltTextBySubGroup(subGroupName))
    @entryForm.clickBackButton()
    !15.times{ break if (getPrimaryHeader() == subGroupName); sleep 1 }

  end

end