require_relative '../../globalized'
include Globalized

describe "[Story# JRNL-40:  Display Information on About screen for Journal][Story #JRNL-2480:  My Story About Bullet]" do

  before(:all) do
    initializeConfigurations(BASE_URL)
    initializeAllObjects
  end

  after(:all) do
    quitDriver()
  end

  it "AC #JRNL-161: About Screen - AC #JRNL-3277:TC #JRNL-2756" do
    !45.times{ break if (@eula.acceptEulaVisible? == true); sleep 1 }
     @eula.clickAccept
    
    !45.times{ break if (@landing.getTitle == "My VA Health"); sleep 1 }
    expect(@landing.getTitle).to eq("My VA Health")
    expect(@landing.getFooterText).to eq("Not logged in")
    
    @main.clickUserMenu
    !45.times{ break if (getTextForElement(:id, "about") == "About"); sleep 1 }
    expect(@menu.verifyAboutButtonPresent).to eq("About")
    waitForPageToFinishLoading
    @menu.clickAboutBtn
    
   #Version Number
    !45.times{ break if (@about.getAboutHeading == "About"); sleep 1 }
    expect(@about.getAboutHeading).to eq("About")
    #expect(@about.getVersionFromApp).to eq(@about.getVersionFromVersionFile)
    #Brief Summary of the App
    aboutContent = @about.getAboutText

    puts "Entire about content " + aboutContent

    expect(aboutContent.include?("My VA Health - " + @about.getVersionFromApp)).to be true
    expect(aboutContent.include?("The My VA Health app allows you to enter, view, and track personal health information, which can be shared with your healthcare team.")).to be true
    expect(aboutContent.include?("You can use the current version of the app to:")).to be true
    expect(aboutContent.include?("Track personal health information including vital signs, diet, exercise, and daily events")).to be true
    expect(aboutContent.include?("Create and manage appointment, medication and preventive service reminders")).to be true
    expect(aboutContent.include?("View notifications received from your VA care team")).to be true
    expect(aboutContent.include?("Reflect on what matters to you in your life and how your health can help you reach your life goals")).to be true
    expect(aboutContent.include?("Complete health assessments")).to be true
    expect(aboutContent.include?("Share elements of your health information with your care team")).to be true


    expect(aboutContent.include?("A DS Logon account (level 2) is needed for access.")).to be true
    #Link to EULA
    expect(aboutContent.include?("End User License Agreement (EULA)")).to be true
        
    @about.clickShowEULA
    switchWindowToWindowHandleLast
    
    !45.times{ break if (@eula.getEulaHeading == "End User License Agreement" ); sleep 1 }
    expect(@eula.getEulaHeading).to eq("End User License Agreement")
    
    closeBrowser
    switchWindowToWindowHandleFirst
    
    @about.clickOKfromAboutScreen
    
  end

end
