require 'rubygems'
require 'selenium-webdriver'

require_relative  "../module/DriverUtility"

class UserGuide
  include DriverUtility

  FEATURES_PATH = "/features/"
  GENERAL_USE_PATH = "/general-use/"
  USER_MENU_FEATURES_PATH = "/user-menu-features/"

  GENERAL_USE_LINKS = ["to-use-this-app", "new-users", "navigation", "self-entered-data"]
  FEATURES_LINKS = ["home", "my-profile", "my-story", "my-medical", "personal-trackers", "my-reminders", "notifications", "contacts", "assessments", "images-and-documents", "health-report"]
  USER_MENU_FEATURES_LINKS = ["about", "help", "resources", "tour", "login-logout", "launchpad"]

  def initialize(driver)
    @driver = driver
  end

  def verifyHelpScreenHeading()
    return getTextForElement(:css, "div.modal-content div:nth-of-type(1) h3")
  end
  
  def clickUserGuideLink()
    #:css, href[ng-click=showUserGuide()]
    click(:css, "div.modal-body p:nth-of-type(3) a")
  end
  
  def getUserGuideScreenHeader()
    return getTextForElement(:css, "body.terms-of-cond-wrapper div h1")
  end
  
  def clickAssessmentsLinkFromTableContents()
    #:link, "2.1 Health Assessment
    #"ol.table-of-contents li:nth-of-type(2) ol li a"
    click(:css, "a[href='#/features/assessments']")
  end

  def clickLink(path)
    cssPath = "a[href='#" + path + "']"
    click(:css, cssPath)
  end

  def clickAppTourButton()
    waitForPageToFinishLoading
    click(:css, '#tour')
  end

  def clickMobileVAHealthAppStoreLink()
    click(:css, "a[href='http://URL/appstore']")
  end

  def clickVAFacilityLocatorLink()
    click(:css, "a[href='http://1.usa.gov/1TTdj42']")
  end

  def clickGeneralFeedbackToVALink()
    click(:css, "a[href='https://URL/app/my-va-health']")
  end

  def clickUserGuideLinkNew()
    click(:css, "a[ng-click='showUserGuide()']")
  end

  def clickBackToTop()
    click(:css, "a[href='#/top']")
  end

  def getGeneralUsePath(part)
    return GENERAL_USE_PATH + part;
  end

  def getFeaturesPath(part) 
    return FEATURES_PATH + part
  end

  def getUserMenuFeaturesPath(part)
    return USER_MENU_FEATURES_PATH + part
  end

  def getFeatureLinks()
    return FEATURES_LINKS
  end

  def getGeneralUseLinks()
    return GENERAL_USE_LINKS
  end

  def getUserMenuLinks()
    return USER_MENU_FEATURES_LINKS
  end

  def isLinkVisible(path)
    cssPath = "a[href='#" + path + "']"
    return isElementVisible(:css, cssPath)
  end

  def isContentDisplayedOnPage(idStr)
    element = getElement(:id, idStr)
    
    maxY = @driver.execute_script("return document.querySelector('html').offsetHeight - window.innerHeight;").to_i
    elementY = element.location.y
    elementY = elementY > maxY ? maxY : elementY
    currentY = @driver.execute_script("return window.scrollY;").to_i
    
    return elementY < currentY + 15 && elementY > currentY - 15
  end

  def getHeaderContent(path) 
    return getTextForElement(:id, path).strip
  end

  #####################
  # GENERAL USE
  def getToUseAppContent()
    return getTextForElement(:css, "div.terms-of-cond > section:nth-of-type(1) > section:nth-of-type(1) > p:nth-child(2)").strip
  end

  def getNewUsersContent()
    return getTextForElement(:css, "div.terms-of-cond > section:nth-of-type(1) > section:nth-of-type(2) > p:nth-child(2)").strip
  end

  def getSelfEnteredDataContent()
    return getTextForElement(:css, "div.terms-of-cond > section:nth-of-type(1) > section:nth-of-type(4) > p:nth-child(2)").strip
  end

  def getNavigationParaText(subSectionIndex)
    return getTextForElement(:css, "div.terms-of-cond > section:nth-of-type(1) > section:nth-of-type(3) > p:nth-of-type(" + subSectionIndex.to_s + ")").strip
  end

  def getNavigationListElements(subSectionIndex)
    return getTextForElement(:css, "div.terms-of-cond > section:nth-of-type(1) > section:nth-of-type(3) > ul:nth-of-type(" + subSectionIndex.to_s + ")").strip
  end

  #####################
  # USER MENU FEATURES
  # All sections in user guide under 'User Menu Features' are just header + one paragraph, so very repetitive
  def getUserMenuFeatureContent(subSectionIndex)
    return getTextForElement(:css, "div.terms-of-cond > section:nth-of-type(3) > section:nth-of-type(" + subSectionIndex.to_s + ") > p:nth-child(2)").strip
  end

  #####################
  # MAIN FEATURES
  # Helper to get first paragraph under a given feature sub-section
  def getFeatureParagraphText(subSectionIndex, paragraphIndex)
    return getTextForElement(:css, "div.terms-of-cond > section:nth-of-type(2) > section:nth-of-type(" + subSectionIndex.to_s + ") > p:nth-of-type(" + paragraphIndex.to_s + ")").strip
  end

  def getFeatureListElements(subSectionIndex, listIndex)
    getTextForElement(:css, "div.terms-of-cond > section:nth-of-type(2) > section:nth-of-type(" + subSectionIndex.to_s + ") > ul:nth-of-type(" + listIndex.to_s + ")").strip
  end

  #####################
  # NOTIFICATIONS
  def clickNotificationsLinkFromTableContents()
    click(:css, "a[href='#/features/notifications']")
  end

  def getNotificationsContentTitle()
    return getTextForElement(:id, "/features/notifications").strip
  end

  def getNotificationsFirstParaText()
    return getTextForElement(:css, "div.terms-of-cond > section:nth-of-type(3) > section:nth-of-type(7) p:nth-of-type(1)").strip
  end

  def getNotificationsListElements
    return getTextForElement(:css, "div.terms-of-cond > section:nth-of-type(3) > section:nth-of-type(7) ul li").strip + getTextForElement(:css, "div.terms-of-cond > section:nth-of-type(3) > section:nth-of-type(7) ul li:nth-of-type(2)").strip
  end

  def getNotificationsSecondParaText()
    return getTextForElement(:css, "div.terms-of-cond > section:nth-of-type(3) > section:nth-of-type(7) p:nth-of-type(2)").strip
  end

  def getNotificationsThirdParaText()
    return getTextForElement(:css, "div.terms-of-cond > section:nth-of-type(3) > section:nth-of-type(7) p:nth-of-type(3)").strip
  end

  #####################
  # ASSESSMENTS
  def getAssessmentsContentTitle()
    return getTextForElement(:id, "/features/assessments").strip
  end
  
  def getHealthAssessmentSummaryText()
    return getTextForElement(:css, "div.terms-of-cond section:nth-of-type(2) section:nth-of-type(9) p").strip
  end
  
  def getHealthAssessmentToUseThisFeatureText()
    puts "!!!  " + getTextForElement(:css, "div.terms-of-cond > section:nth-of-type(2) section:nth-of-type(9) p:nth-of-type(2)").strip
    return getTextForElement(:css, "div.terms-of-cond > section:nth-of-type(2) section:nth-of-type(9) p:nth-of-type(2)").strip
  end

  def getHealthAssessmentNavigationPrelude()
    return getTextForElement(:css, ".terms-of-cond > section:nth-of-type(2) section:nth-of-type(9) p:nth-of-type(3)").strip
  end
  
  def getNthAssessmentNavigateionContent(number)
    return getTextForElement(:css, "div.terms-of-cond > section:nth-of-type(2) section:nth-of-type(9) ul li:nth-of-type(" + number.to_s + ")").strip
  end
  
  def getAssessmentSubmissionContent()
    return getTextForElement(:css, "div.terms-of-cond > section:nth-of-type(2) section:nth-of-type(9) p:nth-of-type(4)").strip
  end
  
  def getPrintAssessmentContent()
    return getTextForElement(:css, "div.terms-of-cond > section:nth-of-type(2) section:nth-of-type(9) p:nth-of-type(5)").strip
  end

  #####################
  # REMINDERS
  def getRemindersContent()
    return getTextForElement(:css, "div.terms-of-cond  section:nth-of-type(2) section:nth-of-type(6) p:nth-of-type(1)").strip
  end

  #####################
  # ABBREVIATION TABLE
  def getAbbreviationTableRow(rowNumber)
    return getTextForElement(:css, "div.terms-of-cond section:nth-of-type(4) table tr:nth-of-type(" + rowNumber.to_s + ")").strip
  end
  
end