require 'rubygems'
require 'selenium-webdriver'
require 'jquery'

require_relative  "../module/DriverUtility"

class Time_Picker
  include DriverUtility


  def initialize(driver)
    @driver = driver
  end

  def clickTimePickerButton()
    click(:css, "i.icon-time")
  end

  def convertMinuteToRowID(minStr)
    minRowCount = getElements(:css, 'b.minute ul li').length

    minRowCount.downto(1) do |rowID|
      mintueStr = getTextForElement(:css, "b.minute ul li:nth-of-type(" + rowID.to_s + ") button")
      if mintueStr == minStr then
        #puts "[convertMonthToRowID] RowId " + rowID.to_s
        return rowID
      end
    end
  end

  def setHour(hourNum)
    hour = getTextForElement(:css, "button[data-field='hour'] + .field-val.ng-binding")
    puts hour
    puts hourNum
    while hour != hourNum do
      puts "Hour:       " + hour
      puts "Hour NUM:            " +hourNum
      click(:css, "button[data-field='hour']")
      hour = getTextForElement(:css, "button[data-field='hour'] + .field-val.ng-binding")
    end
    sleep 1.5
  end

  def setMinute(minStr)
    minute = getTextForElement(:css, "button[data-field='minute'] + .field-val.ng-binding")
    puts minute
    while minute != minStr do
      puts "Minute:       " + minute
      puts "Minute NUM:            " +minStr
      click(:css, "button[data-field='minute']")
      minute = getTextForElement(:css, "button[data-field='minute'] + .field-val.ng-binding")
    end
    sleep 1.5
  end

  def setAMPM(whenStr)
    element_text = getTextForElement(:css, "button.btn-am + .field-val.ng-binding")
    if (whenStr == "AM") and (element_text == "PM") then
      click(:css, ".btn.btn-default.btn-am")
    elsif (whenStr == "PM") and (element_text == "AM") then
      click(:css, ".btn.btn-default.btn-pm")
    end
    sleep 0.5
  end

  def areMinutesIn5MinIntervals()
    intervalSetCorrectly = true
    minuteRowCount = getElements(:css, 'b.minute ul li').length

    for i in 1..minuteRowCount
      displayedText = getTextForElement(:css, 'b.minute ul li:nth-of-type(' + i.to_s + ') button')
      #puts "displayedText= "+ displayedText
      #puts "displayedText.reverse[0,1].reverse = " + displayedText.reverse[0,1].reverse
      if (displayedText.reverse[0,1].reverse != '0') and (displayedText.reverse[0,1].reverse != '5') then
        intervalSetCorrectly = false
        break
      end

    end

    return intervalSetCorrectly

  end

  def clickSet()
    click(:id, "set-btn")
  end

  def clickCloseBtn()
    click(:css, ".btn-close")
  end

  def getSetButtonText()
    #puts ("[GetSetButton Text ] " + getTextForElement(:css, "#set-btn span:nth-of-type(2)"))
    return getTextForElement(:css, "#set-btn span:nth-of-type(2)")
  end

  def getSelectedTimePeriod()
    getTextForElement(:css, "button.btn-am + .field-val.ng-binding")
  end

  def getSelectedMinute()
    getTextForElement(:css, "button[data-field='minute'] + .field-val.ng-binding")
  end

  def getSelectedHour()
    getTextForElement(:css, "button[data-field='hour'] + .field-val.ng-binding")
  end

  def getTime()
    return getTextFromInput(:css, "input[name='time']")
  end

  def getTimePerEntry(i)
    return getTextFromInput(:css, "input[name='time_#{i.to_s}']")
  end

  def setTimeFromGUI(hour, minStr, period)
    setHour(hour)
    sleep 1
    setMinute(minStr)
    sleep 1
    setAMPM(period)
    sleep 1
    clickSet()
    sleep 1
  end

  def isTimeDisplayedCorrectly(timeStr)

    displayedCorrectly = true
    displayedTimeStr = getTextFromInput(:css, "input[name='time_0']")

    if displayedTimeStr != timeStr then
      displayedCorrectly = false
    end

    return displayedCorrectly
  end

end