require 'rubygems'
require 'selenium-webdriver'

require_relative  "../module/DriverUtility"
require_relative  "../helpers/entry_form"

class Surgeries < EntryForm
  include DriverUtility

  SURGERY = "input[name='surgery']"
  PROVIDER_FACILITY = "input[name='facility']"
  YES_RADIO = "input[value='Yes']"
  NO_RADIO = "input[value='No']"
  REASON = "input[name='reason']"
  FIRST_NAME = "input[name='firstName']"
  LAST_NAME = "input[name='lastName']"
  CLINIC_ORGANIZATION = "input[name='organization']"
  FACILITY_HOSPITAL = "input[name='facility']"
  NOTE = "textarea[name='Notes']"
  SOURCE = "label[name='source']"

  def initialize(driver)
    super(driver)
  end

  ###############
  ### GETTERS ###
  ###############

  def getScreenContent()
    return getElement(:css, "entry-form[name='form']").text()
  end

  def getNameOfSurgery()
    return getElement(:css, SURGERY).attribute("value")
  end

  def getNameOfSurgeryElement()
    return getElement(:css, SURGERY)
  end

  def getDateOfSurgeryProcedure()
    return getElement(:css, SURGERY_DATE).attribute("value")
  end

  def isEstimatedYes()
    return @driver.find_element(:css, YES_RADIO).attribute('checked') ? true : false
  end

  def isEstimatedNo()
    return @driver.find_element(:css, NO_RADIO).attribute('checked') ? true : false
  end

  def getReasonForSurgery()
    return getElement(:css, REASON).attribute("value")
  end

  def getFirstName()
    return getElement(:css, FIRST_NAME).attribute("value")
  end

  def getLastName()
    return getElement(:css, LAST_NAME).attribute("value")
  end

  def getClinicOrganization()
    return getElement(:css, CLINIC_ORGANIZATION).attribute("value")
  end

  def getFacilityHospital()
    return getElement(:css, FACILITY_HOSPITAL).attribute("value")
  end

  def getSource()
    return getElement(:css, SOURCE).text()
  end

  def getNote()
    return getElement(:css, NOTE).attribute("value")
  end

  def getCountDownDisplayForNote()
    return getTextForElement(:css, "span[ng-if='characterCounter']")
  end

  ###############
  ### SETTERS ###
  ###############

  def setNameOfSurgery(surgery)
    @driver.find_element(:css, SURGERY).clear()
    @driver.find_element(:css, SURGERY).send_keys(surgery)
  end

  def setEstimatedYes()
    click(:css, YES_RADIO)
  end

  def setEstimatedNo()
    click(:css, NO_RADIO)
  end

  def setReasonForSurgery(reason)
    @driver.find_element(:css, REASON).clear()
    @driver.find_element(:css, REASON).send_keys(reason)
  end

  def setFirstName(name)
    @driver.find_element(:css, FIRST_NAME).clear()
    @driver.find_element(:css, FIRST_NAME).send_keys(name)
  end

  def setLastName(name)
    @driver.find_element(:css, LAST_NAME).clear()
    @driver.find_element(:css, LAST_NAME).send_keys(name)
  end

  def setClinicOrganization(clinic)
    @driver.find_element(:css, CLINIC_ORGANIZATION).clear()
    @driver.find_element(:css, CLINIC_ORGANIZATION).send_keys(clinic)
  end

  def setFacilityHospital(facility)
    @driver.find_element(:css, FACILITY_HOSPITAL).clear()
    @driver.find_element(:css, FACILITY_HOSPITAL).send_keys(facility)
  end

  def setNote(note)
    @driver.find_element(:css, NOTE).clear()
    @driver.find_element(:css, NOTE).send_keys(note)
  end

  ################
  ### CLICKERS ###
  ################

  def clickDateOfSurgeryCalendarBtn()
    click(:css, "div[name='date'] > div > div > span > button")
  end

end
