require 'rubygems'
require 'selenium-webdriver'

require_relative  "../module/DriverUtility"
require_relative  "../pages/common"
require_relative  "../pages/nav_menu"
require_relative  "../pages/reminders"
require_relative '../globalized'

class Screening
  include Globalized
  include DriverUtility
  PS_TITLE = "h4.ps-title"
  CPS_ENTRY_HEADER_NEW = "Add Preventive Service"
  CPS_ENTRY_HEADER_EDIT = "Edit Preventive Service"
  NEXT_DUE_DATE = "date-control[label='Next Due Date'] input"
  NEXT_DUE_DATE_LABEL = "date-control[label='Next Due Date'] label span.input-label-content"
  LAST_ADMINISTERED_DATE = "input[name='lastAdministered']"
  STATUS_LABEL = "fieldset.status-filter-wrapper div.left"
  INSTRUCTIONAL_TEXT = "form div div:nth-of-type(7) div div"
  NOTES = "textarea[name='Notes']"
  GRADUATION_CAP = "span.icon-gradcap"
  LEARN_MORE_TEXT = "a[ng-click='openAboutPSModal()']"
  SCREENING_FOR_CHLAMYDIA_GONORRHEA_PDF_LINK = "a[href='_assets/pdfs/gonchlamfinalrsfact.pdf']"
  OSTEOPOROSIS_URL = "a[href='http://www.veteranshealthlibrary.org/Search/142,85779_VA']"
  COLORECTAL_CANCEL_URL = "a[href='http://www.healthfinder.gov/HealthTopics/Category/doctor-visits/screening-tests/get-tested-for-colorectal-cancer']"
  HIGH_CHOLESTEROL_URL = "a[href='http://www.ahrq.gov/patients-consumers/prevention/disease/cholpatient.html']"
  FLU_COMPLICATIONS_URL = "a[href='http://www.cdc.gov/flu/about/disease/high_risk.htm']"
  WHO_SHOULD_VACCINE_URL = "a[href='http://www.cdc.gov/flu/protect/whoshouldvax.htm']"
  HIV_URL = "a[href='http://www.cdc.gov/hiv/basics/testing.html']"
  TETANUS_VACCINE_URL = "a[href='http://www.cdc.gov/tetanus/vaccination.html']"
  PNEUMOCOCCAL_VACCIN_URL = "a[href='http://www.cdc.gov/pneumococcal/vaccination.html']"

  #TETANUS_TD_URL = "a[href='http://www.cdc.gov/vaccines/hcp/vis/vis-statements/td.htm']"
  TETANUS_TD_URL = "a[href='http://www.cdc.gov/vaccines/hcp/vis/vis-statements/td.html']"
  TETANUS_TDAP_URL = "a[href='http://www.cdc.gov/vaccines/hcp/vis/vis-statements/tdap.html']"

  BELL_ICON = "i.icon-notification"

  LAST_MAMMOGRAM_RESULTS_LABEL = "input-select[name='Mammogram-result'] div label span.input-label-content"
  LAST_MAMMOGRAM_RESULTS = "select[name='Mammogram-result']"
  LAST_MAMMOGRAM_DATE = "input[name='Mammogram-lastCompleted']"
  NEXT_DUE_DATE_MSG = "div[ng-show='nextDueDateMessage']"
  NOTES_LABEL = "span[name='NotesLabel']"

  LAST_PAP_DATE_LABEL = "date-control[name='Pap Smear-lastCompleted'] label span.input-label-content"
  LAST_PAP_RESULTS_LABEL = "input-select[name='Pap Smear-result'] label span.input-label-content"
  LAST_HPV_TEST_LABEL = "date-control[name='HPV Test-lastCompleted'] label span.input-label-content"
  LAST_HPV_TEST_RESULTS_LABEL = "input-select[name='HPV Test-result'] label span.input-label-content"
  LAST_CHOLESTEROL_RESULTS_LABEL = "input-select[name='result'] label span.input-label-content"

  SYSTOLIC_LABEL = "input-number[name='Systolic'] label span.input-label-content"
  DIASTOLIC_LABEL = "input-number[name='Diastolic'] label span.input-label-content"

  def initialize(driver)
    @driver = driver
    @common = Common.new(@driver)
    @nav_menu = Nav_menu.new(@driver)
    @reminders = Reminders.new(@driver)
    @main = Main.new(@driver)
    #@base_url = baseUrl
    #sleep 1.5
  end

  PS = ".preventive-services span div div span"
  APPOINTMENTS_BTN = ".btn.btn-default.appointments"
  MEDICATIONS_BTN = ".btn.btn-default.medications"
  OTHER_BTN = ".btn.btn-default.other"

  def getNotificationContent()
    return getElement(:css, "div[notification-delivery-options]").text()
  end

  def getScreenContent()
    return getElement(:css, "entry-form[name='entryForm']").text()
  end

  def getNewEntryHeader()
    return CPS_ENTRY_HEADER_NEW;
  end

  def getEditEntryHeader()
    return CPS_ENTRY_HEADER_EDIT
  end

  def getDetailHeader()
    return getTextForElement(:css, "h4")
  end

  def clickAppointments()
    waitForPageToFinishLoading
    click(:css, APPOINTMENTS_BTN)
  end

  def clickMedications()
    waitForPageToFinishLoading
    click(:css, MEDICATIONS_BTN)
  end

  def clickPreventiveServices()
    waitForPageToFinishLoading
    click(:css, PS)
  end

  def clickOther()
    waitForPageToFinishLoading
    click(:css, OTHER_BTN)
  end

  def clickAddEntry()
    waitForPageToFinishLoading
    click(:css, "[ng-click='getDetails()']")
  end

  def isAddButtonRightJustified()
    element = getElement(:css, "button[title='Add Entry']")
    classValue = element.attribute("class")
    return classValue.include?("right")
  end

  def clickInformationButton()
    click(:css, "span i[class='icon icon-info']")
  end

  def isInformationButtonPresent()
    isElementPresentAndVisible(:css, "span i[class='icon icon-info']")
  end

  def clickLearnMoreLink()
    click(:css, "a[ng-click='openAboutPSModal()']")
  end

  def isLearnMoreLinkPresent()
    isElementPresentAndVisible(:css, "a[ng-click='openAboutPSModal()']")
  end

  def selectResult(selectOption)
    puts "Result is " + selectOption
    click(:css, "select[name='result'] option[value='" + selectOption + "']")
  end

  def selectShinglesVaccinationResult(selectOption)
    puts "Result is " + selectOption
    click(:css, "select[name='Shingles Vaccination-result'] option[value='" + selectOption + "']")
  end

  def selectMammogramResult(selectOption)
    puts "Result is " + selectOption
    click(:css, "select[name='Mammogram-result'] option[value='" + selectOption + "']")
  end

  def selectOsteoResult(selectOption)
    @driver.execute_script("$('select[name=result]').scope().ngModel = '" + selectOption + "'")
    @driver.execute_script("$('select[name=result]').scope().$digest()")

    # puts "Result is " + selectOption
    # click(:css, "select[name='result'] option[value='" + selectOption + "']")

    # select = getElement(:css, "select[name='result']")
    # options = select.find_elements(:tag_name, "option")
    # options.each do |option|
    #   if(option.attribute('value') == selectOption)
    #     option.click
    #     break
    #   end
    # end
  end

  def selectOption(yesNo)
    puts "Result is " + yesNo
    click(:css, "select[name='fastingState'] option[value='" + yesNo + "']")
  end

  def isThisValueDefaultToTheDropdown(type, listName)
    defaultSetCorrectly = true
    select = getElement(:css, "select[name='" + listName+ "']")
    options = select.find_elements(:tag_name, "option")

    options.each do |option|
      whatsShown= option.attribute('value')
      if whatsShown == nil or whatsShown.length == 0 then
        displayedText = "Select"
      else
        displayedText = whatsShown
      end

      if(option.selected? == true) and (displayedText == type) then
          defaultSetCorrectly = true
          break
      else
          defaultSetCorrectly = false
      end
    end

    return defaultSetCorrectly
  end


  def setServiceName(text)
    @driver.find_element(:css, "input[name='serviceName']").clear
    @driver.find_element(:css, "input[name='serviceName']").send_keys(text)
  end

  def setReminderTitle(text)
    @driver.find_element(:css, "input[name='title']").clear
    @driver.find_element(:css, "input[name='title']").send_keys(text)
  end

  def setLocation(text)
    @driver.find_element(:css, "input[name='location']").clear
    @driver.find_element(:css, "input[name='location']").send_keys(text)
  end

  def setCholesterol(number)
    @driver.find_element(:css, "input[name='result']").send_keys(number)
  end

  def setNote(text)
    @driver.find_element(:css, "textarea[name='Notes']").clear
    @driver.find_element(:css, "textarea[name='Notes']").send_keys(text)
  end

  def selectNotificationStatus(status)
    click(:css, "input[name*='notificationOption'][type='radio'][value='" + status +"']")
    sleep 2
  end

  def selectPertussis(number)
    click(:css, "div label:nth-of-type(" + number.to_s + ")")
    sleep 0.5
  end

  def selectNotifyMe(type)
    click(:css, "select[name='NotificationDate'] option[value='" + type + "']")
    sleep 0.5
  end

  def clickButton(name)
    click(:css, '[ng-click="' + name + ""'()"]')
    sleep 1
  end

  def clickSaveButton()
    clickJquery("button[ng-click='confirmSave()']")
    sleep 1
  end

  def clickConfirmSaveButton()
    click(:css, '[ng-click="confirmSave()"]')
    sleep 1
  end

  def clickCancelButton()
    click(:css, '[ng-click="cancel()"]')
    sleep 1
  end

  def clickDeleteButton()
    click(:css, '[ng-click="delete()"]')
    sleep 1
  end

  def checkNthScreeningStatus(number, desiredStatus)
    statusIsCorrect = true
    displayedStatus = getTextForElement(:css, ".list-table li:nth-of-type(" + number.to_s + ") span:nth-of-type(1) .cell-content")

    if displayedStatus != desiredStatus then
      statusIsCorrect = false
    end

    return statusIsCorrect
  end


  def isThePSScreeningsSortedCorrectlyInTableView()
    sortedCorrectly = true
    groupLength = getElements(:css, '.list-table li').length
    today = getDateNthDaysAgo(0, "%m/%d/%Y")
    todayDate = DateTime.strptime(today, format="%m/%d/%Y")
    displayedDate = getTextForElement(:css, ".list-table li:nth-of-type(1) span:nth-of-type(3) .cell-content")
    previousDate = DateTime.strptime(displayedDate, format="%m/%d/%Y")
    previousName = getTextForElement(:css, ".list-table li:nth-of-type(1) span:nth-of-type(2) .cell-content")

    for i in 2..groupLength
      displayedStatus = getTextForElement(:css, ".list-table li:nth-of-type(" + i.to_s + ") span:nth-of-type(1) .cell-content")
      displayedDate = getTextForElement(:css, ".list-table li:nth-of-type(" + i.to_s + ") span:nth-of-type(3) .cell-content")

      if displayedDate == nil or displayedDate == "" or displayedDate == "None" then
        displayedDate = "01/01/2099" #Assign a far future date when date is null
      end

      thisDueDate = DateTime.strptime(displayedDate, format="%m/%d/%Y")
      thisName = getTextForElement(:css, ".list-table li:nth-of-type(" + i.to_s + ") span:nth-of-type(2) .cell-content")

      if(previousDate > thisDueDate) then
        sortedCorrectly = false
        break
      elsif (previousDate == thisDueDate) then
        if (previousName.downcase > thisName.downcase) then
          sortedCorrectly = false
          break
        end
      elsif (previousDate > todayDate) and (displayedStatus.length > 0) then
        sortedCorrectly = false
        break
      end

      previousDate = thisDueDate
      previousName = thisName
    end

    return sortedCorrectly
  end

  def getNextDueDate()
    return getTextFromInput(:css, "input[name='nextDueDate']")
  end

  def setNextDueDate(date)
    @driver.find_element(:css, "input[name='nextDueDate']").clear
    @driver.find_element(:css, "input[name='nextDueDate']").send_keys(date)
  end

  def setLastAdministeredDate(date)
    @driver.find_element(:css, "input[name='lastAdministered']").clear
    @driver.find_element(:css, "input[name='lastAdministered']").send_keys(date)
  end

  def getNthPSScreeningName(number)
    return getTextForElement(:css, ".list-table li:nth-of-type(" + number.to_s + ") span:nth-of-type(2) .cell-content")
  end

  def getNthPSDueDate(number)
    return getTextForElement(:css, ".list-table li:nth-of-type(" + number.to_s + ") span:nth-of-type(3) .cell-content")
  end

  def getPSscreeningCount()
    waitForPageToFinishLoading
    return getElements(:css, ".list-table ul li").length
  end

  def verifyDueDate(psName, nextDueDate)
    psLength = getPSscreeningCount()
    for i in 1..psLength
      name = getNthPSScreeningName(i)
      dueDate = getNthPSDueDate(i)

      if psName == name and dueDate == nextDueDate then
        return i
        break
      end
    end
    return -1
  end


  def findIndexWithGivenPSName(psName)
    psLength = getPSscreeningCount()

    for i in 1..psLength
      name = getNthPSScreeningName(i)
      puts "name" + name
      if psName == name then
        return i
        break
      end
    end
    return -1
  end

  def getPSNameText(psName)
    psLength = getPSscreeningCount()
    for i in 1..psLength
      name = getNthPSScreeningName(i)
      if psName == name then
        print name
        expect(name).to eq("Blood Test Screening (Edited Name - 50 characters)")
        break
      end
    end
    return -1
  end

  def selectPapResult(result)
    #puts "Result is " + result
    click(:css, "select[name='Pap Smear-result'] option[value='" + result + "']")
  end

  def selectHPVResult(result)
    #puts "Result is " + result
    click(:css, "select[name='HPV Test-result'] option[value='" + result + "']")
  end

  def selectCholesterolResult(result)
    click(:css, "select[name='result'] option[value='" + result + "']")
  end

  def setPapLocation(text)
    @driver.find_element(:css, "input[name='Pap Smear-location']").clear
    @driver.find_element(:css, "input[name='Pap Smear-location']").send_keys(text)
  end

  def setHPVLocation(text)
    @driver.find_element(:css, "input[name='HPV Test-location']").clear
    @driver.find_element(:css, "input[name='HPV Test-location']").send_keys(text)
  end

  def setBreastCancerLocation(text)
    @driver.find_element(:css, "input[name='Mammogram-location']").clear
    @driver.find_element(:css, "input[name='Mammogram-location']").send_keys(text)
  end

  def verifyTotalCharacterInNarrative()
    boundaryTest = false
    part1 = "VerifyTheTotalAllowedCharactersInNarrativeField001"
    part2 = "VerifyTheTotalAllowedCharactersInNarrativeField002"
    part3 = "VerifyTheTotalAllowedCharactersInNarrativeField003"
    part4 = "VerifyTheTotalAllowedCharactersInNarrativeField004"
    part5 = "VerifyTheTotalAllowedCharactersInNarrativeField005"
    typeInText = part1 + part2+ part3 + part4 + part5

    setNote(typeInText)

    counterText = getTextForElement(:css, "span[ng-if='characterCounter']")
    if counterText == "0 characters left"
      boundaryTest = true
    else
      boundaryTest = false
    end

    return boundaryTest

  end

  def selectTypeOfTest(testtype)
    puts "Result is " + testtype
    click(:css, "select[name='testType'] option[value='" + testtype + "']")

    # result = "Abnormal"
    # select = getElement(:css, "input-select[label='Type of Test'] select")
    # # puts getElement(:css, "input-select[label='HPV Test Results'] select option[value='" + result + "']")
    # options = select.find_elements(:tag_name, "option")
    # options.each do |option|
    #   if(option.attribute('value') == testtype)
    #     option.click
    #     break
    #   end
    # end
  end

  def setSystolic(text)
    @driver.find_element(:css, "input[name='Systolic']").clear
    @driver.find_element(:css, "input[name='Systolic']").send_keys(text)
  end

  def setDiastolic(text)
    @driver.find_element(:css, "input[name='Diastolic']").clear
    @driver.find_element(:css, "input[name='Diastolic']").send_keys(text)
  end

  def switchUserAndLogBackInToPS(loginId, userNameOnFooter)
    @common.switchUserThenLogBackInAndGoToLeftSideNav(loginId, userNameOnFooter)
    sleep 5
    @nav_menu.clickReminders()
    !45.times{ break if (@reminders.getFocusedElementText() == @reminders.getSecondaryHeader()); sleep 1 }
    @reminders.clickSubGroup("preventive-services")
    waitForPageToFinishLoading()
  end

  def isRequiredFieldIndicatorPresent(cssPath)
    isPresent = true
    if getTextForElement(:css, cssPath).strip != "*" or is_element_present(:css, cssPath) == false then
      isPresent = false
    end

    return isPresent
  end

  def getTableViewHeader()
    return getTextForElement(:css, "div.list-table div.header span.hidden-xs span")
  end

  def getGuidelineText()
    return getTextForElement(:css, "div[ng-show='nextDueDateMessage']")
  end
  def getGuidelineMessage()
    return getTextForElement(:css, "div[ng-show='nextDueDateMessage']")
  end

  def getInstructionalTextWhenEmailIsNotAvailable()
    return getElement(:css, ".col-xs-11.pull-right .sr-only").text()
  end

  def getEmailFromNotification()
    return getTextForElement(:css, "div.email")
  end

  def clickNotificationDeliveryCheckBox(valueStr)
    click(:css, "input[type='checkbox'][value='" + valueStr +"']")
    sleep 2
  end

  def clickNotifyMeAboutThisDueDateCheckbox(valueString)
    click(:css, "input[name='notificationTriggerDate'][value='#{valueString}']")
    sleep 1
  end

  def returnToPSAndEditAPS(psName)
    @main.clickNavMenu
    waitForPageToFinishLoading
    @driver.find_element(:css, "button[id='MyReminders']").click
    waitForPageToFinishLoading
    @reminders.clickSubGroup("preventive-services")
    waitForPageToFinishLoading
    !5.times{ break if (@reminders.getPrimaryHeader() == "Preventive Services"); sleep 1 }
    !5.times{ break if (getTableViewHeader() == "Status"); sleep 1 }
    waitForPageToFinishLoading
    #Click Add Preventive Service
    @common.clickAddButton
    waitForPageToFinishLoading
  end

  def getNotifyMeLabel()
    return getTextForElement(:css, ".margin-top-md legend span.ng-isolate-scope")
  end

  def getNotificationStatusLabel()
    return getTextForElement(:css, ".text-left")
  end

  def getNotificationStatus()
    radioButtons = getElements(:css, "input[name='notificationOption']")
    for i in 0...radioButtons.length do
      if(radioButtons[i].selected?)
        return radioButtons[i].attribute("value")
      end
    end
  end

  def getNote()
    getTextFromInput(:css, "textarea[name='Notes']")
  end

  def getSystolic()
    getTextFromInput(:css, "input[name='Systolic']")
  end

  def getDiastolic()
    getTextFromInput(:css, "input[name='Diastolic']")
  end

  def isNotificationStatusSelected(status)
    element = getElement(:css, "input[name='notificationOption'][type='radio'][value='" + status +"']")
    return element.selected?
  end

end