require 'rubygems'
require 'selenium-webdriver'

require_relative  "../module/DriverUtility"
require_relative  "../pages/nav_menu"

class Reminders
  include DriverUtility

  TITLE = ".main-title[aria-hidden]"

  def initialize(driver)
    @driver = driver
    @nav_menu = Nav_menu.new(@driver)
  end

  def getTitle()
    return getTextForElement(:css, TITLE)
  end

  def getPrimaryHeader()
    return getTextForElement(:css, "div.primary-header h2")
  end

  def getSecondaryHeader()
    return getTextForElement(:css, "div.secondary-header h2")
  end

  def getModalHeader()
    return getTextForElement(:css, "div.modal-header h3")
  end

  def selectStatus(status)
    click(:css, "input[name='statusOption'][type='radio'][value='" + status +"']")
  end

  def isTheFilterButtonVisible()
    return isElementPresentAndVisible(:css, "button[ng-click='filter()']")
    # return @driver.find_element(:css, "button[ng-click='filter()']").displayed?
  end

  def showOrHideFilter()
    click(:css, "i.pull-left")
    sleep 2
  end

  def clickAddEntryButton()
    sleep(5)
    click(:css, "button[ng-click='getDetails()']")
    sleep 2
  end

  def clickDeleteButton
    click(:css, 'button[ng-click="delete()"]')
    sleep 2
  end

  def clickNthReminder(number)
    click(:css, ".list-table li:nth-of-type(" + number.to_s + ")")
    sleep 2
  end

  def clickFilter
    click(:css, 'button[ng-click="filter()"]')
    sleep 2
  end

  def clickConfirmSaveButton()
    click(:css, 'button[ng-click="confirmSave()"]')
    sleep 2.5
  end

  def clickSaveButton()
    click(:css, 'button[ng-click="confirmSave()"]')
    sleep 2.5
  end

  def clickCancelButton()
    click(:css, 'button[ng-click="cancel()"]')
    sleep 0.5
  end

  def getMessageInPrimaryPane
    return getTextForElement(:css, "div[ui-view='primary'] div:nth-of-type(2) div span span:nth-of-type(2)")
  end

  def getRemindersCount()
    return getElements(:css, ".list-table li").length
  end

  def isStatusSelected(status)
    element = getElement(:css, "input[name='statusOption'][type='radio'][value='" + status +"']")
    return element.selected?
  end

  def isNotificationStatusSelected(status)
    element = getElement(:css, "input[name='notificationOption'][type='radio'][value='" + status +"']")
    return element.selected?
  end

  def getNoResultsFoundMessage()
    return getTextForElement(:css, '.no-results-message')
  end

  def isDeleteButtonVisible()
    return @driver.find_element(:css, "button[ng-click='delete()']").displayed?
  end

  def isSaveButtonVisible()
    return @driver.find_element(:css, "button[ng-click='confirmSave()']").displayed?
  end

  def isCancelButtonVisible()
    return @driver.find_element(:css, "button[ng-click='cancel()']").displayed?
  end

  def getNthReminderName(number)
    return getTextForElement(:css, ".list-table li:nth-of-type(" + number.to_s + ") span:nth-of-type(1) .cell-content")
    sleep 1
  end

  def getNthReminderFrequency(number)
    return getTextForElement(:css, ".list-table li:nth-of-type(" + number.to_s + ") span:nth-of-type(2) .cell-content")
  end

  def getNthReminderStatus(number)
    return getTextForElement(:css, ".list-table li:nth-of-type(" + number.to_s + ") span:nth-of-type(3) .cell-content")
  end

  def getTextForRowCol(row, col)
    return getTextForElement(:css,  "list-table div.table-scroll-container ul li:nth-of-type(" + row.to_s + ") > span:nth-of-type(" +  col.to_s + ") .cell-content")

  end

  def isRemindersListSortedByNameFrequencyStatus()
    remindersCount = getRemindersCount()
    #puts "reminderCount=" + remindersCount.to_s
    isSortedCorrectly = true


    for i in 1..remindersCount
      name = getNthReminderName(i)
      #puts "name=" + name
      frequency = getNthReminderFrequency(i)
      #puts "frequency=" + frequency
      status = getNthReminderStatus(i)
      #puts "status=" + status

      if frequency == "Daily" then
        frequencyCode = "1"
      elsif frequency == "Weekly" then
        frequencyCode = "2"
      elsif frequency == "Monthly" then
        frequencyCode = "3"
      else
        frequencyCode = " "
      end

      #puts "frequencyCode=" + frequencyCode

      if status == "On" then
        statusCode = "a"
      elsif status == "Off" then
        statusCode = "b"
      else
        statusCode = " "
      end

      #puts "statusCode=" + statusCode

      combinedName = name + frequencyCode + statusCode
      #puts "combinedName=" + combinedName
      if(i == 1) then
        previousItem = combinedName
      end

      nextItem = combinedName

      if previousItem.downcase > nextItem.downcase then #covert the strings to lower case, since it's case insensitive
        isSortedCorrectly = false
        return isSortedCorrectly
        break
      end
      previousItem = nextItem

    end


    return isSortedCorrectly
  end

  def verifyTheDayofWeekIsDisplayedCorrectly(dateStr)
    displayedDateCorrect = true
    displayedDay = getTextForElement(:css, "span[ng-if='showDay']")
    if (displayedDay != getDayofWeek(dateStr)) then
      displayedDateCorrect = false
    end

    return displayedDateCorrect
  end

  def selectFrequency(type)
    click(:css, "select[name='notificationFrequency'] option[value='" + type + "']")
    sleep 0.5
  end

  def clickAddTimeEntry()
    click(:css, "button[ng-click='addTimeEntry()']")
  end

  def getTotalTimeEntries()
    return getElements(:css, "multi-time .time-control").length
    sleep 1
  end

  def clickDeleteTimeEntryButton(i)
    click(:css, "button[name='deleteTime_#{i.to_s}']")
  end

  def typeInReminderName(name)
    @driver.find_element(:css, "input[name='title']").clear
    sleep 1
    @driver.find_element(:css, "input[name='title']").send_keys(name)
    sleep 1
  end

  def selectNotificationStatus(turnOnorOff)
    click(:css, "input[name='notificationOption'][type='radio'][value='" + turnOnorOff + "']")
    sleep 0.5
  end

  def findIndexWithGivenName(medName)
    reminderLength = getRemindersCount()
    for i in 1..reminderLength
      name = getNthReminderName(i)
      if medName == name then
        return i
        break
      end
    end
    return -1
  end

  def addReminder(name, startDate, frequency, startTimeArry, turnOnOrOff)
    clickAddEntryButton()
    !45.times{ break if (getPrimaryHeader().include?("Add")); sleep 1 }
    typeInReminderName(name)
    
    selectNotificationStatus("On")
    sleep 2

    setDate(startDate, "input[name='notificationStartDate']")
    sleep 0.5
    selectFrequency(frequency)
    sleep 0.5
    if (frequency == "Weekly") or (frequency == "Monthly") then
      setTime(startTimeArry[0], "input[name='time_0']")
      sleep 0.5
    elsif frequency == "Daily" then
      #Set time entries
      for i in 0..4
        timeEntryCount = getTotalTimeEntries()
        setTime(startTimeArry[i], "input[name='time_#{i.to_s}']")
        sleep 0.5
        if i != 4 then
          clickAddTimeEntry()
          !45.times{ break if (getTotalTimeEntries() > timeEntryCount); sleep 1 }
        end

      end
    end
    selectNotificationStatus(turnOnOrOff)
    sleep 0.5
    clickSaveButton()
  end

  def isThisFieldReadOnly(cssPath)
    return isThisElementDisabled(:css, cssPath)
  end

  def isThisReminderGroupAvailableAndDisplayedInRightOrder(position, name)
    #"ul.secondary-list li:nth-of-type(1) button span span"
    isAvailable = true

    groupLength = getElements(:css, 'ul.secondary-list li').length
    #puts "groupLength=" + groupLength.to_s

    for i in position..groupLength
      displayedText = getTextForElement(:css, "ul.secondary-list li:nth-of-type(" + i.to_s + ") button span span")
      #puts "displayedText=" + displayedText
      if displayedText == name and position == i then
        isAvailable = true
        break
      else
        isAvailable = false
        break
      end
    end

    return isAvailable
  end

  def clickSubGroup(name)
    click(:css, "button." + name)
  end

  def getDefaultMsg()
    return getTextForElement(:css, "div.page.row span")
  end

  def getrequiredFieldIndicator()
    return getTextForElement(:css, "span[ng-if*='requiredExists()']")
  end

  def getDateGuidanceText()
    return getElementAttribute("#date", "placeholder")
  end

  def getTimeGuidanceText()
    return getElementAttribute("#time", "placeholder")
  end

  def getPhoneGuidanceText()
    return getPlaceHolderByCSS(:css, "input[name='phone']")
  end

  def getProviderLabelText()
    return getTextForElement(:css, "span.margin-top-md")
  end

  def getClinicLabelText()
    return getLongFieldLabel("clinic")
  end

  def setClinicName(text)
    @driver.find_element(:css, "input[name='clinic']").clear
    @driver.find_element(:css, "input[name='clinic']").send_keys(text)
  end

  def getFacilityLabelText()
    return getLongFieldLabel("location")
  end

  def getReasonLabelText()
    return getLongFieldLabel("reason")
  end

  def getPhoneLabelText()
    return getTextForElement(:css, "[name='phone'] .input-label-content span:nth-of-type(1)")
  end

  def getNoteLabelText()
    return getLongFieldLabel("Note")
  end

  def getNotificationLabelText()
    return getTextForElement(:css, ".status-filter-wrapper legend")
  end


  def verifyMaxCharactersForField(fieldname, maxLength)
    testString = Array.new(maxLength){[*'0'..'9', *'a'..'z', *'A'..'Z'].sample}.join

    editField(fieldname, testString + "a")
    fieldText = getValueInField(fieldname)
    return fieldText == testString

  end

  def isDateRequired()
    return isFieldRequired(:css, "input[name='date']")
  end

  def isTimeRequired()
    return isFieldRequired(:css, "input[name='time']")
  end

  def isClinicRequired()
    return isFieldRequired(:css, "input[name='clinic']")
  end

  def isOnRadioVisible()
    return isElementVisible(:css, "input[name*='notificationOption'][type='radio'][value='On']")
  end

  def isOffRadioVisible()
    return isElementVisible(:css, "input[name*='notificationOption'][type='radio'][value='Off']")
  end

  def returnToAddAppointmentReminder()
    @main.clickNavMenu
    @navMenu.clickReminders
    @screening.clickAppointments
    @appointments.clickAddEntryButton
  end

  def getMedicationNameLabel()
    return getTextForElement(:css, "span[name='titleLabel']")
  end

end