require 'rubygems'
require 'selenium-webdriver'

require_relative  "../module/DriverUtility"

class Print_Assessment
  include DriverUtility

  RETAKE_ASSESSMENT_IN_LABEL = "span[name='notificationFrequencyLabel']"
  RETAKE_ASSESSMENT_IN_SELECT = "select[name='notificationFrequency']"

  def initialize(driver)
    @driver = driver
    #@base_url = baseUrl
    #sleep 1.5
  end

  def getPrintAssessmentTitle()
    return getTextForElement(:css, "div.assessment-preview div:nth-of-type(2) h4")
  end

  def getAssessmentSubmitConfirmationMessage()
    return getTextForElement(:css, "div.assessment-preview div:nth-of-type(2) span.at")
  end

  def getSetUpNotificationInstructionMsg()
    puts getTextForElement(:css, "div.primary-content div div.page span.at + p")
    return getTextForElement(:css, "div.primary-content div div.page span.at + p")
  end

  def getSubmitterName(assessmentType)
    if assessmentType == 'Health Status Self-Assessment'
      return getTextForElement(:css, "div.assessment-preview div:nth-of-type(2) > p:nth-of-type(2)")
    else
      return getTextForElement(:css, "div.assessment-preview div:nth-of-type(2) > p:nth-of-type(1)")
    end

  end

  def getSubmittedDateTimeFromGUI(assessmentType)
    tempText = nil

    if assessmentType == 'Health Status Self-Assessment'
      tempText = getTextForElement(:css, "div.assessment-preview div:nth-of-type(2) > p:nth-of-type(3)")
    else
      tempText = getTextForElement(:css, "div.assessment-preview div:nth-of-type(2) > p:nth-of-type(2)")
    end

    tempArry = tempText.split(": ")
    puts tempArry[1]
    return tempArry[1]
  end

  def getDisplayedQuestion(number)
    return getTextForElement(:css, "div.assessment-preview div:nth-of-type(2) ol li:nth-of-type(" + number.to_s + ") span b")
  end

  def getDisplayedAnswer(number)
    return getTextForElement(:css, "div.assessment-preview div:nth-of-type(2) ol li:nth-of-type(" + number.to_s + ") ul li")
  end

  def isSetUpNotificationButtonVisible()
    begin
      element = @driver.find_element(:id, "setup-assessment-notification")
      return element.displayed?
    rescue Exception=>e
      return false
    end
  end

  def clickSetUpNotificationButton()
    click(:id, "setup-assessment-notification")
  end

  def clickSaveButtonFromSetUpNotification()
    click(:css, "button[ng-click='save()']")
    sleep 0.5
  end

  def clickCancelButtonFromSetUpNotification()
    click(:css, "button[ng-click='cancel()']")
    sleep 0.5
  end


end