require 'rubygems'
require 'selenium-webdriver'

require_relative "../../module/DriverUtility"
require_relative "../../helpers/entry_form"

class Sleep < EntryForm
  include DriverUtility

  STARTDATE = "input[name='startDate']"
  STARTTIME = "input[name='startTime']"
  ENDDATE = "input[name='endDate']"
  ENDTIME = "input[name='endTime']"
  NOTE = "textarea[name='Note']"
  TIMESLEPT = "fieldset legend"
  HOURS = ".time-slept .hours"
  MINUTES = ".time-slept .minutes"
  SLEEP_QUALITY = "input[name='sleepQuality']"

  def initialize(driver)
    super(driver)
  end

  def setStartTime(time)
    setInput(STARTTIME,time)
  end

  def setEndTime(time)
    setInput(ENDTIME,time)
  end
end