require 'rubygems'
require 'selenium-webdriver'

require_relative "../../helpers/entry_form"

class PersonalTracker_Settings < EntryForm


  def initialize(driver)
    super(driver);
  end

  def getHeading()
    return getTextForElement(:css, "div.modal-dialog div.modal-header h3")
  end

  def getScreenContent()
    #return getTextForElement(:css, "div.modal-body")
    return getTextForElement(:css, 'div.modal-content')
  end

  def clickTracker(trackerName)
    click(:css, "input[ng-model='details.#{trackerName}']")
  end

  def isTrackerSelected(trackerName)
    return getElement(:css, "input[ng-model='details.#{trackerName}']").selected?
  end

  def clickTheGearIcon()
    click(:css, "button[title='Personal Tracker Settings']")
  end


  def clickCancelButton()
   click(:css, "[ng-click='cancel()']")
  end

  def clickSaveButton()
   click(:css, "[ng-click='save()']")
  end


end