require 'rubygems'
require 'selenium-webdriver'

require_relative "../../helpers/entry_form"

class PersonalTracker_Notification < EntryForm

  OPTION = "input[name='notificationOption']"
  START_DATE = "input[name='notificationStartDate']"
  DATE_BUTTON = "div[name='date'] > div > div > span > button"
  FREQUENCY = "select[name='notificationFrequency']"
  TIME0 = "input[name='time_0']"
  TIME1 = "input[name='time_1']"
  TIME2 = "input[name='time_2']"
  TIME3 = "input[name='time_3']"
  TIME4 = "input[name='time_4']"
  TIME_BUTTON = "div[class='time-control'] > div > div > span > button"
  ADD_TIME_BUTTON = "button[ng-click='addTimeEntry()']"
  NOTIFICATION_DELIVERY = "input[name='notificationDelivery']"
  NOTIFICATION_DELIVERY_IN_APP_CHECKBOX = "input[value='In-App']"
  NOTIFICATION_DELIVERY_EMAIL_CHECKBOX =  "input[name='notificationDelivery'][ng-true-value='Email']"
  STATUS_RADIO_BUTTON_ON = "input[value='On']"
  STATUS_RADIO_BUTTON_OFF = "input[value='Off']"
  CONTINUE_WITHOUT_SAVING_BUTTON = "html/body/div[4]/div/div/div[3]/div/button[2]"

  def clickOnRadioButton()
    waitForPageToFinishLoading
    click(:css, "input[value='On']")
  end

  def clickOffRadioButton()
    click(:css, "input[value='Off']")
  end

  def initialize(driver)
    super(driver);
  end

  def getScreenContent()
    return getElement(:css, "form[name='form']").text()
  end

  def clickTheGearIcon()
    click(:css, "button[title='Notification Settings']")
  end

  def timeZoneOption(number)
    #!45.times{ break if (@driver.find_element(:css, "select[name='timeZone'] > option:nth-of-type(1)").displayed?); sleep 1 }
    return getTextForElement(:css, "select[name='timeZone'] > option:nth-of-type(" + number.to_s + ")")
  end


  def isFieldDisabled(field)
    element = getElement(:css, field)
    #puts "isFieldDisabled=[#{element.attribute('disabled')}]"
    if (element.attribute("disabled") ==  "disabled") or
       (element.attribute("disabled") ==  "true")
      return true
    else
      return false
    end
  end


  def clickNotificationButton()
    waitForPageToFinishLoading
   click(:css, "[ng-click='button.onClick()'][title*='Notification']")
  end

  def clickBackButton()
   click(:css, "[ng-click='goBack()']")
  end

  def getBackButtonAltText()
    return getElement(:css, "[ng-click='goBack()']").attribute("title")
  end

end