require 'rubygems'
require 'selenium-webdriver'

require_relative  "../../pages/date_filter"
require_relative "../../helpers/graph"

class Lipids_Filter < Date_Filter
  include Graph

  START_DATE = "input[name='startDate']"
  START_DATE_BUTTON = "div[name='startDate'] > div > div > span > button"
  END_DATE = "input[name='endDate']"
  END_DATE_BUTTON = "div[name='endDate'] > div > div > span > button"
  HEADER = "Stress"

  def initialize(driver)
    super(driver)
  end

  def isGraphButtonPresent()
    is_element_present(:css, "button[ng-click='button.onClick()']")
  end

  def getGraphButtonTitle()
    return getElement(:css, "[ng-click='button.onClick()']").attribute("title")
  end

end