require 'rubygems'
require 'selenium-webdriver'

require_relative "../../helpers/entry_form"

class Glucose_Notification < EntryForm

  OPTION = "input[name='notificationOption']"
  START_DATE = "input[name='notificationStartDate']"
  DATE_BUTTON = "div[name='date'] > div > div > span > button"
  FREQUENCY = "select[name='notificationFrequency']"
  TIME0 = "input[name='time_0']"
  TIME1 = "input[name='time_1']"
  TIME2 = "input[name='time_2']"
  TIME3 = "input[name='time_3']"
  TIME4 = "input[name='time_4']"
  TIME_BUTTON = "div[class='time-control'] > div > div > span > button"
  NOTIFICATION_DELIVERY = "input[name='notificationDelivery']"
  NOTIFICATION_DELIVERY_IN_APP_CHECKBOX = "input[name='notificationDelivery'][ng-true-value='In-App']"
  NOTIFICATION_DELIVERY_EMAIL_CHECKBOX =  "input[name='notificationDelivery'][ng-true-value='Email']"

  def clickOnRadioButton()
    click(:css, "input[value='On']")
  end

  def initialize(driver)
    super(driver);
  end

  def getScreenContent()
    return getElement(:css, "form[name='form']").text()
  end

  def clickTheGearIcon()
    click(:css, "button[title='Notification Settings']")
  end

  def timeZoneOption(number)
    #!45.times{ break if (@driver.find_element(:css, "select[name='timeZone'] > option:nth-of-type(1)").displayed?); sleep 1 }
    return getTextForElement(:css, "select[name='timeZone'] > option:nth-of-type(" + number.to_s + ")")
  end

end