require 'rubygems'
require 'selenium-webdriver'

require_relative  "../../pages/date_filter"
require_relative "../../helpers/graph"

class Glucose_Filter < Date_Filter
  include Graph

  TESTED = "select[name='tested']"
  FROM_DATE = "input[name='startDate']"
  FROM_DATE_BUTTON = "div[name='startDate'] > div > div > span > button"
  TO_DATE = "input[name='endDate']"
  TO_DATE_BUTTON = "div[name='endDate'] > div > div > span > button"

  def initialize(driver)
    super(driver)
  end

  def isGraphButtonPresent()
    is_element_present(:css, "button[ng-click='button.onClick()']")
  end

  def getGraphButtonTitle()
    return getElement(:css, "[ng-click='button.onClick()']").attribute("title")
  end

end