require 'rubygems'
require 'selenium-webdriver'

require_relative "../../helpers/entry_form"

class Glucose < EntryForm

  DATE = "input[name='date']"
  DATE_BUTTON = "div[name='date'] > div > div > span > button"
  TIME = "input[name='time']"
  TIME_BUTTON = "div[class='time-control'] > div > div > span > button"
  GLUCOSE_LEVEL = "input[name='Glucose Level']"
  TESTED = "select[name='Tested']"
  NOTE = "textarea[name='Note']"
  NOTE_CHARACTER_COUNTER = "span[ng-if='characterCounter']"
  HEADER = "Glucose (Self Tested)"
  ADD_HEADER = "Add Glucose (Self Tested) Entry"
  EDIT_HEADER = "Edit Glucose (Self Tested) Entry"
  NOTE_TEXTFIELD= "textarea[name='Note']"

  def initialize(driver)
    super(driver);
  end

  def getScreenContent()
    return getElement(:css, "form[name='form']").text()
  end

  def setGlucoseLevel(level)
    setInput(GLUCOSE_LEVEL,level)
  end

  def setSelectBoxTested(value)
    setSelectBoxValue(TESTED,value)
  end

  def setNote(textfield)
    setInput(NOTE_TEXTFIELD,textfield)
  end

end