require 'rubygems'
require 'selenium-webdriver'

require_relative  "../../helpers/entry_form"

class CholesterolLipid < EntryForm
  TOTAL_SERUM_CHOLESTEROL_TEXTFIELD = "input[name='Total Serum Cholesterol']"
  LOW_DENSITY_LIPOPROTEIN_TEXTFIELD = "input[name='Low-Density Lipoprotein (LDL)']"
  HIGH_DENSITY_LIPOPROTEIN_TEXTFIELD = "input[name='High-Density Lipoprotein (HDL)']"
  TOTAL_TRIGLYCERIDES_TEXTFIELD = "input[name='Triglycerides']"
  NOTE_TEXTFIELD= "textarea[name='Note']"


  def initialize(driver)
    super(driver)
  end

  def setTotalSerumCholesterol(total_serum_cholesterol)
    setInput(TOTAL_SERUM_CHOLESTEROL_TEXTFIELD,total_serum_cholesterol)
  end

  def setLowDensityLipoprotein(low_density_lipoprotein)
    setInput(LOW_DENSITY_LIPOPROTEIN_TEXTFIELD,low_density_lipoprotein)
  end

  def setHighDensityLipoprotein(high_density_lipoprotein)
    setInput(HIGH_DENSITY_LIPOPROTEIN_TEXTFIELD,high_density_lipoprotein)
  end

  def setTotalTriglycerides(total_triglycerides)
    setInput(TOTAL_TRIGLYCERIDES_TEXTFIELD,total_triglycerides)
  end

  def setNote(textfield)
    setInput(NOTE_TEXTFIELD,textfield)
  end

end