require 'rubygems'
require 'selenium-webdriver'

require_relative  "../../helpers/entry_form"

class BloodPressureAndPulse < EntryForm
  SYSTOLIC_TEXTFIELD = "input[name='Systolic']"
  DIASTOLIC_TEXTFIELD = "input[name='Diastolic']"
  PULSE_TEXTFIELD = "input[name='Pulse']"
  NOTE_TEXTFIELD = "textarea[name='Note']"



  def initialize(driver)
    super(driver)
  end

  def setSystolic(systolic)
    setInput(SYSTOLIC_TEXTFIELD,systolic)
  end

  def setDiastolic(systolic)
   setInput(DIASTOLIC_TEXTFIELD,systolic)
  end

  def setPulse(pulse)
    setInput(PULSE_TEXTFIELD,pulse)
  end

  def setNote(note)
    setInput(NOTE_TEXTFIELD,note)
  end
end