require 'rubygems'
require 'selenium-webdriver'

require_relative  "../module/DriverUtility"
require_relative  "../helpers/table"
require_relative "../helpers/graph"

class PersonalTrackers
  include DriverUtility
  include Table
  include Graph

  PDF_BTN = "button[title='PDF']"
  GRAPH_BTN = "button[title='Graph']"
  TABLE_BTN = "button[title='Table']"
  ADD_ENTRY_BTN = "button[ng-click='getDetails()']"
  NOTIFICATION_ICON = "i.icon-notification"
  BLOOD_PRESSURE_AND_PULSE_BTN = ".blood-pressure-and-pulse"
  CHOLESTEROL_LIPID_BTN = ".btn.btn-default.cholesterol-lipid"
  DAILY_EVENTS_BTN = ".btn.btn-default.daily-events"
  DIET_BTN = ".btn.btn-default.diet"
  EXERCISE_BTN = ".btn.btn-default.exercise"
  GLUCOSE_BTN = ".btn.btn-default.glucose-self-tested"
  HEIGHT_BTN = ".btn.btn-default.height"
  MOOD_BTN = ".btn.btn-default.mood"
  PAIN_BTN = ".btn.btn-default.pain"
  RESPIRATION_BTN = ".btn.btn-default.respiration"
  SLEEP_BTN = ".btn.btn-default.sleep"
  STRESS_BTN = ".btn.btn-default.stress"
  TEMPERATURE_BTN = ".btn.btn-default.temperature"
  WEIGHT_BTN = ".btn.btn-default.weight"

  def initialize(driver, metaData)
    @driver = driver
    if(metaData != nil)
      @columnList = metaData["orderedColumnsList"];
      @columnMap = Hash.new();

      columnListLength = @columnList.length

      for i in 0...columnListLength
        @columnMap[@columnList[i]] = i + 1
      end
    end
  end

  def clickBloodPressureAndPulse()
      click(:css, BLOOD_PRESSURE_AND_PULSE_BTN)
  end

  def clickCholesterolLipid()
    waitForPageToFinishLoading
    click(:css, CHOLESTEROL_LIPID_BTN)
  end

  def clickDailyEvents()
    waitForPageToFinishLoading
    click(:css, DAILY_EVENTS_BTN)
  end

  def clickDiet()
    waitForPageToFinishLoading
    click(:css, DIET_BTN)
  end

  def clickExercise()
    waitForPageToFinishLoading
    click(:css, EXERCISE_BTN)
  end

  def clickGlucose()
    waitForPageToFinishLoading
    click(:css, GLUCOSE_BTN)
  end

  def clickHeight()
    waitForPageToFinishLoading
    click(:css, HEIGHT_BTN)
  end

  def clickMood()
    waitForPageToFinishLoading
    click(:css, MOOD_BTN)
  end

  def clickPain()
    waitForPageToFinishLoading
    click(:css, PAIN_BTN)
  end

  def clickRespiration()
    waitForPageToFinishLoading
    click(:css, RESPIRATION_BTN)
  end

  def clickSleep()
    waitForPageToFinishLoading
    click(:css, SLEEP_BTN)
  end

  def clickStress()
    waitForPageToFinishLoading
    click(:css, STRESS_BTN)
  end

  def clickTemperature()
    waitForPageToFinishLoading
    click(:css, TEMPERATURE_BTN)
  end

  def clickWeight()
    waitForPageToFinishLoading
    click(:css, WEIGHT_BTN)
  end

  # def clickAddEntryButton()
  #   click(:css, ADD_ENTRY_BTN)
  #   waitForPageToFinishLoading
  # end

  def getRowValuesForSection(row)
    return getDataForRow(@columnList, row)
  end

  def getTextForGridCell(columnKey, row)
    return getTextForRowColumn(row, @columnMap[columnKey]);
  end

  def isPDFButtonDisplayed?()
    return isElementVisible(:css, PDF_BTN)
  end

  def isGraphButtonDisplayed?()
    return isElementVisible(:css, GRAPH_BTN)
  end

  def isTableButtonDisplayed?()
    return isElementVisible(:css, TABLE_BTN)
  end

  def clickPDFButton()
    click(:css, PDF_BTN)
  end

  def clickGraphButton()
    click(:css, GRAPH_BTN)
  end

  def clickTableButton()
    click(:css, TABLE_BTN)
  end

  def hasEmbeddedPDF?()
    urlLink = @driver.current_url
    return urlLink.include?("pdf")
  end


  def clickNotificationButton()
   click(:css, "[ng-click='button.onClick()'][title*='Notification']")
  end

  def getNotificationButtonLabel()
   return getTextForElement(:css, "[ng-click='button.onClick()'][title*='Notification']")
  end

  def getNotificationButtonAltText()
    return getElement(:css, "[ng-click='button.onClick()'][title*='Notification']").attribute("aria-label")
  end


end