require 'rubygems'
require 'selenium-webdriver'

class Option_Dropdown
  DROP_DOWN_BUTTON = "span.dropdown > button.dropdown-toggle"
  DROP_DOWN_MENU = "ul.dropdown-menu"
  PDF_BUTTON = "ul.dropdown-menu button[title='PDF']"
  GRAPH_BUTTON = "ul.dropdown-menu button[title='Graph']"
  TABLE_BUTTON = "ul.dropdown-menu button[title='Table']"

  include DriverUtility
  def initialize(driver)
    @driver = driver;
  end

  def clickBtn()
    #Click the options button
    click(:css, DROP_DOWN_BUTTON)
    #sleep 5
  end

  def getButtonScreenReaderText()
    return getElement(:css, DROP_DOWN_BUTTON).attribute('aria-label').strip
  end


  def isOptionMenuExpanded()
    element = getElement(:css, DROP_DOWN_MENU)
    classVal = element.attribute("aria-hidden")
    if classVal == "false"
      return true
    else
      return false
    end
  end

  def isOptionMenuExists()
    element = isElementVisible(:css, DROP_DOWN_BUTTON)
    if element == true
      return true
    else
      return false
    end
  end

  def graph_button_exists?()
    element = isElementVisible(:css, GRAPH_BUTTON)
    return element
  end

  def table_button_exists?()
    element = isElementVisible(:css, TABLE_BUTTON)
    return element
  end

  def notification_button_exists?()
    return isElementVisible(:css, "ul.dropdown-menu button[title*='Notification']")
  end


  def clickGraphBtn()
    #Click the options button
    click(:css, GRAPH_BUTTON)
    #sleep 5
  end
end