require 'rubygems'
require 'selenium-webdriver'

require_relative  "../module/DriverUtility"
require_relative "../helpers/entry_form"

class Notifications_Reminders < EntryForm
  include DriverUtility

  TITLE = ".main-title[aria-hidden]"
  NOTIFICATIONS_TITLE = "notificationsTitle"
  STARTDATE = "input[name='startDate']"
  START_DATE_TEXTFIELD = "input[name='notificationStartDate']"
  NOTIFICATION_TIME_TEXTFIELD = "input[name='time_0']"
  ENDDATE = "input[name='endDate']"
  SOURCE = "select[name='source']"
  DATERANGE = ".text-left.ng-binding.ng-scope"
  STATUSLABEL = "fieldset.status-filter-wrapper legend"
  RESET = "button[ng-click='reset()']"
  FILTER = "button[ng-click='filter()']"
  ALL_NOTIFICATION_BTN = ".btn.btn-default.all-notifications"
  MY_VA_HEALTH_APP_NOTICES_BTN = ".btn.btn-default.my-va-health-app-notices"
  VA_HEALTH_MESSAGES_BTN = ".btn.btn-default.va-health-messages"
  NOTIFY_ME = "select[name='notificationFrequency']"
  SOURCE_DROPDOWN = "select[name='source']"
  ON_THE_DATE_CHECKBOX = "input[aria-label='On the date']"
  ONE_DAY__BEFORE_CHECKBOX = "input[aria-label='1 day before']"
  TWO_WEEKS__BEFORE_CHECKBOX = "input[aria-label='2 weeks before']"
  FOUR_WEEKS__BEFORE_CHECKBOX = "input[aria-label='4 weeks before']"
  IN_APP_CHECKBOX = "input[aria-label='In-App']"
  EMAIL_CHECKBOX = "input[aria-label='Email']"
  EMAIL_TEXTFIELD = "input[name='email']"

  def initialize(driver)
    super(driver)
  end


  def getTitle()
    return getTextForElement(:css, TITLE)
  end

  def getPrimaryHeader()
    return getTextForElement(:css, "div.primary-header h2")
  end

  def getSecondaryHeader()
    return getTextForElement(:css, "div.secondary-header h2")
  end

  def selectStatus(status)
    click(:css, "input[name='statusOption'][type='radio'][value='" + status +"']")
  end

  def selectReceiveNotifications(yesNo)
    click(:css, "input[name='optInOption'][type='radio'][value='" + yesNo +"']")
  end

  def clickOptInButton
    click(:css, "button.opt-in")
  end

  def clickOptOutButton
    click(:css, "div.secondary-header :last-child")
  end

  def clickDeleteButton
    click(:css, 'button[ng-click="delete()"]')
  end

  def clickNthNotification(number)
    click(:css, "ul.secondary-list li:nth-of-type(" + number.to_s + ") button")
  end

  def clickFilter
    click(:css, 'button[ng-click="filter()"]')
  end

  def clickNotificationSaveButton()
    waitForPageToFinishLoading
    click(:css, "button[ng-click='confirmSave()']")
  end

  def clickNotificationSaveButtonJump()
    waitForPageToFinishLoading
    @driver.execute_script("$(\"button[ng-click='confirmSave()']\")[0].scrollIntoView(true)")
    click(:css, "button[ng-click='confirmSave()']")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    waitForPageToFinishLoading
  end

  def clickSaveButton()
    waitForPageToFinishLoading
    click(:css, 'button[ng-click="save()"]')
  end

  def clickCancelButtonJump()
    waitForPageToFinishLoading
    @driver.execute_script("$(\"button[ng-click='cancel()']\")[0].scrollIntoView(true)")
    click(:css, "button[ng-click='cancel()']")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    waitForPageToFinishLoading
  end

  def clickCancelButton()
    waitForPageToFinishLoading
    @driver.execute_script("$(\"button[ng-click='cancel()']\")[0].scrollIntoView(true)")
    click(:css, 'button[ng-click="cancel()"]')
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    waitForPageToFinishLoading
  end

  def setDateRange (fromDate, toDate)
    getElement(:id, "startDate").clear
    getElement(:id, "startDate").send_keys(fromDate)

    getElement(:id, "endDate").clear
    getElement(:id, "endDate").send_keys(toDate)
  end

  def setNotificationStartDate(date)
    waitForPageToFinishLoading
    @driver.find_element(:css, START_DATE_TEXTFIELD).clear
    @driver.find_element(:css, START_DATE_TEXTFIELD).send_keys(date)
  end

  def setNotificationTime(time)
    waitForPageToFinishLoading
    @driver.find_element(:css, NOTIFICATION_TIME_TEXTFIELD).send_keys(time)
  end

  def getMessageInPrimaryPane
    return getTextForElement(:css, "div[ui-view='primary'] div span")
  end

  def getNotificationCount
    return getElements(:css, "ul.secondary-list li").length
  end

  def getOptedOutMessageInLeftPane()
    return getTextForElement(:css, "div.no-print.col-md-4.column.secondary-content.ng-scope div:nth-of-type(2)")
  end

  def getOptedOutMessage()
    return getTextForElement(:css, "div p:first-child")
  end

  def isSettingPopupDisappeared()
    return isElementDisappeared(:css, "div.modal-header")
  end

  def isOptInOutButtonPresent()
    return is_element_present(:css, "div.secondary-header button")
  end

  def isFilterVisible()
    !45.times{ break if (@driver.find_element(:css, 'button[ng-click="filter()"]').displayed?); sleep 1 }
    return getTextForElement(:css, 'button[ng-click="filter()"]')
  end

  def isLeftPaneScrollable
    elements = getElements(:css, "ul.secondary-list li")
    initialLocation = elements.last.location
    puts "[isLeftPaneScrollable] initialLocation: " + initialLocation.to_s
    newLocation = elements.last.location_once_scrolled_into_view
    puts "[isLeftPaneScrollable ] newLocationAfterScrolledIntoView " + newLocation.to_s

    if(initialLocation.y > newLocation.y)
      return true
    else
      return false
    end

  end

  def isDatesWithinFilteredDateRange?()
    fromDate = getTextFromInput(:id, "startDate")
    toDate = getTextFromInput(:id, "endDate")
    puts "[isDatesWithinFilteredDateRange?()] Filter Date Range " + fromDate + " - " + toDate

    notificationCount = getNotificationCount
    isValid = true

    fromDateObj = DateTime.strptime(fromDate, "%m/%d/%Y")
    toDateObj = DateTime.strptime(toDate, "%m/%d/%Y")

    for i in 1..notificationCount
      notificationDate = getNthNotificationDateAndTime(i)
      dateObj = DateTime.strptime(notificationDate, format="%m/%d/%Y %I:%M %p")
      puts "notificationDate Date " + notificationDate
      if dateObj <= fromDateObj and dateObj >= toDateObj then
        isValid = false
        break
      end
    end

    return isValid

  end

  def isStatusSelected(status)
    element = getElement(:css, "input[name='statusOption'][type='radio'][value='" + status +"']")
    puts "[isStatusSelected] Status " + status + " - " + element.selected?.to_s
    return element.selected?
  end

  def getDateAndTimeInDetail()
    return getTextForElement(:css, "p.notification-date")
  end

  def getSourceInDetail()
    return getTextForElement(:css, "p.notification-source")
  end

  def getTextInDetail()
    return getTextForElement(:css, "p.notification-body")
  end

  def getTimezoneInDetail()
    return getTextForElement(:css, "p.notification-timezone")
  end

  def selectTimezoneFromNotificationSettingScreen(value)
    setSelectBoxValue("select[name='timeZone'", value)
  end

  def getNoResultsFoundMessage()
    return getTextForElement(:css, 'div.text-center.no-results-message.ng-scope')
  end

  def getVAHealthMessages()
    return getTextForElement(:css, 'span.no-results-message:last-child')
  end

  def getNthNotificationDateAndTime(number)
    return getTextForElement(:css, "ul.secondary-list li:nth-of-type(" + number.to_s + ") button div div div:nth-of-type(3)")
  end

  def getNthSource(number)
    return getTextForElement(:css, "ul.secondary-list li:nth-of-type(" + number.to_s + ") button div div div:nth-of-type(3)")
  end

  def isDeleteButtonVisible()
    return @driver.find_element(:css, "button[ng-click='delete()']").displayed?
  end

  def isNthUnreadFlagVisible(number)
   # return is_element_present(:css, "ul.secondary-list li:nth-of-type(" + number.to_s + ") button div i")
    isUnread = true
    puts "[isNthUnreadFlagVisible]"

    begin
      element = @driver.find_element(:css, "ul.secondary-list li:nth-of-type(" + number.to_s + ") button div i")
    rescue Exception=>e
      return false
    end

    return true
  end

  def getNthNotificationText(number)
    return getTextForElement(:css, "ul.secondary-list li:nth-of-type(" + number.to_s + ") button div div div:nth-of-type(1)")
  end

  def getNthTimeZone(number)
    return getTextForElement(:css, "ul.secondary-list li:nth-of-type(" + number.to_s + ") button div div div:nth-of-type(4)")
  end

  def timeZoneOption(number)
    #!45.times{ break if (@driver.find_element(:css, "select[name='timeZone'] > option:nth-of-type(1)").displayed?); sleep 1 }
    return getTextForElement(:css, "select[name='timeZone'] > option:nth-of-type(" + number.to_s + ")")
  end

  def isSortedReverseChronologicalOrder
    notificationCount = getElements(:css, 'ul.secondary-list li').length
    isSortedInReverse = true;

    previousDate = DateTime.strptime(getNthNotificationDateAndTime(1), format="%m/%d/%Y %I:%M %p")

    for i in 1..notificationCount
      notificationDate = DateTime.strptime(getNthNotificationDateAndTime(i), format="%m/%d/%Y %I:%M %p")

      if(previousDate < notificationDate)
        isSortedInReverse = false
        break
        puts "Current Notification date is greater than previous Notification date"
      end

      previousDate = notificationDate
    end

    return isSortedInReverse
  end

  def clickTheGearIcon()
    waitForPageToFinishLoading
    click(:css, "button[title='Notification Settings']")
  end

  def clickAllNotifications()
    waitForPageToFinishLoading
    click(:css, ALL_NOTIFICATION_BTN)
  end

  def clickOnRadioButton()
    waitForPageToFinishLoading
    click(:css, "input[value='On']")
  end

  def clickOnTheDateCheckbox()
    waitForPageToFinishLoading
    click(:css, ON_THE_DATE_CHECKBOX)
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
  end

  def clickOneDayBeforeCheckbox()
    waitForPageToFinishLoading
    click(:css, ONE_DAY__BEFORE_CHECKBOX)
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
  end

  def clickTwoWeeksBeforeCheckBox()
    waitForPageToFinishLoading
    click(:css, TWO_WEEKS__BEFORE_CHECKBOX)
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
  end

  def clickFourWeeksBeforeCheckbox()
    waitForPageToFinishLoading
    click(:css, FOUR_WEEKS__BEFORE_CHECKBOX)
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
  end

  def clickInAppCheckbox()
    waitForPageToFinishLoading
    click(:css, IN_APP_CHECKBOX)
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
  end

  def clickEmailCheckbox()
    waitForPageToFinishLoading
    click(:css, EMAIL_CHECKBOX)
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
  end

  def clickOffRadioButton()
    waitForPageToFinishLoading
    click(:css, "input[value='Off']")
  end

  def clickMyVaHealthAppNotices()
    waitForPageToFinishLoading
    click(:css, MY_VA_HEALTH_APP_NOTICES_BTN)
  end

  def clickVaHealthMessages()
    waitForPageToFinishLoading
    click(:css, VA_HEALTH_MESSAGES_BTN)
  end

  def setEmailAddressFromNotificationSettingScreen(email)
    waitForPageToFinishLoading
    getElement(:css, "input[name='email']").clear
    getElement(:css, "input[name='email']").send_keys(email)
  end

  def getEmailAddressFromNotificationSettingScreen()
    element = getElement(:css, "input[name='email']")
    puts "value=" + element.attribute("value")
    if element.attribute("value") == nil then
      return "no email is found"
    else
      return element.attribute("value")
    end

  end

  def getAltText(css)
    element = getElement(:css, css)
    altText = element.attribute("title")
    return altText
  end

  def source()
    #!45.times{ break if (@driver.find_element(:css, "select[name='timeZone'] > option:nth-of-type(1)").displayed?); sleep 1 }
    return getTextForElement(:css, "select[name='source'] > option")
  end

  def selectSource(number)
    #!45.times{ break if (@driver.find_element(:css, "select[name='timeZone'] > option:nth-of-type(1)").displayed?); sleep 1 }
    return getTextForElement(:css, "select[name='source'] > option:nth-of-type(" + number.to_s + ")")
  end

  def selectNotifyMe(value)
    waitForPageToFinishLoading
    setSelectBoxValue(NOTIFY_ME, value)
  end

  def selectSourceByName(name)
    waitForPageToFinishLoading
    setSelectBoxValue(SOURCE_DROPDOWN, name)
  end

  def getNthParagraphTextFromNotificationSettingScreen(paragraphNumber)
    waitForPageToFinishLoading
    return getTextForElement(:css, "p[ng-bind-html='modalContent.bodyText'] p:nth-of-type(" + paragraphNumber.to_s + ")")
  end

  def setEmailTextfield(email)
    waitForPageToFinishLoading
    @driver.find_element(:css, EMAIL_TEXTFIELD).clear
    @driver.find_element(:css, EMAIL_TEXTFIELD).send_keys(email)
  end

end