require 'rubygems'
require 'selenium-webdriver'

require_relative  "../module/DriverUtility"
require_relative  "main"


class Nav_menu
    include DriverUtility
    MILITARY_OCCUPATIONAL_HISTORY_BTN = ".btn.btn-default.military-occupational-history"
    NAV_ORDER = ["Home","MyProfile", "MyStory", "MyMedical", "PersonalTrackers", "MyReminders", "Notifications", "Contacts", "Assessments", "Images and Documents", "Health Report"]

    NAV = {
        "NavMenu" => {
            "reference" => "use main.rb"
        },
        "PersonalTrackers" => {
            "dependsOn" => "NavMenu",
            "navButton" => "#PersonalTrackers"
        },
        "BloodPressureandPulse" => {
            "dependsOn" => "PersonalTrackers",
            "navButton" => "button.blood-pressure-and-pulse"
        },
        "DailyEvents" => {
            "dependsOn" => "PersonalTrackers",
            "navButton" => "button.daily-events"
        },
        "Diet" => {
            "dependsOn" => "PersonalTrackers",
            "navButton" => "button.diet"
        },
        "Exercise" => {
            "dependsOn" => "PersonalTrackers",
            "navButton" => "button.exercise"
        },
        "Glucose" => {
            "dependsOn" => "PersonalTrackers",
            "navButton" => "button.glucose-self-tested"
        },
        "Lipids" => {
            "dependsOn" => "PersonalTrackers",
            "navButton" => "button.cholesterol-lipid"
        },
        "Height" => {
            "dependsOn" => "PersonalTrackers",
            "navButton" => "button.height"
        },
        "Mood" => {
            "dependsOn" => "PersonalTrackers",
            "navButton" => "button.mood"
        },
        "Pain" => {
            "dependsOn" => "PersonalTrackers",
            "navButton" => "button.pain"
        },
        "Respiration" => {
            "dependsOn" => "PersonalTrackers",
            "navButton" => "button.respiration"
        },
        "Sleep" => {
            "dependsOn" => "PersonalTrackers",
            "navButton" => "button.sleep"
        },
        "Stress" => {
            "dependsOn" => "PersonalTrackers",
            "navButton" => "button.stress"
        },
        "Temperature" => {
            "dependsOn" => "PersonalTrackers",
            "navButton" => "button.temperature"
        },
        "Weight" => {
            "dependsOn" => "PersonalTrackers",
            "navButton" => "button.weight"
        },
        #MyMedical dependencies
        "MyMedical" => {
            "dependsOn" => "NavMenu",
            "navButton" => "#MyMedical"
        },
        "Diagnoses" => {
            "dependsOn" => "MyMedical",
            "navButton" => "button.diagnoses"
        },
        "Surgeries" => {
            "dependsOn" => "MyMedical",
            "navButton" => "button.surgeries"
        },
        "MMedications" => {
            "dependsOn" => "MyMedical",
            "navButton" => "button.medications"
        },
        "Allergies" => {
            "dependsOn" => "MyMedical",
            "navButton" => "button.allergies"
        },
        "Hospitalizations" => {
            "dependsOn" => "MyMedical",
            "navButton" => "button.hospitalizations"
        },
        "PregnancyHistory" => {
            "dependsOn" => "MyMedical",
            "navButton" => "button.pregnancy-history"
        },
        "FamilyHistory" => {
            "dependsOn" => "MyMedical",
            "navButton" => "button.family-history"
        },
        "SymptomDiary" => {
            "dependsOn" => "MyMedical",
            "navButton" => "button.symptom-diary"
        },
        "PlanYourAppointment" => {
            "dependsOn" => "MyMedical",
            "navButton" => "button.plan-your-appointment"
        },
        #Contacts dependencies- JRNL-2492
        "Contacts" => {
            "dependsOn" => "NavMenu",
            "navButton" => "#Contacts"
        },
        "ProviderContacts" => {
            "dependsOn" => "Contacts",
            "navButton" => "button.provider-contacts"
        },
        "FacilityContacts" => {
            "dependsOn" => "Contacts",
            "navButton" => "button.facility-contacts"
        },
        "HealthCareContacts" => {
            "dependsOn" => "Contacts",
            "navButton" => "button.healthcare-contacts"
        },
        "InsuranceContacts" => {
            "dependsOn" => "Contacts",
            "navButton" => "button.insurance-contacts"
        },
        "PersonalContacts" => {
            "dependsOn" => "Contacts",
            "navButton" => "button.personal-contacts"
        },
        "CommunicationsLog" => {
            "dependsOn" => "Contacts",
            "navButton" => "button.communications-log"
        },
        #MyStory dependencies
        "MyStory" => {
            "dependsOn" => "NavMenu",
            "navButton" => "#MyStory"
        },
        "Summary" => {
            "dependsOn" => "MyStory",
            "navButton" => "button.summary"
        },
        "PersonalValues" => {
            "dependsOn" => "MyStory",
            "navButton" => "button.personal-values"
        },
        "Assessment" => {
            "dependsOn" => "MyStory",
            "navButton" => "button.assessment"
        },
        "Reflections" => {
            "dependsOn" => "MyStory",
            "navButton" => "button.reflections"
        },
        "Learn" => {
            "dependsOn" => "MyStory",
            "navButton" => "button.learn"
        },
        "Goals" => {
            "dependsOn" => "MyStory",
            "navButton" => "button.goals"
        },
        #MyReminders dependencies
        "MyReminders" => {
            "dependsOn" => "NavMenu",
            "navButton" => "#MyReminders"
        },
        "Appointments" => {
            "dependsOn" => "MyReminders",
            "navButton" => "button.appointments"
        },
        "Medications" => {
            "dependsOn" => "MyReminders",
            "navButton" => "button.medications"
        },
        "PreventiveServices" => {
            "dependsOn" => "MyReminders",
            "navButton" => "button.preventive-services"
        },
        "Other" => {
            "dependsOn" => "MyReminders",
            "navButton" => "button.other"
        },
        "Notifications" => {
            "dependsOn" => "NavMenu",
            "navButton" => "#Notifications"
        },
        "AllNotifications" => {
            "dependsOn" => "Notifications",
            "navButton" => "button.all-notifications"
        },
        "MyVAHealthApp" => {
            "dependsOn" => "Notifications",
            "navButton" => "button.my-va-health-app-notices"
        },
        "VAHealthMessages" => {
            "dependsOn" => "Notifications",
            "navButton" => "button.va-health-messages"
        },
        "Assessments" => {
            "dependsOn" => "NavMenu",
            "navButton" => "#Assessments"
        },
        "Home" => {
            "dependsOn" => "NavMenu",
            "navButton" => "#Home"
        },
        #MyProfile dependencies
        "MyProfile" => {
            "dependsOn" => "NavMenu",
            "navButton" => "#MyProfile"
        },
        "MyContactInformation" => {
            "dependsOn" => "MyProfile",
            "navButton" => "button.my-contact-information"
        },
        "OccupationalHistory" => {
            "dependsOn" => "MyProfile",
            "navButton" => "button.military-occupational-history"
        },
        "ImagesDocuments" => {
            "dependsOn" => "NavMenu",
            "navButton" => "#ImagesandDocuments"
        },
        "All" => {
            "dependsOn" => "ImagesDocuments",
            "navButton" => "button.all"
        },
        "Medical" => {
            "dependsOn" => "ImagesDocuments",
            "navButton" => "button.medical"
        },
        "Military" => {
            "dependsOn" => "ImagesDocuments",
            "navButton" => "button.military"
        },
        "IMGOther" => {
            "dependsOn" => "ImagesDocuments",
            "navButton" => "button.other"
        },
        "HealthReport" => {
            "dependsOn" => "NavMenu",
            "navButton" => "#HealthReport"
        },

    }


    def initialize(driver)
        @driver = driver
        @main = Main.new(driver)
    end

    def getNavMenuHeading()
        navMenuHeading = getTextForElement(:css, "div[snap-drawer='left'] div h2:nth-of-type(2)")
        return navMenuHeading
    end

    def getMyStoryButtonText
        return getTextForElement(:css, NAV["MyStory"]["navButton"])
    end

    def getCommunicationLogButtonText
        return getTextForElement(:css, NAV["CommunicationsLog"]["navButton"] )
    end

    def getContactsButtonText
        return getTextForElement(:css, NAV["Contacts"]["navButton"] )
    end

    def getAssessmentButtonText
        return getTextForElement(:css, NAV["Assessments"]["navButton"] )
    end

    def getFamilyHistoryButtonText
        return getTextForElement(:css, NAV["FamilyHistory"]["navButton"] )
    end

    def getImagesDocumentsButtonText
        return getTextForElement(:css, NAV["ImagesDocuments"]["navButton"] )
    end

    def getNthOptionName(number)
        getTextForElement(:css, "ul.panel-menulist li:nth-child(" + number.to_s + ") button")
    end

    def isDailyEventsButtonVisible()
        return isNavVisible("DailyEvents")
    end

    def isCommunicationLogButtonVisible()
        return isNavVisible("CommunicationsLog")
    end

    def isAssessmentButtonVisible()
        return isNavVisible("Assessments")
    end

    def isMoodButtonVisible()
        return isNavVisible("Mood")
    end

    def isDietButtonVisible()
        return isNavVisible("Diet")
    end

    def isNotificationsButtonVisible()
        return isNavVisible("Notifications")
    end

    def isMyMedicalButtonVisible()
        getTextForElement(:css, "ul.panel-menulist li:nth-child(4) button ")
    end

    def isFamilyHistoryButtonVisible()
        return isNavVisible("FamilyHistory")
    end

    def isImagesDocumentButtonVisible()
        return isNavVisible("ImagesDocuments")
    end

    def isAllButtonVisible()
        return isNavVisible("All")
    end

    def isMedicalButtonVisible()
        return isNavVisible("Medical")
    end

    def isMilitaryButtonVisible()
        return isNavVisible("Military")
    end

    def isIMGOtherButtonVisible()
        return isNavVisible("IMGOther")
    end


    #JRNL-2492
    def isContactsButtonVisible()
        return isNavVisible("Contacts")
    end

    def isMyStoryButtonVisible()
        return isNavVisible("MyStory")
    end

    def isThisNavButtonVisible(number)
        return getTextForElement(:css, "ul.panel-menulist li:nth-child(" + number.to_s + ") button")
    end

    def clickMilitaryOccupationalHistory()
        waitForPageToFinishLoading
        click(:css, MILITARY_OCCUPATIONAL_HISTORY_BTN)
    end

    def clickAssessmentBtn
        navigate("Assessments")
    end

    def clickNotifications()
        waitForPageToFinishLoading
        navigate("Notifications")
    end

    def clickAllNotifications()
        navigate("AllNotifications")
    end

    def clickMyVAHealthApp()
        navigate("MyVAHealthApp")
    end

    def clickVAHealthMessages()
        navigate("VAHealthMessages")
    end

    def clickReminders()
        waitForPageToFinishLoading
        navigate("MyReminders")
    end

    def clickMyMedical()
        navigate("MyMedical")
    end

    #JRNL-2492
    def clickContacts()
        waitForPageToFinishLoading
        navigate("Contacts")
    end

    def clickHealthCareContacts()
        navigate("HealthCareContacts")
    end

    def clickInsuranceContacts()
        navigate("InsuranceContacts")
    end

    def clickPersonalContacts()
        navigate("PersonalContacts")
    end

    def clickCommunicationsLog()
        navigate("CommunicationsLog")
    end

    def clickMyStory()
        waitForPageToFinishLoading
        navigate("MyStory")
    end

    def clickHome()
        navigate("Home")
    end

    def clickSummary()
        navigate("Summary")
    end

    def clickHealthReport()
        waitForPageToFinishLoading
        navigate("HealthReport")
    end

    def clickPersonalValues()
        navigate("PersonalValues")
    end

    def clickAssessment()
        navigate("Assessment")
    end

    def clickReflections()
        navigate("Reflections")
    end

    def clickLearn()
        navigate("Learn")
    end

    def clickGoals()
        navigate("Goals")
    end

    def clickDiagnoses()
        navigate("Diagnoses")
    end

    def clickSurgeries()
        navigate("Surgeries")
    end

    def clickHospitalizations()
        navigate("Hospitalizations")
    end

    def clickPregnancyHistory()
        navigate("PregnancyHistory")
    end

    def clickFamilyHistory()
        navigate("FamilyHistory")
    end

    #Personal Trackers
    def clickPersonalTrackers()
        #navigate("PersonalTrackers")
        @driver.find_element(:id, "PersonalTrackers").click
    end

    def clickSleep()
        navigate("Sleep")
    end

    def clickBPAndPulse()
        navigate("BloodPressureandPulse")
    end

    def clickDailyEvents()
        waitForPageToFinishLoading
        navigate("DailyEvents")
    end

    def clickDiet()
        navigate("Diet")
    end

    def clickExercise()
        navigate("Exercise")
    end

    def clickGlucose()
        navigate("Glucose")
    end

    def clickHeight()
        navigate("Height")
    end

    def clickMood()
        navigate("Mood")
    end

    def clickPain()
        navigate("Pain")
    end

    def clickRespiration()
        navigate("Respiration")
    end

    def clickTemperature()
        navigate("Temperature")
    end

    def clickWeight()
        navigate("Weight")
    end

    def clickAppointments()
        navigate("Appointments")
    end

    def clickMedications()
        navigate("Medications")
    end

    def clickPreventiveServices()
        navigate("PreventiveServices")
    end

    def clickOther()
        waitForPageToFinishLoading
        navigate("Other")
    end

    def clickMyProfile()
        navigate("MyProfile")
    end

    def clickImagesDocuments()
        navigate("ImagesDocuments")
    end

    def clickAll()
        waitForPageToFinishLoading
        navigate("All")
    end

    def clickMedical()
        waitForPageToFinishLoading
        navigate("Medical")
    end

    def clickMilitary()
        waitForPageToFinishLoading
        navigate("Military")
    end

    def clickIMGOther()
        waitForPageToFinishLoading
        navigate("IMGOther")
    end

    #SHEERI DID IT!!!

    def getParentNav(nav)
        return NAV[nav]["dependsOn"]
    end

    def getAllSectionNav(feature)
        sections = Array.new()

        NAV.each { | key, value |
            if(value["dependsOn"] == feature)
                sections.push(key)
            end
        }

        return sections
    end

    def getAllFeatureNav()
        features = Array.new()

        NAV.each { | key, value |
            if(value["dependsOn"] == "NavMenu")
                features.push(key)
            end
        }

        return features
    end

    def getTextForButton(nav)
        return getTextForElement(:css, NAV[nav]["navButton"] )
    end

    #Use this function if it the buttons are on either under App Options or under all other sub-groups
    def isNavVisible(nav)
        begin
            element = @driver.find_element(:css, NAV[nav]["navButton"])
            return element.displayed?
        rescue Exception=>e
            return false
        end
    end

    def navigate(nav)

        clickChain = [];
        clickChain.push(nav)

        while NAV[clickChain[0]]["dependsOn"] != nil

            if(isNavVisible(clickChain[0]))
                break;
            end
            clickChain.unshift(NAV[clickChain[0]]["dependsOn"])
        end

        if(clickChain[0] == "NavMenu")
            puts "Opening Nav Button"
            if(getNavMenuHeading() != "App Options")
                puts "Clicking Nav Button"
                @main.clickNavMenu()
                waitForPageToFinishLoading
            end
            #!45.times{ break if (getNavMenuHeading() == "App Options"); sleep 0.2 }
            clickChain.delete("NavMenu")
        end

        #for i in 0..clickChain.length - 1
            #!45.times { break if (isNavVisible(clickChain[i])); sleep 0.2 }
            #waitForPageToFinishLoading
            # click(:css, NAV[clickChain[i]]["navButton"]);
            # #@driver.find_element(:xpath, "//button[@alt-text='Navigation Menu']").click
            # waitForPageToFinishLoading
        #end

    end

    def getNthSubFeatureName(number)
        return getTextForElement(:css, "div.secondary-content div:nth-of-type(2) ul li:nth-of-type(" + number.to_s + ") ")
    end

    def getSubFeatureCount()
        return getElements(:css, "div.secondary-content div:nth-of-type(2) ul li").length
    end

    def getNoMenuItemsMessage()
        return getTextForElement(:css, "div.no-results-message")
    end

end















































############################################################################ ORIGINAL CODE ################################################################
###########################################################################################################################################################
=begin


require 'rubygems'
require 'selenium-webdriver'

require_relative  "../module/DriverUtility"
require_relative  "main"


class Nav_menu
  include DriverUtility
  MILITARY_OCCUPATIONAL_HISTORY_BTN = ".btn.btn-default.military-occupational-history"
  NAV_ORDER = ["Home","MyProfile", "MyStory", "MyMedical", "PersonalTrackers", "MyReminders", "Notifications", "Contacts", "Assessments", "Images and Documents", "Health Report"]

  NAV = {
    "NavMenu" => {
      "reference" => "use main.rb"
    },
    "PersonalTrackers" => {
      "dependsOn" => "NavMenu",
      "navButton" => "#PersonalTrackers"
    },
    "BloodPressureandPulse" => {
      "dependsOn" => "PersonalTrackers",
      "navButton" => "button.blood-pressure-and-pulse"
    },
    "DailyEvents" => {
      "dependsOn" => "PersonalTrackers",
      "navButton" => "button.daily-events"
    },
    "Diet" => {
      "dependsOn" => "PersonalTrackers",
      "navButton" => "button.diet"
    },
    "Exercise" => {
      "dependsOn" => "PersonalTrackers",
      "navButton" => "button.exercise"
    },
    "Glucose" => {
        "dependsOn" => "PersonalTrackers",
        "navButton" => "button.glucose-self-tested"
    },
    "Lipids" => {
        "dependsOn" => "PersonalTrackers",
        "navButton" => "button.cholesterol-lipid"
    },
    "Height" => {
      "dependsOn" => "PersonalTrackers",
      "navButton" => "button.height"
    },
    "Mood" => {
      "dependsOn" => "PersonalTrackers",
      "navButton" => "button.mood"
    },
    "Pain" => {
      "dependsOn" => "PersonalTrackers",
      "navButton" => "button.pain"
    },
    "Respiration" => {
      "dependsOn" => "PersonalTrackers",
      "navButton" => "button.respiration"
    },
    "Sleep" => {
      "dependsOn" => "PersonalTrackers",
      "navButton" => "button.sleep"
    },
    "Stress" => {
      "dependsOn" => "PersonalTrackers",
      "navButton" => "button.stress"
    },
    "Temperature" => {
      "dependsOn" => "PersonalTrackers",
      "navButton" => "button.temperature"
    },
    "Weight" => {
      "dependsOn" => "PersonalTrackers",
      "navButton" => "button.weight"
    },
    #MyMedical dependencies
    "MyMedical" => {
          "dependsOn" => "NavMenu",
          "navButton" => "#MyMedical"
    },
    "Diagnoses" => {
          "dependsOn" => "MyMedical",
          "navButton" => "button.diagnoses"
    },
    "Surgeries" => {
          "dependsOn" => "MyMedical",
          "navButton" => "button.surgeries"
    },
    "MMedications" => {
        "dependsOn" => "MyMedical",
        "navButton" => "button.medications"
    },
    "Allergies" => {
        "dependsOn" => "MyMedical",
        "navButton" => "button.allergies"
    },
    "Hospitalizations" => {
          "dependsOn" => "MyMedical",
          "navButton" => "button.hospitalizations"
    },
    "PregnancyHistory" => {
          "dependsOn" => "MyMedical",
          "navButton" => "button.pregnancy-history"
    },
    "FamilyHistory" => {
          "dependsOn" => "MyMedical",
          "navButton" => "button.family-history"
    },
    "SymptomDiary" => {
        "dependsOn" => "MyMedical",
        "navButton" => "button.symptom-diary"
    },
    "PlanYourAppointment" => {
        "dependsOn" => "MyMedical",
        "navButton" => "button.plan-your-appointment"
    },
    #Contacts dependencies- JRNL-2492
    "Contacts" => {
          "dependsOn" => "NavMenu",
          "navButton" => "#Contacts"
    },
    "ProviderContacts" => {
          "dependsOn" => "Contacts",
          "navButton" => "button.provider-contacts"
    },
    "FacilityContacts" => {
          "dependsOn" => "Contacts",
          "navButton" => "button.facility-contacts"
    },
    "HealthCareContacts" => {
          "dependsOn" => "Contacts",
          "navButton" => "button.healthcare-contacts"
    },
    "InsuranceContacts" => {
          "dependsOn" => "Contacts",
          "navButton" => "button.insurance-contacts"
    },
    "PersonalContacts" => {
          "dependsOn" => "Contacts",
          "navButton" => "button.personal-contacts"
    },
    "CommunicationsLog" => {
          "dependsOn" => "Contacts",
          "navButton" => "button.communications-log"
    },
    #MyStory dependencies
    "MyStory" => {
      "dependsOn" => "NavMenu",
      "navButton" => "#MyStory"
    },
    "Summary" => {
      "dependsOn" => "MyStory",
      "navButton" => "button.summary"
    },
    "PersonalValues" => {
      "dependsOn" => "MyStory",
      "navButton" => "button.personal-values"
    },
    "Assessment" => {
      "dependsOn" => "MyStory",
      "navButton" => "button.assessment"
    },
    "Reflections" => {
      "dependsOn" => "MyStory",
      "navButton" => "button.reflections"
    },
    "Learn" => {
      "dependsOn" => "MyStory",
      "navButton" => "button.learn"
    },
    "Goals" => {
      "dependsOn" => "MyStory",
      "navButton" => "button.goals"
    },
    #MyReminders dependencies
    "MyReminders" => {
      "dependsOn" => "NavMenu",
      "navButton" => "#MyReminders"
    },
    "Appointments" => {
      "dependsOn" => "MyReminders",
      "navButton" => "button.appointments"
    },
    "Medications" => {
      "dependsOn" => "MyReminders",
      "navButton" => "button.medications"
    },
    "PreventiveServices" => {
      "dependsOn" => "MyReminders",
      "navButton" => "button.preventive-services"
    },
    "Other" => {
      "dependsOn" => "MyReminders",
      "navButton" => "button.other"
    },
    "Notifications" => {
      "dependsOn" => "NavMenu",
      "navButton" => "#Notifications"
    },
    "AllNotifications" => {
        "dependsOn" => "Notifications",
        "navButton" => "button.all-notifications"
    },
    "MyVAHealthApp" => {
        "dependsOn" => "Notifications",
        "navButton" => "button.my-va-health-app-notices"
    },
    "VAHealthMessages" => {
        "dependsOn" => "Notifications",
        "navButton" => "button.va-health-messages"
    },
    "Assessments" => {
      "dependsOn" => "NavMenu",
      "navButton" => "#Assessments"
    },
    "Home" => {
        "dependsOn" => "NavMenu",
        "navButton" => "#Home"
    },
    #MyProfile dependencies
    "MyProfile" => {
        "dependsOn" => "NavMenu",
        "navButton" => "#MyProfile"
    },
    "MyContactInformation" => {
        "dependsOn" => "MyProfile",
        "navButton" => "button.my-contact-information"
    },
    "OccupationalHistory" => {
        "dependsOn" => "MyProfile",
        "navButton" => "button.military-occupational-history"
    },
    "ImagesDocuments" => {
        "dependsOn" => "NavMenu",
        "navButton" => "#ImagesandDocuments"
    },
    "All" => {
        "dependsOn" => "ImagesDocuments",
        "navButton" => "button.all"
    },
    "Medical" => {
        "dependsOn" => "ImagesDocuments",
        "navButton" => "button.medical"
    },
    "Military" => {
        "dependsOn" => "ImagesDocuments",
        "navButton" => "button.military"
    },
    "IMGOther" => {
        "dependsOn" => "ImagesDocuments",
        "navButton" => "button.other"
    },
    "HealthReport" => {
        "dependsOn" => "NavMenu",
        "navButton" => "#HealthReport"
    },

  }


  def initialize(driver)
    @driver = driver
    @main = Main.new(driver)
  end

  def getNavMenuHeading()
    navMenuHeading = getTextForElement(:css, "div[snap-drawer='left'] div h2:nth-of-type(2)")
    return navMenuHeading
  end

  def getMyStoryButtonText
    return getTextForElement(:css, NAV["MyStory"]["navButton"])
  end

  def getCommunicationLogButtonText
    return getTextForElement(:css, NAV["CommunicationsLog"]["navButton"] )
  end

  def getContactsButtonText
    return getTextForElement(:css, NAV["Contacts"]["navButton"] )
  end

  def getAssessmentButtonText
    return getTextForElement(:css, NAV["Assessments"]["navButton"] )
  end

  def getFamilyHistoryButtonText
    return getTextForElement(:css, NAV["FamilyHistory"]["navButton"] )
  end

  def getImagesDocumentsButtonText
    return getTextForElement(:css, NAV["ImagesDocuments"]["navButton"] )
  end

  def getNthOptionName(number)
    getTextForElement(:css, "ul.panel-menulist li:nth-child(" + number.to_s + ") button")
  end

  def isDailyEventsButtonVisible()
    return isNavVisible("DailyEvents")
  end

  def isCommunicationLogButtonVisible()
    return isNavVisible("CommunicationsLog")
  end

  def isAssessmentButtonVisible()
    return isNavVisible("Assessments")
  end

  def isMoodButtonVisible()
    return isNavVisible("Mood")
  end

  def isDietButtonVisible()
    return isNavVisible("Diet")
  end

  def isNotificationsButtonVisible()
    return isNavVisible("Notifications")
  end

  def isMyMedicalButtonVisible()
    getTextForElement(:css, "ul.panel-menulist li:nth-child(4) button ")
  end

  def isFamilyHistoryButtonVisible()
    return isNavVisible("FamilyHistory")
  end

  def isImagesDocumentButtonVisible()
    return isNavVisible("ImagesDocuments")
  end

  def isAllButtonVisible()
    return isNavVisible("All")
  end

  def isMedicalButtonVisible()
    return isNavVisible("Medical")
  end

  def isMilitaryButtonVisible()
    return isNavVisible("Military")
  end

  def isIMGOtherButtonVisible()
    return isNavVisible("IMGOther")
  end


  #JRNL-2492
  def isContactsButtonVisible()
    return isNavVisible("Contacts")
  end

  def isMyStoryButtonVisible()
    return isNavVisible("MyStory")
  end

  def isThisNavButtonVisible(number)
    return getTextForElement(:css, "ul.panel-menulist li:nth-child(" + number.to_s + ") button")
  end

  def clickMilitaryOccupationalHistory()
    waitForPageToFinishLoading
    click(:css, MILITARY_OCCUPATIONAL_HISTORY_BTN)
  end

  def clickAssessmentBtn
    navigate("Assessments")
  end

  def clickNotifications()
    waitForPageToFinishLoading
    navigate("Notifications")
  end

  def clickAllNotifications()
    navigate("AllNotifications")
  end

  def clickMyVAHealthApp()
    navigate("MyVAHealthApp")
  end

  def clickVAHealthMessages()
    navigate("VAHealthMessages")
  end

  def clickReminders()
    waitForPageToFinishLoading
    navigate("MyReminders")
  end

  def clickMyMedical()
    navigate("MyMedical")
  end

  #JRNL-2492
  def clickContacts()
    waitForPageToFinishLoading
    navigate("Contacts")
  end

  def clickHealthCareContacts()
    navigate("HealthCareContacts")
  end

  def clickInsuranceContacts()
    navigate("InsuranceContacts")
  end

  def clickPersonalContacts()
    navigate("PersonalContacts")
  end

  def clickCommunicationsLog()
    navigate("CommunicationsLog")
  end

  def clickMyStory()
    waitForPageToFinishLoading
    navigate("MyStory")
  end

  def clickHome()
    navigate("Home")
  end

  def clickSummary()
    navigate("Summary")
  end

  def clickHealthReport()
    waitForPageToFinishLoading
    navigate("HealthReport")
  end

  def clickPersonalValues()
    navigate("PersonalValues")
  end

  def clickAssessment()
    navigate("Assessment")
  end

  def clickReflections()
    navigate("Reflections")
  end

  def clickLearn()
    navigate("Learn")
  end

  def clickGoals()
    navigate("Goals")
  end

  def clickDiagnoses()
    navigate("Diagnoses")
  end

  def clickSurgeries()
    navigate("Surgeries")
  end

  def clickHospitalizations()
    navigate("Hospitalizations")
  end

  def clickPregnancyHistory()
    navigate("PregnancyHistory")
  end

  def clickFamilyHistory()
    navigate("FamilyHistory")
  end

  #Personal Trackers
  def clickPersonalTrackers()
    navigate("PersonalTrackers")
  end

  def clickSleep()
    navigate("Sleep")
  end

  def clickBPAndPulse()
    navigate("BloodPressureandPulse")
  end

  def clickDailyEvents()
    waitForPageToFinishLoading
    navigate("DailyEvents")
  end

  def clickDiet()
    navigate("Diet")
  end

  def clickExercise()
    navigate("Exercise")
  end

  def clickGlucose()
    navigate("Glucose")
  end

  def clickHeight()
    navigate("Height")
  end

  def clickMood()
    navigate("Mood")
  end

  def clickPain()
    navigate("Pain")
  end

  def clickRespiration()
    navigate("Respiration")
  end

  def clickTemperature()
    navigate("Temperature")
  end

  def clickWeight()
    navigate("Weight")
  end

  def clickAppointments()
    navigate("Appointments")
  end

  def clickMedications()
    navigate("Medications")
  end

  def clickPreventiveServices()
    navigate("PreventiveServices")
  end

  def clickOther()
    waitForPageToFinishLoading
    navigate("Other")
  end

  def clickMyProfile()
    navigate("MyProfile")
  end

  def clickImagesDocuments()
    navigate("ImagesDocuments")
  end

  def clickAll()
    waitForPageToFinishLoading
    navigate("All")
  end

  def clickMedical()
    waitForPageToFinishLoading
    navigate("Medical")
  end

  def clickMilitary()
    waitForPageToFinishLoading
    navigate("Military")
  end

  def clickIMGOther()
    waitForPageToFinishLoading
    navigate("IMGOther")
  end

  #SHEERI DID IT!!!

  def getParentNav(nav)
    return NAV[nav]["dependsOn"]
  end

  def getAllSectionNav(feature)
    sections = Array.new()

    NAV.each { | key, value |
      if(value["dependsOn"] == feature)
        sections.push(key)
      end
    }

    return sections
  end

  def getAllFeatureNav()
    features = Array.new()

    NAV.each { | key, value |
      if(value["dependsOn"] == "NavMenu")
        features.push(key)
      end
    }

    return features
  end

  def getTextForButton(nav)
    return getTextForElement(:css, NAV[nav]["navButton"] )
  end

  #Use this function if it the buttons are on either under App Options or under all other sub-groups
  def isNavVisible(nav)
    begin
      element = @driver.find_element(:css, NAV[nav]["navButton"])
      return element.displayed?
    rescue Exception=>e
      return false
    end
  end

  def navigate(nav)

    clickChain = [];
    clickChain.push(nav)

    while NAV[clickChain[0]]["dependsOn"] != nil

      if(isNavVisible(clickChain[0]))
        break;
      end
      clickChain.unshift(NAV[clickChain[0]]["dependsOn"])
    end

    if(clickChain[0] == "NavMenu")
      puts "Opening Nav Button"
      if(getNavMenuHeading() != "App Options")
        puts "Clicking Nav Button"
        @main.clickNavMenu()
      end
      !45.times{ break if (getNavMenuHeading() == "App Options"); sleep 0.2 }
      clickChain.delete("NavMenu")
    end

   for i in 0..clickChain.length - 1
     !45.times { break if (isNavVisible(clickChain[i])); sleep 0.2 }
     waitForPageToFinishLoading
     click(:css, NAV[clickChain[i]]["navButton"]);
   end

  end

  def getNthSubFeatureName(number)
    return getTextForElement(:css, "div.secondary-content div:nth-of-type(2) ul li:nth-of-type(" + number.to_s + ") ")
  end

  def getSubFeatureCount()
    return getElements(:css, "div.secondary-content div:nth-of-type(2) ul li").length
  end

  def getNoMenuItemsMessage()
    return getTextForElement(:css, "div.no-results-message")
  end

end
=end