require_relative  "../../module/DriverUtility"

class SMART_GOAL_CAROUSEL
  include DriverUtility

  CAROUSEL_HEADING = "div.modal-dialog div.modal-header h3"
  SUB_HEADING = "div.carousel-inner div.active div.carousel-caption div.carousel-body h4"
  SUB_H5_HEADING = "div.carousel-inner div.active div.carousel-body h5"
  CAROUSEL_BODY = "div.carousel-inner div.active div.carousel-body"
  CAROUSEL_RIGHT_ARROW = "button[ng-click='next()']"
  CAROUSEL_LEFT_ARROW = "button[ng-click='prev()']"
  QUESTIONLABEL = "div.carousel-inner div.active form[role='form'] p"
  CAROUSEL_CLOSE_BUTTON = "button[data-ng-click='modalContent.close()']"
  ALERT_MSG = "div.carousel-inner div.active form div.alert"
  ALERT_SUCCESS_MSG = "div.carousel-inner div.active form div.alert-success"


  def initialize(driver)
    @driver = driver
  end

  def getCarouselHeading()
    return getTextForElement(:css, CAROUSEL_HEADING)
  end

  def getSubHeading()
    return getTextForElement(:css, SUB_HEADING)
  end

  def getH5SubHeading()
    return getTextForElement(:css, SUB_H5_HEADING)
  end

  def getPaginationAltText()
    element = getElement(:css, "div.carousel.ng-isolate-scope li.ng-scope.active")
    return element.attribute("alt")
  end

  def getQuestionLabel()
    return getTextForElement(:css, QUESTIONLABEL)
  end

  def verifyRadioOptionsLabels(optionLabelsInArray)
    isCorrect = true
    labelCount = optionLabelsInArray.length

    for i in 1..labelCount
      label = getTextForElement(:css, "div.carousel-inner div.active form div:nth-of-type(" + (i + 1).to_s + ") label")
     # puts "array " + optionLabelsInArray[i - 1]
     # puts "label " + label
      if (optionLabelsInArray[i - 1] != label)
        isCorrect = false
        break
      end
    end

    return isCorrect

  end

  def clickNthRadioButton(number)
    click(:css, "div.carousel-inner div.active form div:nth-of-type(" + (number + 1).to_s + ") input")
  end

  def isNthRadioButtonDisabled(number)
    isThisElementDisabled(:css, "div.carousel-inner div.active form div:nth-of-type(" + (number + 1).to_s + ") input")
  end

  def isNthIncorrectIconPresent(number)
    isElementPresentAndVisible(:css, "div.carousel-inner div.active form div:nth-of-type(" + (number + 1).to_s + ") label span.icon-close-alt")
  end

  def getNthIconAltText(number)
    getTextForElement(:css, "div.carousel-inner div.active form div:nth-of-type(" + (number + 1).to_s + ") label span.sr-only")
  end

  def isNthCorrectIconPresent(number)
    isElementPresentAndVisible(:css, "div.carousel-inner div.active form div:nth-of-type(" + (number + 1).to_s + ") label span.icon-check-alt")
  end

  def getAlertMessage()
    return getTextForElement(:css, ALERT_MSG)
  end

end