require_relative  "../../module/DriverUtility"

class MyStory_Summary
  include DriverUtility

  def initialize(driver)
    @driver = driver
  end

  def clickPDFButton()
    click(:css, "button[ng-click='createPdf()']")
  end

  def isPDFButtonDisplayed?()
    isElementPresentAndVisible(:css, "button[ng-click='createPdf()']")
  end

  def verifyEmbeddedPDF()
    urlLink = @driver.current_url
    puts "PDF URL is " + urlLink

    return urlLink.include?('pdf?')

  end

  ##########Personal Values
  def getPersonalValuesHeading()
    getTextForElement(:css, "div.page div span.ng-scope div:nth-of-type(1) h3")
  end

  def isPersonalValuesFirstSection(number)
    isFirst = false
    if (getTextForElement(:css, "div.page div span.ng-scope div:nth-of-type(" + number.to_s + ") h3") == "Personal Values")
      isFirst = true
    end

    return isFirst
  end

  def getWhatReallyMatterQuestionText()
    getTextForElement(:css, "div.what-matters-question")
  end

  def getWhatReallyMatterAnswer()
    getTextForElement(:css, "div.what-matters-response")
  end

  def getLastUpdatedDateForWhatReallyMatter()
    getTextForElement(:css, "div.what-matters-date")
  end

  def getSenseOfJoyQuestionText()
    getTextForElement(:css, "div.sense-of-joy-question")
  end

  def getSenseOfJoyAnswer()
    getTextForElement(:css, "div.sense-of-joy-response")
  end

  def getLastUpdatedDateForSenseOfJoy()
    getTextForElement(:css, "div.sense-of-joy-date")
  end

  #########End of Personal Values

  #########Assessment Graph

  def getAssessmentHeading()
    getTextForElement(:css, "div.page div span.ng-scope div:nth-of-type(2) h3")
  end

  def getGraphIndexId(name)
    if("Well-being" == name)
      return 2
    elsif("Eight Areas of Self Care" == name)
      return 3
    elsif("Professional Care" == name)
      return 4
    end
  end

  def getTableViewDescriptionInfoText()
    return getTextForElement(:css, "div[ng-if='isGraphView'] div:nth-of-type(1)")
  end

  def getNoteInfoText(name)
    index = getGraphIndexId(name)
    return getTextForElement(:css, "div[ng-if='isGraphView'] div:nth-of-type(" + index.to_s + ") div[ng-if='graphConfig[assessment.type]'] div:nth-of-type(2)")
  end

  def isXAxisLabelsValid(name, labelArray)
    isValid = true
    index = getGraphIndexId(name)
    xAxisLabelElements = getElements(:css, "div[ng-if='isGraphView'] div:nth-of-type(" + index.to_s + ") div[ng-if='graphConfig[assessment.type]'] div:nth-of-type(1) g.highcharts-xaxis-labels text")

    for i in 0..(labelArray.length - 1)
      if(xAxisLabelElements[i].text != labelArray[i])
        isValid = false
        break
      end
    end

    return isValid

  end

  def getSelfCareGraphLegend()
    getTextForElement(:css, "div[ng-if='isGraphView'] div:nth-of-type(3) div[ng-if='graphConfig[assessment.type]'] div:nth-of-type(1) g.highcharts-legend g")
  end

  def getYAxisLabel(name)
    index = getGraphIndexId(name)
    getTextForElement(:css, "div[ng-if='isGraphView'] div:nth-of-type(" + index.to_s + ") div[ng-if='graphConfig[assessment.type]'] div:nth-of-type(1) text.highcharts-yaxis-title tspan")
  end

  def isGraphDisplayed?(name)
    isDisplayed = false

    begin
      index = getGraphIndexId(name)
      header = getTextForElement(:css, "div[ng-if='isGraphView'] div:nth-of-type(" + index.to_s + ") div[ng-if='graphConfig[assessment.type]'] h4")

      if(header != name)
        puts "[isGraphDisplayed?] header != name   header is :" + header
      else
        graphIndex = -1
        if (name == "Well-being")
          graphIndex = 0
        elsif("Eight Areas of Self Care" == name)
          graphIndex = 2
        elsif("Professional Care" == name)
          graphIndex = 4
        end

         graphElement = getElement(:id, "highcharts-" + graphIndex.to_s)

          if(graphElement.displayed?)
            isDisplayed = true
          end
        end
      rescue Exception=>e
        return false
    end

    return isDisplayed
  end

  def isNotWorkingWithProfTextDisplayed?()
    isDisplayed = false
    index = getGraphIndexId("Professional Care")

    begin
      element = getElement(:css, "div[ng-if='isGraphView'] div:nth-of-type(" + index.to_s + ") div[ng-if='graphConfig[assessment.type]'] div:nth-of-type(3)")
      if(element.displayed? and element.text == "I am not working with a healthcare professional" )
        isDisplayed = true
      end
    rescue Exception=>e
      return false
    end

    return isDisplayed
  end

  def isPhoneViewGraphMessageDisplayed?()
    isDisplayed = false
    index = getGraphIndexId("Professional Care")

    begin
      element = getElement(:css, "div.visible-xs.xs-graph-message")
      if(element.displayed? and element.text == "Graph view available in desktop view only." )
        isDisplayed = true
      end
    rescue Exception=>e
      return false
    end

    return isDisplayed
  end

  def clickTableButton
    click(:css, "button[ng-click='tableGraphButton.onClick()']")
  end

  def getTableGraphButtonText()
    getTextForElement(:css, "button[ng-click='tableGraphButton.onClick()'] span")
  end

  def isTableButtonDisplayed?()
    isDisplayed = false
    if(is_element_present(:css, "button[ng-click='tableGraphButton.onClick()']") and isElementVisible(:css, "button[ng-click='tableGraphButton.onClick()']") and getTableGraphButtonText() == "Table")
      isDisplayed = true
    end
    return isDisplayed
  end
###########End of Assessment Graph

  def clickGraphButton
    click(:css, "button[ng-click='tableGraphButton.onClick()']")
  end

  def isGraphButtonDisplayed?()
    isDisplayed = false
      if(is_element_present(:css, "button[ng-click='tableGraphButton.onClick()']") and isElementVisible(:css, "button[ng-click='tableGraphButton.onClick()']") and getTableGraphButtonText() == "Graph")
        isDisplayed = true
      end
    return isDisplayed
  end

  def getFocusedElementText()
    element = getActiveElement()
    return element.text
  end


######## Assessment Table

  def getTableClassName(tableName)
    if(tableName =="Well-being")
      return "table.well-being"
    elsif(tableName == "Eight Areas of Self Care")
      return "table.self-care-area"
    elsif(tableName == "Professional Care")
      return "table.professional-care-area"
    end
  end

  def verifyTableHeader(tableName, tableHeaderArray)
    headerDisplayed = true
    tableClassName = getTableClassName(tableName)
    elements = getElements(:css, tableClassName + " tbody tr th")
    for i in 0..elements.length - 1
      if (tableHeaderArray[i] != elements[i].text)
        headerDisplayed = false
        break
      end
    end

    return headerDisplayed
  end

  def getTableCellValue(tableName, row, column)
    tableClassName = getTableClassName(tableName)
    getTextForElement(:css, tableClassName + " tbody tr:nth-of-type(" + (row + 1).to_s + ") td:nth-of-type(" + column.to_s + ")")
  end

  def isTableDisplayed?(tableName)
    tableClassName = getTableClassName(tableName)
    isDisplayed = false

    begin
      element = getElement(:css, tableClassName)
      if(element.displayed?)
        isDisplayed = true
      end
    rescue Exception => e
      return false
    end

    return isDisplayed
  end

  def getScaleInfoText(tableName)
    if(tableName =="Well-being")
      getTextForElement(:css, "div.assessment-summary div span:nth-of-type(1)")
    elsif(tableName == "Eight Areas of Self Care")
      getTextForElement(:css, "div.assessment-summary div span:nth-of-type(2)")
    elsif(tableName == "Professional Care")
      getTextForElement(:css, "div.assessment-summary div span:nth-of-type(3)")
    end

  end

  def getLastUpdatedValueForWellBeingPhoneView()
    getTextForElement(:css, "div[ng-if='!isGraphView'] div.well-being span")
  end

  def getPhoneViewDivClassName(name)
    if(name == "Well-being")
      return "well-being"
    elsif(name == "Working the body")
      return "working-the-body"
    elsif(name == "Recharge")
      return "recharge"
    elsif(name == "Food and Drink")
      return "food-and-drink"
    elsif(name == "Personal Development")
      return "personal-development"
    elsif(name == "Family, Friends, and Co-Workers")
      return "family-friend-co-worker"
    elsif(name == "Spirit and Soul")
      return "spirit-and-soul"
    elsif(name == "Surroundings")
      return "surroundings"
    elsif(name == "Power of the Mind")
      return "power-of-mind"
    elsif(name == "Professional Care")
      return "professional-care-area"
    end
  end

  def getCellTextForWellBeingAndProfCarePhoneView(cellName, row)
     divClassName = getPhoneViewDivClassName(cellName)
    where = "div[ng-if='!isGraphView'] div." + divClassName + " div:nth-of-type(" + row.to_s + ")"
    getTextForElement(:css, where)
  end

  def getSelfCareArea(cellName)
    divClassName = getPhoneViewDivClassName(cellName)
    getTextForElement(:css, "div[ng-if='!isGraphView'] div." + divClassName + " div:nth-of-type(1)" )
  end

  def getCellTextForSelfCarePhoneView(cellName, row)
    divClassName = getPhoneViewDivClassName(cellName)
    where = "div[ng-if='!isGraphView'] div." + divClassName + " div:nth-of-type(2) div:nth-of-type(" + row.to_s + ")"
    getTextForElement(:css, where)
  end

######## End of Assessment Table

######## Reflections
  def getReflectionsHeading()
    getTextForElement(:css, "div.page div span.ng-scope div:nth-of-type(3) h3")
  end

  def getReflectionNowThatQuestionLabel()
    getTextForElement(:css, "div.health-vision-question")
  end

  def getReflectionNowThatAnswer()
    getTextForElement(:css, "div.health-vision-response")
  end

  def getUpdatedDateForReflectionNowThatQuestion()
    getTextForElement(:css, "div.health-vision-date")
  end

  def getReflectionAreThereQuestionLabel()
    getTextForElement(:css, "div.where-to-start-question")
  end

  def getReflectionAreThereAnswer()
    getTextForElement(:css, "div.where-to-start-response")
  end

  def getUpdatedDateForAreThereQuestion()
    getTextForElement(:css, "div.where-to-start-date")
  end

######## End of Reflections


end