require_relative  "../../module/DriverUtility"

class MyStory_Learn
  include DriverUtility

  def initialize(driver)
    @driver = driver
  end

  def getIdByName(name)
    if (name == "Table of Contents")
      return "table-of-contents"
    elsif(name == "Introduction")
      return "introduction"
    elsif (name == "Me")
      return "me"
    elsif (name == "Mindful Awareness")
      return "mindful-awareness"
    elsif (name == "The Eight Areas of Self Care")
      return "eight-areas"
    elsif (name == "Working the Body")
      return "working-the-body"
    elsif (name == "Working Your Body")
      return "working-the-body"
    elsif (name == "Surroundings")
      return "surroundings"
    elsif (name == "Personal Development")
      return "personal-development"
    elsif (name == "Food and Drink")
      return "food-and-drink"
    elsif (name == "Recharge")
      return "recharge"
    elsif (name == "Family, Friends, and Co-Workers")
      return "family-friends-and-co-workers"
    elsif (name == "Spirit and Soul")
      return "spirit-and-soul"
    elsif (name == "Power of the Mind")
      return "power-of-the-mind"
    elsif (name =="Professional Care")
      return "professional-care"
    elsif (name == "Community")
      return "community"
    elsif (name == "The My Story Tool")
      return "my-story-tool"
    end
  end

  def clickGraphOfEquationForWholeHealthMobileLink()
    click(:css, "a[href='_assets/pdfs/The_Equation_for_Whole_Health.pdf']")
  end

  def clickTableOfContents(linkName)
    scrollTo = getIdByName(linkName)
    click(:css, "a[scroll-to='"  + scrollTo + "']")
  end

  def clickGraphOfComponentsOfProactiveHealthMobileLink()
    click(:css, "a[href='_assets/pdfs/The_Components_of_Proactive_Health_and_Well-being.pdf']")
  end

  def clickNthBackToTopLink(number)
    elements = getElements(:css, "a[scroll-to='table-of-contents']")
    elements[number -1].location_once_scrolled_into_view
    elements[number -1].click

  end

  def isTableOfContentsLinkVisible(linkName)
    idStr = getIdByName(linkName)
    puts "ID string found " + idStr

    return isElementVisible(:css,"a[scroll-to='"  + idStr + "']")
  end

  def isContentDisplayedOnPage(name)
    idStr = getIdByName(name)
    element = getElement(:id, idStr)

    maxY = @driver.execute_script("return document.querySelector('html').offsetHeight - window.innerHeight;").to_i
    elementY = element.location.y
    elementY = elementY > maxY ? maxY : elementY
    currentY = @driver.execute_script("return window.scrollY;").to_i

    return elementY < currentY + 15 && elementY > currentY - 15
  end

  def isGraphOfComponentsOfProactiveHealthMobileLinkVisible()
    isElementVisible(:css, "a[href='_assets/pdfs/The_Components_of_Proactive_Health_and_Well-being.pdf']")
  end

  def isGraphOfComponentsOfProactiveHealthVisible()
    isElementVisible(:css, "img[src='_assets/images/my-story_learn_circle.png']")
  end

  def isGraphOfEquationForWholeHealthVisible()
    isElementVisible(:css, "img[src='_assets/images/my-story_learn_equation.png']")
  end

  def isAllBackToLinkVisibleAndClickable()
    elements = getElements(:css, "a[scroll-to='table-of-contents']")
    puts "[isAllBackToLinkVisibleAndClickable] Back to Top link Count: " + elements.length.to_s

    for i in 0..(elements.length - 1)
      elements[i].location_once_scrolled_into_view
      elements[i].click
      !45.times{ break if (isContentDisplayedOnPage("Table of Contents") == true); sleep 1 }

      if (!isContentDisplayedOnPage("Table of Contents"))
        return false
      end
    end

    return true
  end

  def isGraphOfEquationForWholeHealthMobileLinkVisible()
    isElementVisible(:css, "a[href='_assets/pdfs/The_Equation_for_Whole_Health.pdf']")
  end

  def getTableOfContentsLabel()
    getTextForElement(:css, ".primary-content div.page h3")
  end

  def getAltTextForGraphOfComponentsOfProactiveHealth()
    element = getElement(:css, "img[src='_assets/images/my-story_learn_circle.png']")
    return element.attribute("alt")
  end

  def getAltTextForGraphOfEquationForWholeHealth()
    element = getElement(:css, "img[src='_assets/images/my-story_learn_equation.png']")
    return element.attribute("alt")
  end

  def getNthSubHeadingTextForIntroduction(number)
    return getTextForElement(:css,  "div.page h4:nth-of-type(" + number.to_s + ")")
  end

  def getLearnHeadingText(name)
    idStr = getIdByName(name)
    return getTextForElement(:id, idStr)
  end

  def getFirstTOCLink()
      getTextForElement(:css, "ol.table-of-contents li:nth-of-type(1)")
  end

  def getFirstContentHeader()
      getTextForElement(:css, "div.page h3:nth-of-type(2)")
  end

  def getMyStoryToolContent()
    getTextForElement(:css, "div.page p:nth-of-type(1)")
  end

end