require_relative  "../../module/DriverUtility"

class MyStory_History
  include DriverUtility

  def initialize(driver)
    @driver = driver
  end

  def toggleFilterBtn()
    click(:css, "div.nav ul button[ng-click='toggleFilterState()']")
  end

  def isExpandCollapseFilterBUttonDisplayed()
    isDisplayed = false
    begin
      element = getElement(:css, "div.nav ul button[ng-click='toggleFilterState()']")
      if(element.displayed?)
        isDisplayed = true
      end
    rescue Exception => e
      return false
    end

    return isDisplayed
  end

  def getAltTextFilterButton()
    getElement(:css, "button[ng-click='toggleFilterState()']").attribute("aria-label")
  end

  def isAltTextFilterButtonDisplayed?()
    # isDisplayed = false
    # begin
    #   element = getElement(:css, "button[ng-click='toggleFilterState()'] span:nth-of-type(2)")
    #   if(element.displayed?)
    #     isDisplayed = true
    #   end
    # rescue Exception => e
    #   return false
    # end

    return getElement(:css, "button[ng-click='toggleFilterState()']").attribute("aria-label") != nil
  end

  def getRequiredInfoText()
    getTextForElement(:css, "form.filter-form div[ng-if='requiredExists()'] span")
  end

  def getStartDateLabel()
    getTextForElement(:css, "label[for='startDate'] div span")
  end

  def getEndDateLabel()
    getTextForElement(:css, "label[for='endDate'] div span")
  end

  def getFilterSectionIndex(name)
    if(name == "Well-being")
      return 1
    elsif(name == "Working the body")
      return 2
    elsif(name == "Recharge")
      return 3
    elsif(name == "Food and Drink")
      return 4
    elsif(name == "Personal Development")
      return 5
    elsif(name == "Family, Friends, and Co-Workers")
      return 6
    elsif(name == "Spirit and Soul")
      return 7
    elsif(name == "Surroundings")
      return 8
    elsif(name == "Power of the Mind")
      return 9
    elsif(name == "Professional Care")
      return 10
    end
  end

  def checkFilterSection(name)
    index = getFilterSectionIndex(name)
    click(:css, "div.margin-top-md div:nth-of-type(" + index.to_s + ") input[type='checkbox']")
  end

  def isCheckBoxChecked(name)
    isChecked = false
    index = getFilterSectionIndex(name)
    element = getElement(:css, "div.margin-top-md div:nth-of-type(" + index.to_s + ") input[type='checkbox']")

   # puts "element.attribute('checked') "  + element.attribute("checked").to_s
    if (element.attribute("checked") == "true")
      isChecked = true
    end
    return isChecked
  end

  def isTableSectionDisplayed(name)
    tbleClass = getSectionClassName(name)
    isElementPresentAndVisible(:css, "div.hidden-xs table." + tbleClass)
  end

  def isFilterButtonDisabled()
    isDisabled = false
    element = getElement(:css, "button.filter-action-btn")
    if element.attribute("disabled") == "true"
      isDisabled = true
    end
    return isDisabled
  end

  def getScaleInfoText(name)
    index = getSectionIndex(name)
    getTextForElement(:css, "div.col-sm-8.col-xs-12.column.primary-content.ng-scope.content-loaded > div:nth-child(" + index.to_s + ") > div > span")

  end

  def isBackButtonDisplayed?()
    isElementPresentAndVisible(:css, "button[title='Return to Previous Screen']")
  end

  def getSectionIndex(name)
    if(name == "Well-being")
      return 3
    elsif(name == "Working the body")
      return 4
    elsif(name == "Recharge")
      return 5
    elsif(name == "Food and Drink")
      return 6
    elsif(name == "Personal Development")
      return 7
    elsif(name == "Family, Friends, and Co-Workers")
      return 8
    elsif(name == "Spirit and Soul")
      return 9
    elsif(name == "Surroundings")
      return 10
    elsif(name == "Power of the Mind")
      return 11
    elsif(name == "Professional Care")
      return 12
    end
  end


  def getSectionClassName(name)
    if(name == "Well-being")
      return "wellBeingAssessments"
    elsif(name == "Working the body")
      return "workingthebody"
    elsif(name == "Recharge")
      return "recharge"
    elsif(name == "Food and Drink")
      return "foodanddrink"
    elsif(name == "Personal Development")
      return "personaldevelopment"
    elsif(name == "Family, Friends, and Co-Workers")
      return "familyfriendcoworker"
    elsif(name == "Spirit and Soul")
      return "spiritandsoul"
    elsif(name == "Surroundings")
      return "surroundings"
    elsif(name == "Power of the Mind")
      return "powerofmind"
    elsif(name == "Professional Care")
      return "professionalCareAssessments"
    end
  end

  def getSectionHeader(name)
    className = getSectionClassName(name)
    return getTextForElement(:css, "h4.header-tag." + className)

  end

  def isTableDisplayed?(name)
    className = getSectionClassName(name)
    isElementPresentAndVisible(:css,"div.hidden-xs table." + className)
  end

  def isReportPopulatedOnFilter(name)
    isPopulated = true
    index = getSectionIndex(name)
    heading = getSectionHeader(name)
    puts "heading is "  + heading
    if(heading != name)
      return false
    else
     tbleClass = getSectionClassName(name)
     elements = getElements(:css,"div.hidden-xs table." + tbleClass + " tr")
      if(elements.length > 0)
        for i in 2..elements.length
          #puts 'element length ' + elements.length.to_s
          tdElements = getElements(:css,"div.hidden-xs table." + tbleClass + " tr:nth-of-type(" + i.to_s +  ") td")
          #puts "tdElements " + tdElements[0].text

          if (isDateWithinFilteredDateRange?(tdElements[0].text) == false)
            isPopulated = false
          end
        end
      end
    end
    return isPopulated

  end

  def verifyTableHeader(tableName, tableHeaderArray)
    headerDisplayed = true
    tableClassName = getSectionClassName(tableName)
    elements = getElements(:css, "div.hidden-xs table." + tableClassName + " tbody tr th")
    for i in 0..elements.length - 1

      if (tableHeaderArray[i] != elements[i].text)
        headerDisplayed = false
        break
      end
    end

    return headerDisplayed
  end

  def getNoAnswersGivenText(name)
    className = getSectionClassName(name)
    return getTextForElement(:css, "div.no-answer." + className)
  end

  def isDateWithinFilteredDateRange?(dateStr)
    isValid = false
    fromDateObj = DateTime.strptime(getTextFromInput(:css, "input[name='startDate']"), "%m/%d/%Y")
    toDateObj = DateTime.strptime(getTextFromInput(:css, "input[name='endDate']"), "%m/%d/%Y")
    dateObj = DateTime.strptime(dateStr, "%m/%d/%Y")

    if fromDateObj <= dateObj and toDateObj >= dateObj then
      isValid = true
    end

    return isValid
  end

  def isSortedReverseChronologicalOrder(tableName)
    isSortedInReverse = true;
    tbleClass = getSectionClassName(tableName)
    elements = getElements(:css,"div.hidden-xs table." + tbleClass + " tr")
    if(elements.length > 0)
      dateText = getTextForElement(:css,"div.hidden-xs table." + tbleClass + " tr:nth-of-type(2) td:nth-of-type(1)")
      previousDate = DateTime.strptime(dateText, format="%m/%d/%Y")

      for i in 2..elements.length

        tdElements = getElements(:css,"div.hidden-xs table." + tbleClass + " tr:nth-of-type(" + i.to_s +  ") td")
        nextDate = DateTime.strptime(tdElements[0].text, format="%m/%d/%Y")

        puts "[isSortedReverseChronologicalOrder] " + tableName + " previousDate " + previousDate.to_s + "  nextDate "  + nextDate.to_s

        if(previousDate < nextDate)
          isSortedInReverse = false
          puts "Current date is greater than previous date"
          break
        end
        previousDate = nextDate

      end
    end

    return isSortedInReverse
  end

  def getPhoneViewCellData(name, nthCardview, nthRow)
    className = getSectionClassName(name)
    elements = getElements(:css, "div.assessment-table-phone." + className + " div:nth-of-type(" + nthRow.to_s + ")")

    return elements[nthCardview - 1].text
  end

end