require_relative  "../../module/DriverUtility"
require_relative  "../../helpers/table"
require_relative '../../helpers/entry_form'

class MyStory_Goal < EntryForm

  include DriverUtility
  include Table

  ADD_GOAL_BUTTON = "button[ng-click='getDetails()']"
  GOAL_NAME = "input[name='name']"
  GOAL_DESCRIPTION = "input[name='description']"
  GOAL_START_DATE = "input[name='startDate']"
  GOAL_END_DATE = "input[name='endDate']"
  BACK_BUTTON = "button[ng-click='goBack()']"
  REWARD = "input[name='reward']"
  ADD_STEP_BUTTON = "button[ng-click='addStep()']"
  ADD_PROGRESS_BUTTON = "button[ng-click='addProgress()']"
  SMART_GOAL = "a[id='learnMoreAboutSmartGoal']"
  GRADUATION_CAP = "span.icon-gradcap"

  def initialize(driver)
    @driver = driver
  end

  def isAddButtonVisible()
    isElementPresentAndVisible(:css, ADD_GOAL_BUTTON)
  end

  def isAddButtonRightJustified()
    element = getElement(:css, "button[title='Add']")
    classValue = element.attribute("class")
    return classValue.include?("right")
  end

  def clickAddButton()
    waitForPageToFinishLoading
    click(:css, ADD_GOAL_BUTTON)
  end

  def getGoalReflectionText()
    return getTextForElement(:css, "div.col-xs-12 p.vision")
  end

  def getVisionLabel()
    getTextForElement(:css,"div[ng-if='!!reflectionsDataPointers.values.responses[0].response'] b.input-label-content")
  end

  def isVisionLabelDisplayed()
    isElementPresentAndVisible(:css, "div[ng-if='!!reflectionsDataPointers.values.responses[0].response'] b.input-label-content")
  end

  def getGoalNameLabel()
    getTextForElement(:css, "input-text[name='name'] span.input-label-content")
  end

  def getGoalName()
    return getTextFromInput(:css, "input[name='name']")
  end

  def isGoalNameRequired()
    return isFieldRequired(:css, GOAL_NAME)
  end

  def setGoalName(text)
    @driver.find_element(:css, GOAL_NAME).clear
    @driver.find_element(:css, GOAL_NAME).send_keys(text)
    sleep 0.2
  end

  def isDescriptionRequired()
    return isFieldRequired(:css, GOAL_DESCRIPTION)
  end

  def getDescriptionLabel()
    getTextForElement(:css, "input-text[name='description'] span.input-label-content")
  end

  def getDescription()
    getTextFromInput(:css, GOAL_DESCRIPTION)
  end

  def setDescription(text)
    @driver.find_element(:css, GOAL_DESCRIPTION).clear
    @driver.find_element(:css, GOAL_DESCRIPTION).send_keys(text)
    sleep 0.2
  end

  def isStatusOptionPresent()
    return isElementPresentAndVisible(:css,"input[name='statusOption_0']")
  end

  def getStartDateLabel()
    getTextForElement(:css, "label[for='startDate'] span.input-label-content")
  end

  def isGoalStartDateRequired()
    return isFieldRequired(:css, GOAL_START_DATE)
  end

  def getGoalStartDate()
    getTextFromInput(:css, GOAL_START_DATE)
  end

  def getGoalsCount()
    return getCount()
  end

  def selectStatus(status)
    if (status == "Active")
      waitForPageToFinishLoading
      click(:css, "input[type='radio'][value='Active']")
    elsif status == "Inactive"
      waitForPageToFinishLoading
      click(:css, "input[type='radio'][value='Inactive']")
    else
      waitForPageToFinishLoading
      click(:css, "input[type='radio'][value='Complete']")
    end

  end

  def setGoalStartDate(text)
    @driver.find_element(:css, GOAL_START_DATE).clear
    @driver.find_element(:css, GOAL_START_DATE).send_keys(text)
    sleep 0.2
  end

  def setGoalEndDate(text)
    @driver.find_element(:css, GOAL_END_DATE).clear
    @driver.find_element(:css, GOAL_END_DATE).send_keys(text)
    sleep 0.2
  end

  def getStartDateGuidanceText()
    return getPlaceHolderByCSS(:css, GOAL_START_DATE)
  end

  def getType()
    return getSelectBoxText("select[name='goalType']")
  end

  def selectType(text)
    setSelectBoxValue("select[name='goalType']", text)
  end

  def getGoalEndDate()
    getTextFromInput(:css, GOAL_END_DATE)
  end

  def getEndDateGuidanceText()
    return getPlaceHolderByCSS(:css, GOAL_END_DATE)
  end

  def getEndDateLabel()
    return getTextForElement(:css, "label[for='endDate'] span.input-label-content")
  end

  def isGoalEndDateRequired()
    isFieldRequired(:css, GOAL_END_DATE)
  end

  def clickBackButton()
    click(:css, BACK_BUTTON)
  end

  def getRewardAtCompletion()
    getTextFromInput(:css, REWARD )
  end

  def getRewardLabel()
    return getTextForElement(:css, "input-text[name='reward'] span.input-label-content")
  end

  def setRewardAtCompletion(text)
    @driver.find_element(:css, REWARD).clear
    @driver.find_element(:css, REWARD).send_keys(text)
    sleep 0.2
  end

  def getStepsLabel()
    return getTextForElement(:css, "div.step-history legend")
  end

  def checkNthStepComplete(number)
    waitForPageToFinishLoading
    click(:css, "input[type='checkbox'][name='complete_" + number.to_s + "']")
  end

  def isNthStepCompleteChecked(number)
    element = getElement(:css, "input[type='checkbox'][name='complete_" + number.to_s + "']")
    return element.selected?
  end

  def setNthStep(number, text)
    waitForPageToFinishLoading
    @driver.find_element(:css, "input[name='description_" + number.to_s  + "']").clear
    @driver.find_element(:css, "input[name='description_" + number.to_s  + "']").send_keys(text)
    sleep 0.2
  end

  def getNthStep(number)
    return getTextFromInput(:css, "input[name='description_" + number.to_s  + "']")
  end

  def getNthStepLabel(number)
    waitForPageToFinishLoading
    element = @driver.find_element(:css, "input-text[name='description_" + number.to_s + "'] span.input-label-content")
    element.location_once_scrolled_into_view
    return getTextForElement(:css, "input-text[name='description_" + number.to_s + "'] span.input-label-content")
  end

  def getNThDueDateLabel(number)
    return getTextForElement(:css, "date-control[name='due_" + number.to_s + "'] span.input-label-content")
  end

  def setNthStepDueDate(number, text)
    @driver.find_element(:css, "date-control[name='due_" + number.to_s + "'] input").clear
    @driver.find_element(:css, "date-control[name='due_" + number.to_s + "'] input").send_keys(text)
    sleep 0.2
  end

  def getNthStepDueDate(number)
    return getTextFromInput(:css, "date-control[name='due_" + number.to_s + "'] input")
  end

  def getNthDueDateGuidanceText(number)
    return getPlaceHolderByCSS(:css, "date-control[name='due_" + number.to_s + "'] input")
  end

  def isAddStepBtnVisible()
    return isElementPresentAndVisible(:css, ADD_STEP_BUTTON)
  end

  def isNthDeleteStepPresent(number)
    isElementPresentAndVisible(:css, "button[name='deleteStep_" + number.to_s + "']")
  end

  def isNthStepPresent(number)
    return isElementPresentAndVisible(:css, "date-control[name='due_" + number.to_s + "'] input")
  end

  def getNthDeleteStepButtonLabel(number)
    return getTextForElement(:css, "button[name='deleteStep_" + number.to_s + "']")
  end

  def getNthDeleteStepButtonAltText(number)
    element = getElement(:css, "button[name='deleteStep_" + number.to_s + "']")
    altText = element.attribute("title")
    return altText
  end

  def getStepsCount()
    elements = getElements(:css, "div.step-history div.step")
    return elements.length
  end

  def clickNthDeleteStepButton(number)
    click(:css, "button[name='deleteStep_" + number.to_s + "']")
  end

  def isNthStepFocused(number)
    element = getActiveElement()
    name = element.attribute("name")
    return name.include?('description_' + number.to_s)
    element = driver.find_element(:css, "button[ng-click='confirmSave()']")
    element.location_once_scrolled_into_view
  end

  def getAddStepBtnText()
    return getTextForElement(:css, ADD_STEP_BUTTON)
  end

  def clickAddStepButton()
    waitForPageToFinishLoading
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    click(:css, ADD_STEP_BUTTON)
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
  end

  def clickAddStepButtonJquery()
    clickJquery(ADD_STEP_BUTTON)
  end

  def getTableTextbyRowCol(row, col)
    getTextForElement(:css, "div.list-table ul li:nth-of-type(" + row.to_s + ") span:nth-of-type(" + col.to_s + ")")
  end

  def isProgressBarsVisible()
    isElementPresentAndVisible(:css, "div.progress-entry span.bar div.progress")
  end

  def clickAddProgress()
    waitForPageToFinishLoading
    click(:css, ADD_PROGRESS_BUTTON)
  end

  def isAddProgressButtonVisible()
    isElementPresentAndVisible(:css, ADD_PROGRESS_BUTTON)
  end

  def moveProgressBarToRight(number)
    moveArrowInputRangeToRight("addProgress", number)
  end

  def moveProgressBarToLeft(number)
    moveArrowInputRangeToLeft("addProgress", number)
  end

  def getNthProgressDate(number)
      getTextForElement(:css, "div.progress-history div:nth-of-type(" + number.to_s + ") span.margin-right")
  end

  def getNThGoalProgress(number)
    getTextForElement(:css, "div.progress-history div:nth-of-type(" + number.to_s + ") span.percent")
  end

  def getNthProgressBarValue(number)
    element = getElement(:css, "div.progress-history div:nth-of-type(" + number.to_s + ") span.bar div div.progress-bar")
    valueText = element.attribute("aria-valuetext")
    return valueText
  end

  def getProgressHistoryLabel()
    getTextForElement(:css, "div.progress-history legend")
  end

  def findIndexWithGivenGoalName(name)
    begin
      goalCount = getElements(:css, "div.list-table ul li").length
      #puts "goal count" + goalCount.to_s

      index = -1
      for i in 1..goalCount
        goalName = getNthGoalName(i)

        #puts "Goal name "  + goalName
        if name == goalName then
          #puts "name == goalName"
          index = i
          break
        end
      end

    rescue Exception => e
     return -1
    end
    #puts "Index = " + index.to_s
    return index
  end

  def allElementsDisabled?()
    isDisabled = true
    allInputElements = getElements(:css, "div.primary-content div input")
    allButtonElements = getElements(:css, "div.primary-content div button")
    allTextAreaElements = getElements(:css, "div.primary-content div textarea")

   # puts "input count " + allInputElements.length.to_s
   # puts "button count " + allButtonElements.length.to_s
   # puts "text area count " + allTextAreaElements.length.to_s

    for j in 0..(allButtonElements.length - 1)
     # puts "allButtonElements " + j.to_s + " " +  allButtonElements[j].attribute("disabled")
      if (allButtonElements[j].attribute("disabled") != "true" and allButtonElements[j].attribute("ng-click") != "delete()" and allButtonElements[j].attribute("ng-click") != "cancel()" and  allButtonElements[j].attribute("ng-click") != "goBack()" )
        isDisabled = false
         puts allButtonElements[j].tag_name + " is not disabled"
         puts "button function " + allButtonElements[j].attribute("ng-click")
        break
      end
    end

    for k in 0..(allTextAreaElements.length - 1)
      #puts "allTextAreaElements " + k.to_s + " " +  allTextAreaElements[k].attribute("disabled")
      if (allTextAreaElements[k].attribute("disabled") != "true")
        isDisabled = false
        puts allTextAreaElements[k].tag_name + " is not disabled"
        break
      end
    end

    for i in 0..(allInputElements.length - 1)
    #  puts "allInputElements " + i.to_s + " " +  allInputElements[i].attribute("disabled")
      if (allInputElements[i].attribute("disabled") != "true")
        isDisabled = false
        puts allInputElements[i].tag_name + " is not disabled"
        break
      end

    end
    return isDisabled

  end

  def isDateWithinFilteredDateRange?()
    fromDate = getTextFromInput(:css, "input[name='startDate']")
    toDate = getTextFromInput(:css, "input[name='endDate']")

    #puts "From Date: " + fromDate  + " -- To Date: " + toDate
    listCount = getCount()
    isValid = true

    fromDateObj = DateTime.strptime(fromDate, "%m/%d/%Y")
    toDateObj = DateTime.strptime(toDate, "%m/%d/%Y")

    for i in 1..listCount
      dateStr = getNthGoalEndDate(i)
      dateObj = DateTime.strptime(dateStr, "%m/%d/%Y")

      if dateObj <= fromDateObj and dateObj >= toDateObj then
        isValid = false
        break
      end
    end

    return isValid

  end

  def getNthGoalEndDate(number)
    dateStr = ""
    if(isThisRadioButtonOrCheckBoxSelected("radio", "Complete", "statusOption"))
     # puts "Number is " + number.to_s
      dateStr = getNthDateCompleted(number)
    else #Active/Inactive
      cellStr = getTableTextbyRowCol(number, 3)
      cellStrArr = cellStr.to_s.split("\n")
      dateStr = cellStrArr[1]
    end

    return dateStr
  end

  def getNthProgress(number)

    getTextForElement(:css, "div.list-table ul li:nth-of-type(" + number.to_s + ") span:nth-of-type(2)")
  end

  def getNthDateCompleted(number)
    text = getTextForElement(:css, "div.list-table ul li:nth-of-type(" + number.to_s + ") span.ng-scope")
    #puts "Text is "  + text
    cellStrArr = text.to_s.split("\n")
    return cellStrArr[1]
  end

  def isSortedByChronologicalOrder()
    sortedCorrectly = true
    groupLength = getCount()

    displayedDate = getNthGoalEndDate(1)
    previousDate = DateTime.strptime(displayedDate, format="%m/%d/%Y")

    for i in 2..groupLength

      displayedDate = getNthGoalEndDate(i)

      thisDate = DateTime.strptime(displayedDate, format="%m/%d/%Y")

      if(previousDate > thisDate) then
        sortedCorrectly = false
        break
      end

      previousDate = thisDate

    end

    return sortedCorrectly
  end


  def getNthProgress(number)
    getTextForElement(:css, "div.list-table ul li:nth-of-type(" + number.to_s + ") span.progress-data")
  end

  def getNthGoalName(number)
    getTextForElement(:css, "div.list-table ul li:nth-of-type(" + number.to_s + ") span.goal-name-data span.ng-binding")
  end

  def getNoResultsFoundMessage()
    getTextForElement(:css, "div.no-results-message")
  end

  def getGraduationCapAltText()
    getTextForElement(:css, "div.page form[name='form'] div[ng-transclude] div.inline-icon span.sr-only")
  end


end