require_relative  "../../module/DriverUtility"
require_relative '../../helpers/entry_form'

class MyStory < EntryForm
  include DriverUtility

  SUMMARY_ICON = "i.icon-mystory-summary"
  PERSONAL_VALUES_ICON = "i.icon-mystory-personalvalues"
  ASSESSMENT_ICON = "i.icon-mystory-assessment"
  REFLECTION_ICON = "i.icon-mystory-reflections"
  LEARN_ICON = "i.icon-gradcap"
  BACK_BTN = "button[ng-click='goBack()']"
  I_BTN = "i.icon-info"
  GOALS_ICON = "i.icon-mystory-goals"
  FROM_DATE = "input[id='startDate']"
  TO_DATE = "input[id='endDate']"
  RATE_DROPDOWN = "select[name='workingthebodycurrentSelect']"

  def initialize(driver)
    super(driver)
  end

  def setFromDate(date)
    @driver.find_element(:css, FROM_DATE).clear
    @driver.find_element(:css, FROM_DATE).send_keys(date)
  end

  def setToDate(date)
    @driver.find_element(:css, TO_DATE).clear
    @driver.find_element(:css, TO_DATE).send_keys(date)
  end

  def getFilterFormContent()
    return getElement(:css, "form[name='filterForm']").text()
  end

  def getNthMyStoryFeatureName(number)
    return getTextForElement(:css, "ul.secondary-list li:nth-of-type(" + number.to_s + ") button span")
  end

  def isSummaryIconVisible()
    return isElementVisible(:css, SUMMARY_ICON)
  end

  def isPersonalValuesIconVisible()
    return isElementVisible(:css, PERSONAL_VALUES_ICON)
  end

  def isAssessmentsIconVisible()
    return isElementVisible(:css, ASSESSMENT_ICON)
  end

  def isReflectionsIconVisible()
    return isElementVisible(:css, REFLECTION_ICON)
  end

  def isLearnIconVisible()
    return isElementVisible(:css, LEARN_ICON)
  end

  def isIBtnVisible()
    return isElementVisible(:css, I_BTN)
  end

  def isNthIconDisplayedLeftOfItem(number)
   element = getElement(:css, "div.secondary-content div:nth-of-type(2) ul li:nth-of-type(" + number.to_s + ") span div div :nth-child(1)")
   return ( element.tag_name == "i" ? true: false)
  end

  def clickSummary()
    waitForPageToFinishLoading
    click(:css, SUMMARY_ICON)
  end

  def clickPersonalValues()
    waitForPageToFinishLoading
    click(:css, PERSONAL_VALUES_ICON)
  end

  def clickAssessment()
    waitForPageToFinishLoading
    click(:css, ASSESSMENT_ICON)
  end

  def clickReflections()
    waitForPageToFinishLoading
    click(:css, REFLECTION_ICON)
  end

  def clickLearn()
    waitForPageToFinishLoading
    click(:css, LEARN_ICON)
  end

  def clickBackButton()
    waitForPageToFinishLoading
    clickJquery(BACK_BTN)
  end

  def clickIButton()
    waitForPageToFinishLoading
    click(:css, I_BTN)
  end

  def clickGoals()
    sleep(5)
    waitForPageToFinishLoading
    click(:css, GOALS_ICON)
  end

  ######  Common

  def isHistoryButtonVisible()
    isElementPresentAndVisible(:css, "nav-bar[buttons='navButtons'] div ul.nav li button[ng-click='button.onClick()']")
  end

  def clickHistoryButton()
    waitForPageToFinishLoading
    click(:css, "nav-bar[buttons='navButtons'] div ul.nav.navbar-nav button[ng-click='button.onClick()']")
  end

  def isSaveChangesDisabled()

   return isThisElementDisabled(:css, 'button[title="Save Changes"]')

  end


  def clickSaveChangesBtn()
    waitForPageToFinishLoading
    clickJquery("button[ng-click='saveChanges()']")
  end

  def getNthAccordionName(number)
    return getTextForElement(:css, "form[name='assessmentForm'] div div:nth-child(" + number.to_s + ") h4 a")
  end

  def clickAccordionByHeading(heading)
    waitForPageToFinishLoading
    click(:css, 'div[heading="' + heading + '"] i.icon-accordion-static')
    waitForPageToFinishLoading
    @driver.execute_script("$('.container-fluid').css('overflow', 'auto');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'auto');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'auto');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'auto');")
    @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
  end

  def collapseAccordionByHeading(heading)
    waitForPageToFinishLoading
    click(:css, 'div[heading="' + heading + '"] i.icon-accordion-active')
  end

  def getCollapsedAccordionLabelByHeading(heading)
    labelText = getTextForElement(:css, 'div[heading="' + heading + '"] div.panel-heading h4 a')

    label = labelText.split("Expand\n")
    return label[1]

  end

  def isAccordionCollapsed(heading)
    labelText = getTextForElement(:css, 'div[heading="' + heading + '"] div.panel-heading h4 a')

    if(labelText.include?("Expand"))
      return true
    else
      false
    end
  end

  def isRightArrowIconDisplayed(heading)
    element = getElement(:css, 'div[heading="' + heading + '"] div.panel-heading a i.myicon')
    classValue = element.attribute("class")

    if (classValue.include?("icon-accordion-static"))
      return true
    else
      return false
    end

  end

  def isDownArrowIconDisplayed(heading)
    element = getElement(:css, 'div[heading="' + heading + '"] div.panel-heading a i.myicon')
    classValue = element.attribute("class")

    if (classValue.include?("icon-accordion-active"))
      return true
    else
      return false
    end

  end


  def getAccordionAltText(heading)
    return getTextForElement(:css, 'div[heading="' + heading + '"] div.panel-heading h4 a')
  end

  def getAccordionLabelByHeading(heading)
    labelText = getTextForElement(:css, 'div[heading="' + heading + '"] div.panel-heading h4 a')
    label = labelText.split("Collapse\n")
    return label[1]
  end

  def getAccordionInfoTextByHeading(heading)
    return getTextForElement(:css,  'div[heading="' + heading + '"] div.panel-body div p.ng-binding ')
  end

  def getRateWhereYouAreLabelByHeading(heading)
    return getTextForElement(:css,  'div[heading="' + heading + '"] div.panel-body div.row div:nth-of-type(1) span.input-label-content')
  end

  def selectRateWhereYouAreByHeading(heading, rate)
    name = getElementNameByHeading(heading)
    setSelectBoxValue('div[heading="' + heading + '"] select[name="' + name + 'currentSelect"]', rate)
    @driver.execute_script("$(\"form[name='assessmentForm']\").scope().assessmentForm.$dirty = true")
    @driver.execute_script("$(\"form[name='assessmentForm']\").scope().$digest()")
    sleep 0.5
  end

  def selectWhereYouLikedToBeByHeading(heading, rate)
    name = getElementNameByHeading(heading)
    setSelectBoxValue('div[heading="' + heading + '"] select[name="' + name + 'futureSelect"]', rate)
    @driver.execute_script("$(\"form[name='assessmentForm']\").scope().assessmentForm.$dirty = true")
    @driver.execute_script("$(\"form[name='assessmentForm']\").scope().$digest()")
    sleep 0.5
  end

  def getRateWhereYouAreValueByHeading(heading)
    name = getElementNameByHeading(heading)
    return getSelectBoxText('div[heading="' + heading + '"] select[name="' + name + 'currentSelect"]')
  end

  def getWhereYouLikedToBeByHeading(heading)
    name = getElementNameByHeading(heading)
    return getSelectBoxText('div[heading="' + heading + '"] select[name="' + name + 'futureSelect"]')
  end

  def getWhatAreTheReasonsLabelByHeading(heading)
    return getTextForElement(:css,  'div[heading="' + heading + '"] div.panel-body div.row div:nth-of-type(2) span')
  end

  def getWhereYouLikedToBeLabelByHeading(heading)
    return getTextForElement(:css,  'div[heading="' + heading + '"] div.panel-body div.row div:nth-of-type(3) span')
  end

  def getWhatChangesYouCanMakeLabelByHeading(heading)
    return getTextForElement(:css,  'div[heading="' + heading + '"] div.panel-body div.row div:nth-of-type(4) span')
  end

  def setReasonsByHeading(heading, text)
    name = getElementNameByHeading(heading)
    @driver.find_element(:css, 'div[heading="' + heading + '"] textarea[name="' + name + 'currentText"]').clear
    @driver.find_element(:css, 'div[heading="' + heading + '"] textarea[name="' + name + 'currentText"]').send_keys(text)
    sleep 0.2
  end

  def getReasonByHeading(heading)
    name = getElementNameByHeading(heading)
    return getTextFromInput(:css, 'div[heading="' + heading + '"] textarea[name="' + name + 'currentText"]')
  end

  def getElementNameByHeading(heading)
    if heading == "Family, Friends, and Co-Workers"
      name = "familyfriendcoworker"
    elsif heading =="Power of the Mind"
      name = "powerofmind"
    else
      name = (heading.gsub(/\s+/, "")).downcase
      name = name.gsub(/\,/,"")
      name = name.gsub(/\-/,"")
    end

    return name
  end

  def setWhatChangesByHeading(heading, text)
    name = getElementNameByHeading(heading)
    @driver.find_element(:css, 'div[heading="' + heading + '"] textarea[name="' + name +'futureText"]').clear
    @driver.find_element(:css, 'div[heading="' + heading + '"] textarea[name="' + name + 'futureText"]').send_keys(text)
    sleep 0.3
  end

  def getWhatChangesByHeading(heading)
    name = getElementNameByHeading(heading)
    return getTextFromInput(:css, 'div[heading="' + heading + '"] textarea[name="' + name +'futureText"]')
  end

  def getCountDownDisplayForReasons(heading)
    return getTextForElement(:css, 'div[heading="' + heading + '"]  div.row div:nth-of-type(2) span[ng-if="characterCounter"]')

  end

  def getCountDownDisplayForWhatChanges(heading)
    return getTextForElement(:css, 'div[heading="' + heading + '"]  div.row div:nth-of-type(4) span[ng-if="characterCounter"]')

  end

  def getLastUpdatedDateByHeading(heading)
    return getTextForElement(:css, 'div[heading="' + heading + '"]  div.panel-heading h4 div.line-subtext')
  end

  ######  End of Common



  ####Personal Values
  def getWhatReallyQuestionLabelInPersonalValues()
    return getTextForElement(:css, '.row > div:nth-of-type(1) span.input-label-content')
  end

  def getSenseOfJoyQuestionLabelInPersonalValues()
    return getTextForElement(:css, '.row > div:nth-of-type(2) span.input-label-content')
  end

  def setWhatReallyQuestionInPersonalValues(text)
    @driver.find_element(:css, "textarea[name='what']").clear
    @driver.find_element(:css, "textarea[name='what']").send_keys(text)
    sleep 0.5
  end

  def moveFocusToSenseOfJoyQuestionTextArea()
    executeJavaScript("document.getElementById('joy').focus();")
  end

  def setSenseOfJoyQuestionInPersonalValues(text)
    @driver.find_element(:css, "textarea[name='joy']").clear
    @driver.find_element(:css, "textarea[name='joy']").send_keys(text)
    sleep 0.2
  end

  def getWhatReallyQuestionInPersonalValues()
    return getTextFromInput(:css, "textarea[name='what']")
  end

  def getCountDownTextForWhatReallyQuestionInPersonalValues()
    return getTextForElement(:css, '.row > div:nth-of-type(1) span.character-counter')
  end

  def getCountDownTextForSenseOfJoyQuestionInPersonalValues()
    return getTextForElement(:css, '.row > div:nth-of-type(2) span.character-counter')
  end

  def getSenseOfJoyQuestionInPersonalValues()
    return getTextFromInput(:css, "textarea[name='joy']")
  end

  def isWhatReallyGuidanceTextPresent()
    element = getElement(:css, '.row > div:nth-of-type(1) span.input-label-content')
    attribute = element.attribute("placeholder")

    if attribute == nil
      return false
    else
      return true
    end

  end

  def isSenseOfJoyGuidanceTextPresent()
    element = getElement(:css, '.row > div:nth-of-type(2) span.input-label-content')
    attribute = element.attribute("placeholder")

    if attribute == nil
      return false
    else
      return true
    end

  end

  def getWhatReallyLastUpdatedDate()
     return getTextForElement(:css, "[name='what'] .input-text-label-date")
  end

  def getSenseOfJoyLastUpatedDate()
    return getTextForElement(:css, "[name='joy'] .input-text-label-date")
  end
####End of Personal Values


###########  Reflection
  def getNowThatQuestionInReflection()
    return getTextForElement(:css, 'span[name="healthLabel"]')
  end

  def setNowThatQuestionInReflectionValue(text)
    @driver.find_element(:css, "textarea[name='health']").clear
    @driver.find_element(:css, "textarea[name='health']").send_keys(text)
  end

  def getNowThatQuestionInReflectionValue()
    return getTextFromInput(:css, "textarea[name='health']")
  end

  def getCountDownTextForNowThat()
    return getTextForElement(:css, 'span.character-counter')
  end

  def getNowThatLastUpdatedDate()
    return getTextForElement(:css, "span.input-text-label-date")
  end

##########  End of Reflection


########### Well-Being Assessments

  def clickWellBeing()
    waitForPageToFinishLoading
    click(:css, 'div[heading="Well-being"] i.icon-accordion-static')
  end


  def selectPhysicalWellBeing(rating)
    setSelectBoxValue("select[name='physicalSelect']", rating)
  end

  def selectMentalWellBeing(rating)
    setSelectBoxValue("select[name='mentalSelect']", rating)
  end

  def selectDayToDayLife(rating)
    setSelectBoxValue("select[name='lifeSelect']", rating)
  end

  def getPhysicalWellBeingValue()
    return getSelectedOptionValue(:css,  "select[name='physicalSelect']")
  end

  def getMentalWellBeingValue()
    return getSelectedOptionValue(:css,  "select[name='mentalSelect']")
  end

  def getDayToDayLifeValue()
    return getSelectedOptionValue(:css, "select[name='lifeSelect']")
  end

  def getWellBeing_LastUpdatedDate()
    begin
      element = getElement(:css, 'div[heading="Well-being"] div.panel-heading h4 div.line-subtext')
      return element.text
    rescue Exception => e
      return ""
    end
  end

  def getWellBeingInfoText()
    return getTextForElement(:css, "div[heading='Well-being'] div.panel-body div.ng-scope p:nth-of-type(1)")
  end

  def getWellBeingHotLineInfoText()
    return getTextForElement(:css, "div[heading='Well-being'] div.panel-body div.ng-scope p:nth-of-type(2)")
  end

  def isWellBeingAccordion_Expanded()
    element = getElement(:css, "div[heading='Well-being'] div.panel-heading h4 a")
    expanded = element.attribute("aria-expanded")


    if(expanded == "true")
      return true
    else
      return false
    end
  end
########## End of Well-Being Assessments



########### Working the Body

  def clickWorkingBody()
    click(:css, 'div[heading="Working the body"] i.icon-accordion-static')
  end

########### End of Working the Body

########### Recharge
  def clickRecharge()
    click(:css, 'div[heading="Recharge"] i.icon-accordion-static')
  end

########### End of Recharge

###### Food and Drink
  def clickFoodAndDrink()
    click(:css, 'div[heading="Food and Drink"] i.icon-accordion-static')
  end
##### End of Food and Drink

####  Begin Personal Development
  def clickPersonalDevelopment()
    click(:css, 'div[heading="Personal Development"] i.icon-accordion-static')
  end

######  End of Personal Development


##### Begin Family, Friends and Co-workers
  def clickFamilyFriendsAndCoWorkers()
    click(:css, 'div[heading="Family, Friends, and Co-Workers"] i.icon-accordion-static')
  end

#### End of Family Friends Coworkers


##### Begin Spirit and Soul
  def clickSpiritAndSoul()
    click(:css, 'div[heading="Sprit and Soul"] i.icon-accordion-static')
  end

####  End of Sprit and Soul

##### Begin Surroundings

  def clickSurroundings()
    click(:css, 'div[heading="Surroundings"] i.icon-accordion-static')
  end
#####  End of Surroundings

### Begin Power of the Mind

  def clickPowerOfMind()
    click(:css, 'div[heading="Power of the Mind"] i.icon-accordion-static')
  end
#### End of the Power of the Mind

#### Begin Professional Care

  def clickProfessionalCare()
    click(:css, 'div[heading="Professional Care"] i.icon-accordion-static')
  end

  def getPreventionQuestionLabel()
    getTextForElement(:css, "div[heading='Professional Care'] input-select[name='lifeSelect'] label span")
  end

  def getWorkingWithProfessionalQuestionLabel()
    getTextForElement(:css, "div[heading='Professional Care'] input-select[name='workingWithProfessional'] label span")
  end

  def getClinicalCareQuestionLabel()
    getTextForElement(:css, "div[heading='Professional Care'] input-select[name='clinicalSelect'] label span")
  end

  def selectPreventionForProfCare(rating)
    select = getElement(:css, "div[heading='Professional Care'] select[name='lifeSelect']")
    options = select.find_elements(:tag_name, "option")

    options.each do |option|
      if(option.attribute('value') == rating.to_s)
        option.click
        break
      end
    end
  end

  def getPreventionForProCareValue()
    return getSelectedOptionValue(:css,  "div[heading='Professional Care'] select[name='lifeSelect']")
  end

  def selectWorkingWithProfessional(yesOrNo)
    select = getElement(:css, "div[heading='Professional Care'] select[name='workingWithProfessional']")
    options = select.find_elements(:tag_name, "option")
    options.each do |option|
      if(option.attribute('value') == yesOrNo.to_s)
        option.click
        break
      end
    end
  end

  def getWorkingWithProfessionalValue()
    return getSelectedOptionValue(:css,  "div[heading='Professional Care'] select[name='workingWithProfessional']")
  end

  def selectClinicalCare(rating)
    select = getElement(:css, "div[heading='Professional Care'] select[name='clinicalSelect']")
    options = select.find_elements(:tag_name, "option")
    options.each do |option|
      if(option.attribute('value') == rating.to_s)
        option.click
        break
      end
    end
  end

  def getClinicalCareValue()
    return getSelectedOptionValue(:css,  "div[heading='Professional Care'] select[name='clinicalSelect']")
  end

  def getLastUpdatedDateForProfCare()
    return getTextForElement(:css, "div[heading='Professional Care'] div.panel-heading h4 div.line-subtext")
  end

  def isClinicalCareQuestionPresent()
    return is_element_present(:css, "div[heading='Professional Care'] input-select[name='clinicalSelect'] label span")
  end

####  End of Professional Care


end