require_relative  "../../module/DriverUtility"

class Goal_Notification
  include DriverUtility

  START_DATE = "div[notification-delivery-options] input[name='notificationStartDate']"
  NOTIFY_ME = "select[name='notificationFrequency']"

  def initialize(driver)
    @driver = driver
  end

  def getNotificationStartDate()
    getTextFromInput(:css, START_DATE)
  end

  def getNotifyMe()
    getSelectedOptionValue(:css, NOTIFY_ME)
  end

  def getNotificationLabel()
    getTextForElement(:css, "div[notification-delivery-options] div legend")
  end

  def getNotificationStartDateGuidanceText()
    return getPlaceHolderByCSS(:css, START_DATE)
  end

  def getNotificationEmailAddress()
    getTextForElement(:css, "div.email")
  end

  def getEmailGuidanceText()
    getTextForElement(:css, "div[notification-delivery-options] div div.col-xs-11 span:nth-of-type(2)")
  end

  def getNotificationStatusNthOptionText(number)
    getTextForElement(:css, "div[notification-delivery-options] div span:nth-of-type(" + number.to_s + ") label")
  end

  def getNotificationStatusNthOptionValue(number)
    element = getElement(:css, "div[notification-delivery-options] div span:nth-of-type(" + number.to_s + ") input[name='notificationOption']")
    value = element.attribute("value")
    return value
  end

  def isNotificationStatusOptionSelected(value)
    isThisRadioButtonOrCheckBoxSelected("radio", value, "notificationOption")
  end

  def isInAppCheckboxChecked()
    isThisRadioButtonOrCheckBoxSelected("checkbox", "In-App", "notificationDelivery")
  end

  def isSeparatorBarPresent()
    isElementPresentAndVisible(:css, "form[name='form'] div:nth-of-type(1) hr")

  end

  def isNotificationStartDateFieldDisabled()
    isThisElementDisabled(:css, START_DATE)
  end

  def isNotifyMeFieldDisabled()
    isThisElementDisabled(:css, NOTIFY_ME)
  end

  def isNotificationDeliveryFieldDisabled(value)
    isThisElementDisabled(:css, "input[name='notificationDelivery'][value='" + value + "']")
  end

  def isNotificationStartDateFieldRequired()
    isFieldRequired(:css, START_DATE)
  end

  def isNotifyMeFieldRequired()
    isFieldRequired(:css, NOTIFY_ME)
  end

  def isNotificationDeliveryMethodRequired()
    text = getTextForElement(:css, "div.notification-delivery legend span.required-field")
    if text == "*"
      return true
    else
      return false
    end
  end

  def isNotificationIconPresent()
    isElementPresentAndVisible(:css, "div[notification-delivery-options] div legend i.icon-notification")
  end

  def areAllTheseValuesAvailableInNotifyMeList(valueString)
      return areAllTheseValuesAvailableInDropDown(NOTIFY_ME, valueString)
  end

  def setNotificationStartDate(text)
    @driver.find_element(:css, START_DATE).clear
    @driver.find_element(:css, START_DATE).send_keys(text)
    sleep 0.2
  end

  def selectNotificationStatus(status)
    if (status == "On")
      click(:css, "input[type='radio'][value='On']")
    elsif status == "Off"
      click(:css, "input[type='radio'][value='Off']")
    end
  end

  def selectNotifyMe(value)
    waitForPageToFinishLoading
    setSelectBoxValue(NOTIFY_ME, value)
  end

  def setNotificationDeliveryOption(value)
    click(:css, "input[name='notificationDelivery'][value='" + value + "']")
  end


end