require 'rubygems'
require 'selenium-webdriver'
require 'rspec'


require_relative '../../module/DriverUtility'
require_relative '../../helpers/entry_form'
require_relative '../../pages/screening'
require_relative '../../pages/reminders'

class PreventiveServices < EntryForm
  LAST_ADMINISTERED_DATE_TEXTFIELD = "input[id='lastAdministered']"
  LAST_COMPLETED_DATE_TEXTFIELD = "input[id='lastCompleted']"
  LAST_TESTED_DATE_TEXTFIELD =  "input[id='lastCompleted']"
  LAST_TAKEN_DATE_TEXTFIELD = "input[id='lastCompleted']"
  NEXT_DUE_DATE_TEXTFIELD = "input[id='nextDueDate']"
  RESULTS_DROPDOWN = "select[name='result']"
  VACCINATION_1_ADMINISTERED_TEXTFIELD = "input[id='administered-1']"
  VACCINATION_2_ADMINISTERED_TEXTFIELD = "input[id='administered-2']"
  VACCINATION_3_ADMINISTERED_TEXTFIELD = "input[id='administered-3']"


  include DriverUtility


  def initialize(driver)
    super(driver)
    @screening_instance=Screening.new(driver)
    @reminders_instance=Reminders.new(driver)
  end

  def clickCustomCreatedService
    indexID = @screening_instance.findIndexWithGivenPSName("Custom Created Service")
    waitForPageToFinishLoading
    @reminders_instance.clickNthReminder(indexID)
  end

  def clickTetanusVaccination
    indexID = @screening_instance.findIndexWithGivenPSName("Tetanus Vaccination")
    waitForPageToFinishLoading
    @reminders_instance.clickNthReminder(indexID)
  end

  def clickBloodPressureScreening
    indexID = @screening_instance.findIndexWithGivenPSName("Blood Pressure Screening")
    waitForPageToFinishLoading
    @reminders_instance.clickNthReminder(indexID)
  end

  def clickCholesterolScreening
    indexID = @screening_instance.findIndexWithGivenPSName("Cholesterol Screening")
    waitForPageToFinishLoading
    @reminders_instance.clickNthReminder(indexID)
  end

  def clickShinglesVaccination
    indexID = @screening_instance.findIndexWithGivenPSName("Shingles Vaccination")
    waitForPageToFinishLoading
    @reminders_instance.clickNthReminder(indexID)
  end

  def clickPCV13PneumococcalVaccination
    indexID = @screening_instance.findIndexWithGivenPSName("PCV13 - Pneumococcal Vaccination")
    waitForPageToFinishLoading
    @reminders_instance.clickNthReminder(indexID)
  end

  def clickPPSV23PneumococcalVaccination
    indexID = @screening_instance.findIndexWithGivenPSName("PPSV23 - Pneumococcal Vaccination")
    waitForPageToFinishLoading
    @reminders_instance.clickNthReminder(indexID)
  end

  def clickFluVaccination
    indexID = @screening_instance.findIndexWithGivenPSName("Flu Vaccination")
    waitForPageToFinishLoading
    @reminders_instance.clickNthReminder(indexID)
  end

  def clickColorectalCancerScreening
    indexID = @screening_instance.findIndexWithGivenPSName("Colorectal Cancer Screening")
    waitForPageToFinishLoading
    @reminders_instance.clickNthReminder(indexID)
  end

  def clickHIVVaccination
    indexID = @screening_instance.findIndexWithGivenPSName("HIV Screening")
    waitForPageToFinishLoading
    @reminders_instance.clickNthReminder(indexID)
  end

  def clickHPVVaccination
    indexID = @screening_instance.findIndexWithGivenPSName("HPV Vaccination")
    waitForPageToFinishLoading
    @reminders_instance.clickNthReminder(indexID)
  end


  def getHealthFinderText
    return getTextForElement(:css, "div[ui-view='primary'] span.placeholder-message")
  end

  def getHealthFinderLinkText
    return getTextForElement(:css, "div[ui-view='primary'] span.placeholder-message > a")
  end

  def clickLink
    return click(:css, "a[ng-click='goToHealthFinder()']")
  end

  def isUrlCorrect?
    urlLink = @driver.current_url
    return urlLink.include?("http://healthfinder.gov/")
  end

  def isUrlGenderMale?
    urlLink = @driver.current_url
    return urlLink.include?("gender=male")
  end

  def isUrlGenderFemale?
    urlLink = @driver.current_url
    return urlLink.include?("gender=female")
  end

  def isUrlPregnantFalse?
    urlLink = @driver.current_url
    return urlLink.include?("pregnant=0")
  end

  def isUrlPregnantTrue?
    urlLink = @driver.current_url
    return urlLink.include?("pregnant=1")
  end

  def setLastAdministeredDate(date)
    waitForPageToFinishLoading
    @driver.find_element(:css, LAST_ADMINISTERED_DATE_TEXTFIELD).clear
    @driver.find_element(:css, LAST_ADMINISTERED_DATE_TEXTFIELD).send_keys(date)
  end

  def setNextDueDate(date)
    waitForPageToFinishLoading
    @driver.find_element(:css, NEXT_DUE_DATE_TEXTFIELD).clear
    @driver.find_element(:css, NEXT_DUE_DATE_TEXTFIELD).send_keys(date)
  end

  def setLastTakenDate(date)
    waitForPageToFinishLoading
    @driver.find_element(:css, LAST_TAKEN_DATE_TEXTFIELD).clear
    @driver.find_element(:css, LAST_TAKEN_DATE_TEXTFIELD).send_keys(date)
  end

  def setLastCompletedDate(date)
    waitForPageToFinishLoading
    @driver.find_element(:css, LAST_COMPLETED_DATE_TEXTFIELD).clear
    @driver.find_element(:css, LAST_COMPLETED_DATE_TEXTFIELD).send_keys(date)
  end

  def setLastTestedDate(date)
    waitForPageToFinishLoading
    @driver.find_element(:css, LAST_TESTED_DATE_TEXTFIELD).clear
    @driver.find_element(:css, LAST_TESTED_DATE_TEXTFIELD).send_keys(date)
  end

  def selectResults(value)
    waitForPageToFinishLoading
    setSelectBoxValue(RESULTS_DROPDOWN, value)
  end

  def setVaccination1Administered(date)
    waitForPageToFinishLoading
    @driver.find_element(:css, VACCINATION_1_ADMINISTERED_TEXTFIELD).clear
    @driver.find_element(:css, VACCINATION_1_ADMINISTERED_TEXTFIELD).send_keys(date)
  end

  def setVaccination2Administered(date)
    waitForPageToFinishLoading
    @driver.find_element(:css, VACCINATION_2_ADMINISTERED_TEXTFIELD).clear
    @driver.find_element(:css, VACCINATION_2_ADMINISTERED_TEXTFIELD).send_keys(date)
  end

  def setVaccination3Administered(date)
    waitForPageToFinishLoading
    @driver.find_element(:css, VACCINATION_3_ADMINISTERED_TEXTFIELD).clear
    @driver.find_element(:css, VACCINATION_3_ADMINISTERED_TEXTFIELD).send_keys(date)
  end
end