require 'rubygems'
require 'selenium-webdriver'

require_relative  '../../helpers/entry_form'

class Appointments < EntryForm

  CLINIC_ORGANIZATION_TEXTFIELD = "input[name='clinic']"
  APPOINTMENT_DATE_TEXTFIELD = "input[name='date']"
  APPOINTMENT_TIME_TEXTFIELD = "input[name='time']"

  def initialize(driver)
    super(driver)
  end

  def setAppointmentDate(date)
    setInput(APPOINTMENT_DATE_TEXTFIELD,date)
  end

  def setAppointmentTime(time)
    setInput(APPOINTMENT_TIME_TEXTFIELD,time)
  end

  def setClinicOrOrganizationName(name)
    setInput(CLINIC_ORGANIZATION_TEXTFIELD,name)
  end

end