require 'rubygems'
require 'selenium-webdriver'

require_relative "../../helpers/entry_form"

class OccupationalHistory < EntryForm

  EVENT_TITLE = "input[name='eventTitle']"
  EVENT_DATE = "input[name='date']"
  RECORD_DETAILS_ABOUT_YOUR_EXPOSURE = "textarea[name='exposure']"
  EVENT_DATE_BUTTON = "div[name='date'] > div > div > span > button"
  SERVICE_BRANCH = "select[name='serviceBranch']"
  SERVICE_LOCATION = "select[name='serviceLocation']"
  ASSIGNMENT = "input[name='assignment']"
  INJURY_FLAG_YES = "input[name='injuryFlag'][value=true]"
  INJURY_FLAG_NO = "input[name='injuryFlag'][value=false]"
  INJURY = "textarea[name='injury']"
  INJURY_CHARACTER_COUNTER = ".row:nth-of-type(8) > div span[ng-if='characterCounter']"
  EXPOSURE_FLAG_YES = "input[name='exposureFlag'][value=true]"
  EXPOSURE_FLAG_NO = "input[name='exposureFlag'][value=false]"
  EXPOSURE = "textarea[name='exposure']"
  EXPOSURE_CHARACTER_COUNTER = ".row:nth-of-type(10) > div span[ng-if='characterCounter']"
  MILITARY_FLAG_YES = "input[name='militaryFlag'][value=true]"
  MILITARY_FLAG_NO = "input[name='militaryFlag'][value=false]"
  MILITARY_SERVICE = "textarea[name='militaryService']"
  MILITARY_SERVICE_CHARACTER_COUNTER = ".row:nth-of-type(12) > div span[ng-if='characterCounter']"
  HEADER = "Military/Occupational History"
  ADD_HEADER = "Add Military/Occupational History Entry"
  EDIT_HEADER = "Edit Military/Occupational History Entry"



  def initialize(driver)
    super(driver);
  end

  def getScreenContent()
    return getElement(:css, "form[name='form']").text()
  end

  def setEventTitle(event_title)
    setInput(EVENT_TITLE,event_title)
  end

  def setExposureRadioButton(yes_no)
    if yes_no == 'yes'
    click(:css,EXPOSURE_FLAG_YES)
    elsif yes_no == 'no'
    click(:css,EXPOSURE_FLAG_NO)
    end
  end

  def setRecordDetailsAboutYourExposure(details)
    setInput(RECORD_DETAILS_ABOUT_YOUR_EXPOSURE,details)
  end

end