require 'rubygems'
require 'selenium-webdriver'

require_relative "../../helpers/entry_form"

class Symptom < EntryForm

  DESCRIPTION = "input[name='name']"
  SYMPTOM_DATE = "input[name='date']"
  SYMPTOM_DATE_BUTTON = "div[name='date'] > div > div > span > button"
  SYMPTOM_TIME = "input[name='time']"
  SYMPTOM_TIME_BUTTON = "div[name='time'] > div > div > span > button"
  DURATION_HOURS = "select[name='hours']"
  DURATION_MINUTES = "select[name='minutes']"
  INTENSITY = "intensity"
  TRIGGER = "textarea[name='trigger']"
  TRIGGER_CHARACTER_COUNTER = "[name='trigger'] span[ng-if='characterCounter']"
  TREATMENT = "textarea[name='treatment']"
  TREATMENT_CHARACTER_COUNTER = "[name='treatment'] span[ng-if='characterCounter']"
  RESPONSE = "textarea[name='response']"
  RESPONSE_CHARACTER_COUNTER = "[name='response'] span[ng-if='characterCounter']"
  NOTES = "textarea[name='notes']"
  NOTES_CHARACTER_COUNTER = "[name='notes'] span[ng-if='characterCounter']"
  HEADER = "Symptom Diary"
  ADD_HEADER = "Add Symptom Diary Entry"
  EDIT_HEADER = "Edit Symptom Diary Entry"

  SYMPTOM_NAME_TEXTFIELD = ".form-control.ng-pristine.ng-scope.ng-empty.ng-invalid"

  FROM_DATE = "input[id='startDate']"
  TO_DATE = "input[id='endDate']"


  def initialize(driver)
    super(driver);
  end

  def enterSymptomName(text)
    waitForPageToFinishLoading
    setInput(SYMPTOM_NAME_TEXTFIELD,text)
  end

  def getScreenContent()
    return getElement(:css, "form[name='form']").text()
  end

  def getSymptomName()
    return getElement(:css, DESCRIPTION).attribute("value")
  end

  def getSymptomNameElement()
    return getElement(:css, DESCRIPTION)
  end

  def moveIntensityBarToRight(number)
    moveArrowInputRangeToRight("intensity", number)
  end

  def setFromDate(date)
    @driver.find_element(:css, FROM_DATE).clear
    @driver.find_element(:css, FROM_DATE).send_keys(date)
  end

  def setToDate(date)
    @driver.find_element(:css, TO_DATE).clear
    @driver.find_element(:css, TO_DATE).send_keys(date)
  end

end