require 'rubygems'
require 'selenium-webdriver'

require_relative  "../../module/DriverUtility"
require_relative  "../../helpers/entry_form"

class Pregnancy_History < EntryForm
  include DriverUtility

  PREGNANCY_NUMBER = "input[name='number']"
  PREGNANCY_DATE_STARTED = "date-control[name='dateStarted'] input.date-input"
  LAST_MENSTRUAL_DATE = "date-control[name='lastPeriod'] input.date-input"
  OUTCOME_DATE = "date-control[name='outcomeDate'] input.date-input"
  OUTCOME = "select[name='outcome']"
  HOSPITAL_NAME = "input[name='hospitalName']"
  NOTE = "textarea[name='Notes']"
  NOTE_CHARACTER_COUNTER = "span.character-counter"
  OTHER = "input[name='other']"

  INFANT_NAME_1 = "input[name='name_1']"
  SEX_FEMALE_1 = "input[name='sex_0'][value='Female']"
  SEX_MALE_1 = "input[name='sex_0'][value='Male']"
  POUND_1 = "input[name='pounds_1']"
  OUNCES_1 = "input[name='ounces_1']"
  LENGTH_1 = "input[name='length_1']"

  INFANT_NAME_2 = "input[name='name_2']"
  SEX_FEMALE_2 = "input[name='sex_1'][value='Female']"
  SEX_MALE_2 = "input[name='sex_1'][value='Male']"
  POUND_2 = "input[name='pounds_2']"
  OUNCES_2 = "input[name='ounces_2']"
  LENGTH_2 = "input[name='length_2']"

  ADD_TWIN_BUTTON = "button[ng-click='addInfant()']"
  DELETE_TWIN_BUTTON_1 = "button[name='deleteInfant_1']"
  DELETE_TWIN_BUTTON_2 =  "button[name='deleteInfant_2']"


  def initialize(driver)
    @driver = driver
  end

  ###Setters
  def setPregnancyNumber(number)
    @driver.find_element(:css, PREGNANCY_NUMBER).clear
    @driver.find_element(:css, PREGNANCY_NUMBER).send_keys(number)
  end

  def setPregnancyStartedDate(date)
    @driver.find_element(:css, PREGNANCY_DATE_STARTED).clear
    @driver.find_element(:css, PREGNANCY_DATE_STARTED).send_keys(date)
  end

  def setLastMenstrualDate(date)
    @driver.find_element(:css, LAST_MENSTRUAL_DATE).clear
    @driver.find_element(:css, LAST_MENSTRUAL_DATE).send_keys(date)
  end

  def setOutcomeDate(date)
    @driver.find_element(:css, OUTCOME_DATE).clear
    @driver.find_element(:css, OUTCOME_DATE).send_keys(date)
  end

  def selectOutcome(outcome)
    select = getElement(:css, OUTCOME)
    options = select.find_elements(:tag_name, "option")
    options.each do |option|
      if(option.attribute('value') == outcome)
        option.click
        break
      end
    end
  end

  def setHospitalName(name)
    @driver.find_element(:css, HOSPITAL_NAME).clear
    @driver.find_element(:css, HOSPITAL_NAME).send_keys(name)
  end

  def setNote(note)
    @driver.find_element(:css, NOTE).clear
    @driver.find_element(:css, NOTE).send_keys(note)
  end

  def setOther(other)
    @driver.find_element(:css, OTHER).clear
    @driver.find_element(:css, OTHER).send_keys(other)
  end

  def setName_1(name)
    @driver.find_element(:css, INFANT_NAME_1).clear
    @driver.find_element(:css, INFANT_NAME_1).send_keys(name)
  end

  def setSex_1(gender)
    click(:css, "div div.col-xs-12 div.infant:nth-of-type(1) fieldset input[type='radio'][value='" + gender + "']")
  end

  def setPounds_1(pound)
    @driver.find_element(:css, POUND_1).clear
    @driver.find_element(:css, POUND_1).send_keys(pound)
  end

  def setOunces_1(oz)
    @driver.find_element(:css, OUNCES_1).clear
    @driver.find_element(:css, OUNCES_1).send_keys(oz)
  end

  def setLength_1(length)
    @driver.find_element(:css, LENGTH_1).clear
    @driver.find_element(:css, LENGTH_1).send_keys(length)
  end

  def setName_2(name)
    @driver.find_element(:css, INFANT_NAME_2).clear
    @driver.find_element(:css, INFANT_NAME_2).send_keys(name)
  end

  def setSex_2(gender)
    click(:css, "div div.col-xs-12 div.infant:nth-of-type(2) fieldset input[type='radio'][value='" + gender + "']")
  end

  def setPounds_2(pound)
    @driver.find_element(:css, POUND_2).clear
    @driver.find_element(:css, POUND_2).send_keys(pound)
  end

  def setOunces_2(oz)
    @driver.find_element(:css, OUNCES_2).clear
    @driver.find_element(:css, OUNCES_2).send_keys(oz)
  end

  def setLength_2(length)
    @driver.find_element(:css, LENGTH_2).clear
    @driver.find_element(:css, LENGTH_2).send_keys(length)
  end



  ###Getters
  def getPregnancyNumber()
    getTextFromInput(:css, PREGNANCY_NUMBER)
  end

  def getPregnancyStartedDate()
    getTextFromInput(:css, PREGNANCY_DATE_STARTED)
  end

  def getLastMenstrualDate()
    getTextFromInput(:css, LAST_MENSTRUAL_DATE)
  end

  def getOutcome()
    getSelectedOptionValue(:css, OUTCOME)
  end

  def getOutcomeDate()
    getTextFromInput(:css, OUTCOME_DATE)
  end

  def getHospitalName()
    getTextFromInput(:css, HOSPITAL_NAME)
  end

  def getOther()
    getTextFromInput(:css, OTHER)
  end

  def getNote()
    getTextFromInput(:css, NOTE)
  end

  def getName_1()
    getTextFromInput(:css, INFANT_NAME_1)
  end

  def getPounds_1()
    getTextFromInput(:css, POUND_1)
  end

  def getOunces_1()
    getTextFromInput(:css, OUNCES_1)
  end

  def getLength_1()
    getTextFromInput(:css, LENGTH_1)
  end

  def getName_2()
    getTextFromInput(:css, INFANT_NAME_2)
  end

  def getPounds_2()
    getTextFromInput(:css, POUND_2)
  end

  def getOunces_2()
    getTextFromInput(:css, OUNCES_2)
  end

  def getLength_2()
    getTextFromInput(:css, LENGTH_2)
  end

  def getScreenContent()
    return getElement(:css, "form[name='form']").text()
  end

  def getFirstInfantDetailLabel()
    getTextForElement(:css, "div.infant:nth-of-type(1) legend span")
  end

  def getSecondInfantDetailLabel()
    getTextForElement(:css, "div.infant:nth-of-type(2) legend span")
  end

  def getCharacterCounter()
    getTextForElement(:css, NOTE_CHARACTER_COUNTER)
  end

  ###Clickers

  def clickAddTwin()
    click(:css, ADD_TWIN_BUTTON)
  end

  def clickDeleteNthInfantButton(number)
    if (number == 1)
      click(:css, DELETE_TWIN_BUTTON_1)
    else ##number = 2
      click(:css, DELETE_TWIN_BUTTON_2)
    end
  end

  def isGenderRadioButtonSelected(cssPath)
    element = getElement(:css, cssPath)
    return element.selected?
  end



end