require 'rubygems'
require 'selenium-webdriver'

require_relative  "../../module/DriverUtility"
require_relative  "../../helpers/table"
require_relative  "../../helpers/filter"

class Plan_Your_Appointment_List

  include DriverUtility
  include Table

  STATUS_LABEL = "span[name='planAppointmentStatusLabel']"
  STATUS = "select[name='planAppointmentStatus']"
  BLANK_PDF_ICON = "i.icon-doc"
  PRINT_BLANK_FORM_BUTTON = "button[title='Print Blank Form']"

  def initialize(driver)
    @driver = driver
  end

  def clickNthEntry(number)
    click(:css, "div.list-table ul li:nth-of-type(" + number.to_s + ")")
  end

  def selectStatus(status)
    select = getElement(:css, STATUS)
    options = select.find_elements(:tag_name, "option")
    options.each do |option|
      if(option.attribute('value') == status)
        option.click
        break
      end
    end
  end

  def getStatus()
    getSelectedOptionValue(:css, STATUS)
  end


  def findIndexWithGivenClinic(clinic)
    begin
      cnt = getElements(:css, "div.list-table ul li").length
      puts "count "  + cnt.to_s

      index = -1

      for i in 1..cnt

        clinicName = getTextForElement(:css, "div.list-table ul li:nth-of-type(" + i.to_s + ") span:nth-child(1) span span.cell-content")
        puts "clinic name "  + clinicName

        if clinicName == clinic then
          index = i
          break
        end
      end

    rescue Exception => e
      return -1
    end

    return index
  end


  def verifyEmbeddedPDF()
    urlLink = @driver.current_url
    puts "PDF URL is " + urlLink

    return urlLink.include?('.pdf')

  end

end