require 'rubygems'
require 'selenium-webdriver'
require 'active_support/time'

require_relative  "../../module/DriverUtility"
require_relative  "../../helpers/accordion"
require_relative "../../helpers/entry_form"

class Plan_Your_Appointment < Accordion
  include DriverUtility

  BACK_BUTTON = "button[ng-click='goBack()']"
  DELETE_BUTTON = "button[title='Delete']"
  VIEW_PDF_BUTTON = "button[title='View PDF']"

  APPOINTMENT_INFORMATION_HEADING = "Appointment Information"
  ITEMS_TO_DISCUSS_HEADING = "Items to Discuss"
  AFTER_APPOINTMENT_NOTES_HEADING = "After Appointment Notes"

  BOOKED_VA_APPOINTMENT_BUTTON = "button[ng-click='viewBookedAppointments()']"

  APPOINTMENT_STATUS_SELECT = "select[name='statusSelect']"
  APPOINTMENT_DATE_INPUT = "input[name='date']"
  APPOINTMENT_TIME_INPUT = "input[name='time']"
  PROVIDER_FIRST_NAME = "input[name='providerFirstName']"
  PROVIDER_LAST_NAME = "input[name='providerLastName']"
  PROVIDER_FIRST_NAME_LABEL = "span[name='providerFirstNameLabel']"
  PROVIDER_LAST_NAME_LABEL = "span[name='providerLastNameLabel']"
  CLINIC_NAME = "input[name='clinicName']"
  APPOINTMENT_REASON = "input[name='reason']"
  CLINIC_NAME_LABEL = "span[name='clinicNameLabel']"
  APPOINTMENT_REASON_LABEL = "span[name='reasonLabel']"
  PROVIDER_LABEL = "div.row div.col-xs-12.margin-bottom strong"

  ITEMS_DISCUSS_INSTRUCTION_TEXT = "#aa2 p:first-child"
  TALK_ABOUT_LABEL = "span[name='talkAboutLabel']"
  TALK_ABOUT_TEXTAREA = "textarea[name='talkAbout']"

  SYMPTOMS_RADIO = "input[name='symptomsFlag']"
  MEDICATIONS_QUESTION_RADIO = "input[name='medicationsFlag']"
  DIAGNOSIS_QUESTION_RADIO = "input[name='diagnosesFlag']"
  TESTS_QUESTION_RADIO = "input[name='testsFlag']"
  TREATMENT_QUESTION_RADIO = "input[name='treatmentPlanFlag']"

  SYMPTOMS_TEXTAREA = "textarea[name='symptomsNotes']"
  MEDICATIONS_QUESTION_TEXTAREA = "textarea[name='medicationsNotes']"
  DIAGNOSIS_QUESTION_TEXTAREA = "textarea[name='diagnosesNotes']"
  TESTS_QUESTION_TEXTAREA = "textarea[name='testsNotes']"
  TREATMENT_QUESTION_TEXTAREA = "textarea[name='treatmentPlanNotes']"
  OTHER_CONCERN_TEXTAREA = "textarea[name='item1']"

  TALKABOUT_CHARACTER_COUNTER = "#aa2 span.character-counter"
  SYMPTOMS_LABEL = "div[group-id='2'] div.panel-collapse div.panel-body ng-include div div.row:nth-of-type(3) div fieldset legend"
  MEDICATION_QUESTION_LABEL = "div[group-id='2'] div.panel-collapse div.panel-body ng-include div div.row:nth-of-type(5) div fieldset legend"
  DIAGNOSIS_QUESTION_LABEL = "div[group-id='2'] div.panel-collapse div.panel-body ng-include div div.row:nth-of-type(7) div fieldset legend"
  TESTS_QUESTION_LABEL = "div[group-id='2'] div.panel-collapse div.panel-body ng-include div div.row:nth-of-type(9) div fieldset legend"
  TREATMENT_QUESTION_LABEL = "div[group-id='2'] div.panel-collapse div.panel-body ng-include div div.row:nth-of-type(11) div fieldset legend"
  OTHER_CONCERN_LABEL =  "div[group-id='2'] div.panel-collapse div.panel-body ng-include div div.row:nth-of-type(13) div fieldset legend"

  ADD_ITEM_BUTTON = "button[ng-click='addItem()']"

  AFTER_APPOINTMENT_NOTES_INSTRUCTIONAL_TEXT =  "#aa4 p:first-child"

  GENERAL_NOTES_LABEL= "span[name='generalNotesLabel']"
  DIAGNOSIS_NOTES_LABEL = "span[name='diagnosisNotesLabel']"
  TEST_NOTES_LABEL = "input-text[label='Test:'] span[name='testsNotesLabel']"
  DIRECTIONS_NOTES_LABEL = "span[name='directionsLabel']"
  ACTIONS_NOTES_LABEL = "span[name='actionsLabel']"
  NEXT_FOLLOWUP_NOTES_LABEL = "span[name='followUpNotesLabel']"

  GENERAL_NOTES_TEXTAREA = "textarea[name='generalNotes']"
  DIAGNOSIS_NOTES_TEXTAREA = "textarea[name='diagnosisNotes']"
  TEST_NOTES_TEXTAREA = "input-text[label='Test:'] textarea[name='testsNotes']"
  DIRECTIONS_NOTES_TEXTAREA = "textarea[name='directions']"
  ACTIONS_NOTES_TEXTAREA = "textarea[name='actions']"
  NEXT_FOLLOWUP_NOTES_TEXTAREA = "textarea[name='followUpNotes']"

  NOTIFICATION__STATUS_RADIO = "input[name='notificationOption']"
  REMIND_ME_ON_THE_DATE_CHECKBOX = "input[name='notificationTriggerDate'][ng-true-value='On the date']"
  REMIND_ME_ONE_DAY_BEFORE_CHECKBOX = "input[name='notificationTriggerDate'][ng-true-value='1 day before']"
  NOTIFICATION_DELIVERY_IN_APP_CHECKBOX = "input[name='notificationDelivery'][ng-true-value='In-App']"
  NOTIFICATION_DELIVERY_EMAIL_CHECKBOX =  "input[name='notificationDelivery'][ng-true-value='Email']"

  BELL_ICON = "i.icon-notification"



  def initialize(driver)
    @driver = driver
  end

  ################
  #    Getter    #
  ################
  def getTalkAbout()
    getTextFromInput(:css, TALK_ABOUT_TEXTAREA)
  end

  def getScreenContent()
    return getElement(:css, "form[name='form']").text()
  end

  def getAppointmentStatus()
    getSelectedOptionValue(:css, APPOINTMENT_STATUS_SELECT)
  end

  def getAppointmentDate()
    getTextFromInput(:css, APPOINTMENT_DATE_INPUT)
  end

  def getAppointmentTime()
    getTextFromInput(:css, APPOINTMENT_TIME_INPUT)
  end

  def getFirstName()
    getTextFromInput(:css, PROVIDER_FIRST_NAME)
  end

  def getLastName()
    getTextFromInput(:css, PROVIDER_LAST_NAME)
  end

  def getClinic()
    getTextFromInput(:css, CLINIC_NAME)
  end

  def getReason()
    getTextFromInput(:css, APPOINTMENT_REASON)
  end

  def getTalkAbout()
    getTextFromInput(:css, TALK_ABOUT_TEXTAREA)
  end

  def getSymptomsNote()
    getTextFromInput(:css, SYMPTOMS_TEXTAREA)
  end

  def getMedicationsQuestionNote()
    getTextFromInput(:css, MEDICATIONS_QUESTION_TEXTAREA)
  end

  def getDiagnosisQuestionNote()
    getTextFromInput(:css, DIAGNOSIS_QUESTION_TEXTAREA)
  end

  def getTestsQuestionNote()
    getTextFromInput(:css, TESTS_QUESTION_TEXTAREA)
  end

  def getTreatmentPlanNote()
    getTextFromInput(:css, TREATMENT_QUESTION_TEXTAREA)
  end

  def getNthConcernNote(number)
    getTextFromInput(:css, "textarea[name='item" + number.to_s + "']")
  end

  def getNthDeleteItemButtonName(number)
    return getTextForElement(:css, "button[name='deleteItem_" + number.to_s + "']")
  end

  def getNthDeleteItemAltText(number)
    element = getElement(:css, "button[name='deleteItem_" + number.to_s + "']")
    return element.attribute("title")
  end

  def getGeneralNote()
    getTextFromInput(:css, GENERAL_NOTES_TEXTAREA)
  end

  def getAfterAppointmentDiagnosisNote()
    getTextFromInput(:css, DIAGNOSIS_NOTES_TEXTAREA)
  end

  def getTestNote()
    getTextFromInput(:css, TEST_NOTES_TEXTAREA)
  end

  def getDirectionsNote()
    getTextFromInput(:css, DIRECTIONS_NOTES_TEXTAREA)
  end

  def getActionsNote()
    getTextFromInput(:css, ACTIONS_NOTES_TEXTAREA)
  end

  def getFolloupNote()
    getTextFromInput(:css, NEXT_FOLLOWUP_NOTES_TEXTAREA)
  end

  def getCharacterCountDownTextByLabel(label)
    getTextForElement(:css, "input-text[label='" + label + "'] span[ng-if='characterCounter']")
  end

  def getFutureVAAppointmentsTableHeader(col)
      getTextForElement(:css, "table.assessment-table tbody tr:nth-of-type(1) th:nth-of-type(" + col.to_s + ")")
  end

  def getFutureVAAppointmentTableTextForRowColumn(row, col)
      row = row + 1
      getTextForElement(:css, "table.assessment-table tbody tr:nth-of-type(" + row.to_s +  ") td:nth-of-type(" + col.to_s + ")")
  end

  def getNotificationInstructionText()
    getTextForElement(:css, "div[heading='Set Notifications'] ng-include p")
  end

  def getEmailText()
    getTextForElement(:css, "div.email")
  end

  ################
  #    Setter    #
  ################

  def selectAppointmentStatus(status)
    waitForPageToFinishLoading
    setSelectBoxValue(APPOINTMENT_STATUS_SELECT, status)
  end

  def setAppointmentDate(date)
    @driver.find_element(:css, APPOINTMENT_DATE_INPUT).clear
    @driver.find_element(:css, APPOINTMENT_DATE_INPUT).send_keys(date)
  end

  def setAppointmentTime(time)
    @driver.find_element(:css, APPOINTMENT_TIME_INPUT).clear
    @driver.find_element(:css, APPOINTMENT_TIME_INPUT).send_keys(time)
  end

  def setFirstName(firstName)
    @driver.find_element(:css, PROVIDER_FIRST_NAME).clear
    @driver.find_element(:css, PROVIDER_FIRST_NAME).send_keys(firstName)
  end

  def setLastName(lastName)
    @driver.find_element(:css, PROVIDER_LAST_NAME).clear
    @driver.find_element(:css, PROVIDER_LAST_NAME).send_keys(lastName)
  end

  def setClinic(clinic)
    @driver.find_element(:css, CLINIC_NAME).clear
    @driver.find_element(:css, CLINIC_NAME).send_keys(clinic)
  end

  def setReason(reason)
    @driver.find_element(:css, APPOINTMENT_REASON).clear
    @driver.find_element(:css, APPOINTMENT_REASON).send_keys(reason)
  end

  def setTalkAbout(talkabout)
    @driver.find_element(:css, TALK_ABOUT_TEXTAREA).clear
    @driver.find_element(:css, TALK_ABOUT_TEXTAREA).send_keys(talkabout)
  end

  def isRadioButtonSelected(value, cssPath)
    element = getElement(:css, cssPath + "[type='radio'][value='" + value +"']")
    return element.selected?
  end

  def selectRadioButton(value, cssPath)
     click(:css, cssPath + "[type='radio'][value='" + value +"']")
  end

  def setSymptomsNote(note)
    @driver.find_element(:css, SYMPTOMS_TEXTAREA).clear
    @driver.find_element(:css, SYMPTOMS_TEXTAREA).send_keys(note)
  end

  def setMedicationsQuestionNote(note)
    @driver.find_element(:css, MEDICATIONS_QUESTION_TEXTAREA).clear
    @driver.find_element(:css, MEDICATIONS_QUESTION_TEXTAREA).send_keys(note)
  end

  def setDiagnosisNote(note)
    @driver.find_element(:css, DIAGNOSIS_QUESTION_TEXTAREA).clear
    @driver.find_element(:css, DIAGNOSIS_QUESTION_TEXTAREA).send_keys(note)
  end

  def setTestsNote(note)
    @driver.find_element(:css, TESTS_QUESTION_TEXTAREA).clear
    @driver.find_element(:css, TESTS_QUESTION_TEXTAREA).send_keys(note)
  end

  def setTreatmentPlanNote(note)
    @driver.find_element(:css, TREATMENT_QUESTION_TEXTAREA).clear
    @driver.find_element(:css, TREATMENT_QUESTION_TEXTAREA).send_keys(note)
  end

  def setNthConcernNote(number, note)
    @driver.find_element(:css, "textarea[name='item" + number.to_s + "']").clear
    @driver.find_element(:css, "textarea[name='item" + number.to_s + "']").send_keys(note)
  end


  def setGeneralNote(note)
    @driver.find_element(:css, GENERAL_NOTES_TEXTAREA).clear
    @driver.find_element(:css, GENERAL_NOTES_TEXTAREA).send_keys(note)
  end

  def setAfterAppointmentDiagnosisNote(note)
    @driver.find_element(:css, DIAGNOSIS_NOTES_TEXTAREA).clear
    @driver.find_element(:css, DIAGNOSIS_NOTES_TEXTAREA).send_keys(note)
  end

  def setAfterAppointmentTestNote(note)
    @driver.find_element(:css, TEST_NOTES_TEXTAREA).clear
    @driver.find_element(:css, TEST_NOTES_TEXTAREA).send_keys(note)
  end

  def setDirectionsGiveNote(note)
    @driver.find_element(:css, DIRECTIONS_NOTES_TEXTAREA).clear
    @driver.find_element(:css, DIRECTIONS_NOTES_TEXTAREA).send_keys(note)
  end

  def setActionsNote(note)
    @driver.find_element(:css, ACTIONS_NOTES_TEXTAREA).clear
    @driver.find_element(:css, ACTIONS_NOTES_TEXTAREA).send_keys(note)
  end

  def setFollwUpNote(note)
    @driver.find_element(:css, NEXT_FOLLOWUP_NOTES_TEXTAREA).clear
    @driver.find_element(:css, NEXT_FOLLOWUP_NOTES_TEXTAREA).send_keys(note)
  end


  ################
  #    etc       #
  ################


  def isNthOtherConcernsTextAreaVisible(number)
    isElementPresentAndVisible(:css, "textarea[name='item" + number.to_s + "']")
  end

  def isNthDeleteItemButtonVisible(number)
    isElementPresentAndVisible(:css, "button[name='deleteItem_" + number.to_s + "']")
  end

  def clickNthDeleteItemButton(number)
    click(:css, "button[name='deleteItem_" + number.to_s + "']")
  end

  def isSortedChronologicalOrder
    isSortedChronologicalOrder = true

    count = getElements(:css, "table.assessment-table tr").length

    previousDateTimeStr = getFutureVAAppointmentTableTextForRowColumn(1, 3)
    previousDateTime = DateTime.strptime(previousDateTimeStr.strip, format="%m/%d/%Y %I:%M %p")

    for i in 1..(count - 1)
      appmtDateTimeStr = getFutureVAAppointmentTableTextForRowColumn(i, 3)
     # puts "date " + appmtDateTimeStr  + "!!!!"  + " previous Date " + previousDateTime.to_s
      appmtDateTime = DateTime.strptime(appmtDateTimeStr.strip, format="%m/%d/%Y %I:%M %p")

      if previousDateTime > appmtDateTime
        isSortedChronologicalOrder = false
        puts "previous Notification date is greater than Current Notification date "
        break
      end

      previousDateTime = appmtDateTime
    end

    return isSortedChronologicalOrder
  end




end