require 'rubygems'
require 'selenium-webdriver'

require_relative  "../../helpers/entry_form"

class Medications < EntryForm

  MEDICATION_NAME_TEXTFIELD = ".form-control.ng-pristine.ng-scope.ng-empty.ng-invalid"
  SELECT_BOX_FREQUENCY = "select[name='Frequency"

  FIELDS = {
      'MEDICATION_NAME' => {
          'selector' => "textarea[title='Type a name or select one from the list provided. List suggestions are provided after 3 characters are typed.']",
          'type' => "text"
      },
      'STRENGTH' => {
          'selector' => "textarea[placeholder='Units of the pill or medicine (Example: 50 mg)']",
          'type' => "textarea"
      },
      'DOSE' => {
          'selector' => "input[placeholder='Example: Two (2) capsules']",
          'type' => "text"
      },
      'FREQUENCY' => {
          'selector' => "select[name='Frequency']",
          'type' => "select"
      },
      'REASON' => {
          'selector' => "input[placeholder='Describe why you are taking this medication']",
          'type' => "text"
      },
      'CURRENTLY_TAKING' => {
          'selector' => "input[name='currentlyTaking']",
          'type' => "radio"
      },
      'TAKING_WHY_NOT' => {
          'selector' => "select[name='notTakingOptions']",
          'type' => "select"
      },
      'TAKING_WHY' => {
          'selector' => "select[name='currentlyTakingOptions']",
          'type' => "select"
      },

      'SIDE_EFFECTS' => {
          'selector' => "input[name='sideEffects']",
          'type' => "radio"
      },

      'SIDE_EFFECT_DESC' => {
          'selector' => "input[name='sideEffect1']",
          'type' => "text"
      },
      'ADD_SIDE_EFFECT' => {
          'selector' => "button[ng-click='addSideEffect()']",
          'type' => "button"
      },

      'NOTES' => {
          'selector' => "input-text[label='Notes:'] textarea",
          'type' => "textarea"
      }
  }

  HEADERS = {
      'LIST' => 'Medications',
      'ADD' => 'Add Medication Entry',
      'EDIT' => 'Edit Medication Entry'
  }

  def initialize(driver)
    super(driver)
  end

  ###############
  ### GETTERS ###
  ###############

  def getScreenContent()
    return getElement(:css, "entry-form[name='form']").text()
  end

  def getFieldValue(field)
    field = FIELDS[field]

    if(field['type'].include?('text'))
      return getTextFromInput(:css, field['selector'])
    elsif(field['type'] == 'radio')
      radioButtons = getElements(:css, field['selector'])

      for i in 0...radioButtons.length
        if(radioButtons[i].selected?)
          return radioButtons[i].attribute('value')
        end
      end
    elsif(field['type'] == 'select')
      return getSelectedOptionValue(:css, field['selector'])
    end
  end

  def isFieldVisible(field)
    return isElementPresentAndVisible(:css, FIELDS[field]['selector'])
  end

  def isFieldRequired?(field)
    return isFieldRequired(:css, FIELDS[field]['selector'])
  end

  def isElementEnabled(field)
    return isElementEnabled?(:css, FIELDS[field]['selector'])
  end

  def getFieldMaxLength(field)
    field = FIELDS[field]

    if(field['type'].include?('text'))
      return getElement(:css, field['selector']).attribute('maxlength')
    else
      return '0'
    end
  end

  def getTotalSideEffectEntries()
    return getElements(:css, "multi-side-effect input-text").length
    sleep 1
  end

  def clickAddSideEffect()
    click(:css, "button[ng-click='addSideEffect()']")
  end

  ###############
  ### SETTERS ###
  ###############

  def setFieldValue(field, value)
    field = FIELDS[field]

    if(field['type'].include?('text'))
      setInput(field['selector'], value)
    elsif(field['type'] == 'radio')
      click(:css, field['selector'] + "[value='#{value}']")
    elsif(field['type'] == 'select')
      setSelectBoxValue(field['selector'], value)
    end
  end

  def enterMedicationName(text)
    waitForPageToFinishLoading
    setInput(MEDICATION_NAME_TEXTFIELD,text)
  end

  def setSideEffect(effectStr, cssPath)
    #cssPath could be e.g. "input[name='date']"
    sleep 1
    @driver.find_element(:css, cssPath).clear
    @driver.find_element(:css, cssPath).send_keys(effectStr)
    sleep 2
  end

  ################
  ### CLICKERS ###
  ################

  def clickDatePickerButton()
    click(:css, "div[name='date'] button")
  end

  def clickReviewYourInfoSaveButton()
    waitForPageToFinishLoading
    click(:css, "button[ng-click='save()']")
    sleep 2.5
  end



  #################
  ### DROPDOWNS ###
  #################

  def setSelectBoxFrequency(value)
    waitForPageToFinishLoading
    setSelectBoxValue(SELECT_BOX_FREQUENCY, value)
  end
  end



