require 'rubygems'
require 'selenium-webdriver'

require_relative  '../../helpers/entry_form'

class FamilyHistory < EntryForm

FIRST_NAME = "input[name='firstName']"
LAST_NAME = "input[name='lastName']"
DOB_TEXTFIELD = "[name='dateOfBirth'] input"
YEAR_TEXTFIELD = "[name='diagnosisDate'] input"
SELECT_BOX_RELATIVE = "select[name='Relative"
SELECT_BOX_RELATIONSHIP_TYPE = "select[name='relationshipType"
ADD_Diagnosis_BUTTON = "button[ng-click='addDiagnosis()']"


 def initialize(driver)
   super(driver)
 end

 def setDOB(date)
   waitForPageToFinishLoading
  setInput(DOB_TEXTFIELD,date)
 end

 def setYear(year)
   waitForPageToFinishLoading
  setInput(YEAR_TEXTFIELD,year)
 end

def setFirstName(first_name)
  setInput(FIRST_NAME,first_name)
end

def setLastName(last_name)
  setInput(LAST_NAME,last_name)
end

def setSelectBoxRelative(value)
  setSelectBoxValue(SELECT_BOX_RELATIVE,value)
end

def setSelectBoxRelationshipType(value)
  setSelectBoxValue(SELECT_BOX_RELATIONSHIP_TYPE,value)
end

def clickAddDiagnosisButton()
  waitForPageToFinishLoading
  # @driver.execute_script("$(\"button[ng-click='addDiagnosis()']\")[0].scrollIntoView(true)")
  click(:css, ADD_Diagnosis_BUTTON)
  @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
  @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
  @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
  @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
  @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
  @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
  @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
  @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
  @driver.execute_script("$('.container-fluid').css('overflow', 'inherit');")
  @driver.execute_script("$('.container-fluid').css('overflow', 'visible');")
  waitForPageToFinishLoading
end

def setNthStep(number, text)
  waitForPageToFinishLoading
  @driver.find_element(:css, "input[name='diagnosis" + number.to_s  + "']").clear
  @driver.find_element(:css, "input[name='diagnosis" + number.to_s  + "']").send_keys(text)
  sleep 0.2
end

def setNthStepDate(number, text)
  element = @driver.find_elements(:css,"date-control[name='diagnosisDate'] input")
  element[number].clear
  element[number].send_keys(text)
  # @driver.find_element(:css, "date-control[name='diagnosis" + number.to_s + "'] input").clear
  # @driver.find_element(:css, "date-control[name='diagnosis" + number.to_s + "'] input").send_keys(text)
  sleep 0.2
end

end