require 'rubygems'
require 'selenium-webdriver'

require_relative  "../../helpers/entry_form"

class Allergies < EntryForm

  ALLERGY_TEXTFIELD = ".form-control.ng-pristine.ng-scope.ng-empty.ng-invalid"
  PROVIDER_AND_FACILITY_TEXT = "span[name='providerFacilityLabel']"

  FIELDS = {
      'ALLERGY' => {
          'selector' => "input[name='allergy']",
          'type' => "text"
      },
      'DATE' => {
          'selector' => "input[name='date']",
          'type' => "text"
      },
      'ESTIMATED' => {
          'selector' => "input[name='estimated']",
          'type' => "radio"
      },
      'SEVERITY' => {
          'selector' => "select[name='severity']",
          'type' => "select"
      },
      'REACTION' => {
          'selector' => "textarea[name='reaction']",
          'type' => "textarea"
      },
      'DIAGNOSED' => {
          'selector' => "input[name='diagnosed']",
          'type' => "radio"
      },
      'PROVIDER_FACILITY' => {
          'selector' => "input[name='Facility']",
          'type' => "textarea"
      },
      'NOTE' => {
          'selector' => "textarea[name='note']",
          'type' => "textarea"
      }
  }

  HEADERS = {
      'LIST' => 'Allergies',
      'ADD' => 'Add Allergy Entry',
      'EDIT' => 'Edit Allergy Entry'
  }

  def initialize(driver)
    super(driver)
  end

  ###############
  ### GETTERS ###
  ###############

  def getScreenContent()
    return getElement(:css, "entry-form[name='form']").text()
  end

  def getFieldValue(field)
    field = FIELDS[field]

    if(field['type'].include?('text'))
      return getTextFromInput(:css, field['selector'])
    elsif(field['type'] == 'radio')
      radioButtons = getElements(:css, field['selector'])

      for i in 0...radioButtons.length
        if(radioButtons[i].selected?)
          return radioButtons[i].attribute('value')
        end
      end
    elsif(field['type'] == 'select')
      return getSelectedOptionValue(:css, field['selector'])
    end
  end

  def isFieldVisible(field)
    return isElementPresentAndVisible(:css, FIELDS[field]['selector'])
  end

  def isFieldRequired?(field)
    return isFieldRequired(:css, FIELDS[field]['selector'])
  end

  def getFieldMaxLength(field)
    field = FIELDS[field]

    if(field['type'].include?('text'))
      return getElement(:css, field['selector']).attribute('maxlength')
    else
      return '0'
    end
  end

  ###############
  ### SETTERS ###
  ###############

  def enterAllergy(text)
    waitForPageToFinishLoading
    setInput(ALLERGY_TEXTFIELD,text)
  end

  def setFieldValue(field, value)
    field = FIELDS[field]

    if(field['type'].include?('text'))
      setInput(field['selector'], value)
    elsif(field['type'] == 'radio')
      click(:css, field['selector'] + "[value='#{value}']")
    elsif(field['type'] == 'select')
      setSelectBoxValue(field['selector'], value)
    end
  end


  ################
  ### CLICKERS ###
  ################

  def clickDatePickerButton()
    click(:css, "div[name='date'] button")
  end

end
